/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.provider.bilibili;

import com.github.squi2rel.vp.provider.IProviderSource;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.bilibili.BiliBiliProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class BiliBiliVideoProvider
extends BiliBiliProvider {
    public static final String FETCH_URL = "https://api.bilibili.com/x/web-interface/view?bvid=%s";
    public static final String PLAY_URL = "https://api.bilibili.com/x/player/playurl?bvid=%s&cid=%s&qn=80&platform=html5";
    public static final Pattern REGEX = Pattern.compile("(?<=^|/)(BV[0-9A-Za-z]{10})(?:\\?p=(\\d+))?");
    private static final Cache<String, VideoCache> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1024L).build();

    @Override
    @Nullable
    public CompletableFuture<VideoInfo> from(String str, IProviderSource source) {
        Integer p;
        Matcher matcher = REGEX.matcher(str);
        if (!matcher.find()) {
            return null;
        }
        String bvid = matcher.group(1);
        String key = bvid + "?p=" + (p = matcher.group(2) != null ? Integer.valueOf(matcher.group(2)) : null);
        VideoCache cache = (VideoCache)CACHE.getIfPresent((Object)key);
        if (cache != null && System.currentTimeMillis() < cache.expireTime) {
            return CompletableFuture.completedFuture(new VideoInfo(source.name(), cache.title, cache.url, str, cache.expireTime, true, VLC_PARAMS));
        }
        return CompletableFuture.supplyAsync(() -> {
            HttpClient client = HttpClient.newHttpClient();
            try {
                HttpResponse<String> response = client.send(BiliBiliVideoProvider.makeRequest(String.format(FETCH_URL, bvid)), HttpResponse.BodyHandlers.ofString());
                JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject().getAsJsonObject("data");
                String cid = p == null ? root.get("cid").getAsString() : root.getAsJsonArray("pages").get(p - 1).getAsJsonObject().get("cid").getAsString();
                BiliBiliProvider.VideoMeta videoMeta = new BiliBiliProvider.VideoMeta(root.get("title").getAsString(), cid);
                if (client != null) {
                    client.close();
                }
                return videoMeta;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    source.reply(e.toString());
                    return null;
                }
            }
        }).thenApply(meta -> {
            HttpClient client = HttpClient.newHttpClient();
            try {
                HttpResponse<String> response = client.send(BiliBiliVideoProvider.makeRequest(String.format(PLAY_URL, bvid, meta.cid())), HttpResponse.BodyHandlers.ofString());
                JsonObject root = JsonParser.parseString((String)response.body()).getAsJsonObject();
                String url = root.getAsJsonObject("data").getAsJsonArray("durl").get(0).getAsJsonObject().get("url").getAsString();
                long expire = System.currentTimeMillis() + 0x6DDD00L;
                CACHE.put((Object)key, (Object)new VideoCache(meta.title(), url, expire));
                VideoInfo videoInfo = new VideoInfo(source.name(), meta.title(), url, str, expire, true, VLC_PARAMS);
                if (client != null) {
                    client.close();
                }
                return videoInfo;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    source.reply(e.toString());
                    return null;
                }
            }
        });
    }

    private record VideoCache(String title, String url, long expireTime) {
    }
}

