/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.IVideoPlayer;
import com.github.squi2rel.vp.video.MetaListener;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_6367;
import net.minecraft.class_9920;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractCameraPlayer
implements IVideoPlayer,
MetaListener {
    protected ClientVideoScreen screen;
    protected class_276 framebuffer;
    protected class_276 framebuffer1;
    protected class_276 framebuffer2;
    protected class_276 entityOutlineFramebuffer;
    protected boolean first = true;
    protected class_9920 pool;
    protected float aspect = 1.7777778f;
    protected int targetWidth = 16;
    protected int targetHeight = 9;

    public AbstractCameraPlayer(ClientVideoScreen screen) {
        this.screen = screen;
    }

    @Override
    @Nullable
    public ClientVideoScreen screen() {
        return this.screen;
    }

    @Override
    @Nullable
    public ClientVideoScreen getTrackingScreen() {
        return this.screen;
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public void init() {
        this.framebuffer1 = new class_6367(1, 1, true);
        this.framebuffer2 = new class_6367(1, 1, true);
        this.framebuffer = this.framebuffer1;
        this.entityOutlineFramebuffer = new class_6367(1, 1, true);
        this.pool = new class_9920(3);
    }

    @Override
    public void cleanup() {
        this.framebuffer1.method_1238();
        this.framebuffer2.method_1238();
        this.entityOutlineFramebuffer.method_1238();
        this.pool.method_61950();
    }

    @Override
    public void swapTexture() {
        this.framebuffer = this.first ? this.framebuffer1 : this.framebuffer2;
        this.first = !this.first;
    }

    @Override
    public void updateTexture() {
        class_1041 window = class_310.method_1551().method_22683();
        int windowWidth = window.method_4489();
        int windowHeight = window.method_4506();
        int width = windowWidth;
        int height = Math.round((float)width / this.aspect);
        if (height > windowHeight) {
            height = windowHeight;
            width = Math.round((float)height * this.aspect);
        }
        this.targetWidth = width;
        this.targetHeight = height;
        if (windowWidth != 0 && windowHeight != 0 && (this.framebuffer.field_1482 != windowWidth || this.framebuffer.field_1481 != windowHeight)) {
            this.framebuffer.method_1234(windowWidth, windowHeight);
            this.entityOutlineFramebuffer.method_1234(windowWidth, windowHeight);
        }
    }

    @Override
    public void onMetaChanged() {
        this.aspect = Float.intBitsToFloat(this.screen.meta.getOrDefault("aspect", Float.floatToIntBits(1.7777778f)));
    }

    @Override
    public int getTextureId() {
        return (this.first ? this.framebuffer1 : this.framebuffer2).method_30277();
    }

    @Override
    public void pause(boolean pause) {
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void setVolume(int volume) {
    }

    @Override
    public boolean canSetProgress() {
        return false;
    }

    @Override
    public void setProgress(long progress) {
    }

    @Override
    public long getProgress() {
        return 0L;
    }

    @Override
    public long getTotalProgress() {
        return 0L;
    }

    @Override
    public void setTargetTime(long targetTime) {
    }

    @Override
    public int getWidth() {
        return this.targetWidth;
    }

    @Override
    public int getHeight() {
        return this.targetHeight;
    }

    @Override
    public boolean flippedY() {
        return true;
    }

    @Override
    public boolean isPostUpdate() {
        return true;
    }
}

