/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.network.ByteBufUtils;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.VideoArea;
import com.github.squi2rel.vp.video.VideoScreen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientVideoArea
extends VideoArea {
    public ArrayList<Runnable> clones = new ArrayList();
    public boolean loaded = false;
    public boolean removed = false;

    public ClientVideoArea(Vector3f v1, Vector3f v2, String name, String dim) {
        super(v1, v2, name, dim);
    }

    @Override
    public ClientVideoScreen getScreen(String name) {
        return (ClientVideoScreen)super.getScreen(name);
    }

    @Override
    public synchronized void addScreen(VideoScreen screen) {
        super.addScreen(screen);
        if (this.loaded) {
            ((ClientVideoScreen)screen).load();
        }
        this.run();
    }

    public synchronized void load() {
        if (this.removed) {
            throw new IllegalStateException();
        }
        if (this.loaded) {
            return;
        }
        for (VideoScreen screen : this.screens) {
            ((ClientVideoScreen)screen).load();
        }
        this.run();
        this.loaded = true;
    }

    private synchronized void run() {
        this.clones.forEach(Runnable::run);
        this.clones.clear();
    }

    public synchronized void unload() {
        if (!this.loaded) {
            return;
        }
        for (VideoScreen screen : this.screens) {
            ((ClientVideoScreen)screen).unload();
        }
        this.loaded = false;
    }

    @Override
    public synchronized void remove() {
        this.unload();
        this.removed = true;
    }

    public synchronized void remove(String name) {
        this.screens.removeIf(s -> {
            if (Objects.equals(s.name, name)) {
                if (this.loaded) {
                    ((ClientVideoScreen)s).unload();
                }
                return true;
            }
            return false;
        });
    }

    public void afterLoad(Runnable r) {
        this.clones.add(r);
    }

    public static ClientVideoArea read(ByteBuf buf) {
        return new ClientVideoArea(ByteBufUtils.readVec3(buf), ByteBufUtils.readVec3(buf), ByteBufUtils.readString(buf, 32), ByteBufUtils.readString(buf, 256));
    }
}

