/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.VideoPlayerClient;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.ClientVideoArea;
import com.github.squi2rel.vp.video.ClonePlayer;
import com.github.squi2rel.vp.video.IVideoPlayer;
import com.github.squi2rel.vp.video.MetaListener;
import com.github.squi2rel.vp.video.VideoArea;
import com.github.squi2rel.vp.video.VideoPlayers;
import com.github.squi2rel.vp.video.VideoScreen;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ClientVideoScreen
extends VideoScreen {
    public IVideoPlayer player = null;
    private VideoInfo toPlay = null;
    private long toSeek = -1L;
    private long startTime = System.currentTimeMillis();
    public boolean interactable = true;

    public ClientVideoScreen(VideoArea area, String name, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, String source) {
        super(area, name, v1, v2, v3, v4, source);
    }

    public void updatePlaylist(VideoInfo[] target) {
        this.infos.clear();
        for (VideoInfo info : target) {
            this.infos.offer(info);
        }
    }

    @Override
    public void readMeta(ByteBuf buf) {
        super.readMeta(buf);
        this.metaChanged();
    }

    public void metaChanged() {
        this.interactable = this.meta.getOrDefault("interactable", 1) != 0;
        IVideoPlayer iVideoPlayer = this.player;
        if (iVideoPlayer instanceof MetaListener) {
            MetaListener m = (MetaListener)((Object)iVideoPlayer);
            m.onMetaChanged();
        }
    }

    public ClientVideoScreen getScreen() {
        return this.player == null ? this : this.player.screen();
    }

    public void cleanup() {
        if (this.player != null) {
            this.player.cleanup();
        }
    }

    public void draw(class_4587 matrices, class_4597.class_4598 immediate) {
        if (this.player != null) {
            this.player.draw(matrices, immediate, this);
        }
    }

    public void swapTexture() {
        if (this.player != null) {
            this.player.swapTexture();
        }
    }

    public void updateTexture() {
        if (this.player != null) {
            this.player.updateTexture();
        }
    }

    public ClientVideoScreen getTrackingScreen() {
        return this.player == null ? this : this.player.getTrackingScreen();
    }

    public void load() {
        VideoPlayerClient.screens.add(this);
        if (this.source.isEmpty()) {
            if (this.toPlay != null) {
                this.play(this.toPlay);
            }
            return;
        }
        ClientVideoScreen parent = (ClientVideoScreen)this.area.screens.stream().filter(v -> Objects.equals(v.name, this.source)).findAny().orElseThrow();
        ((ClientVideoArea)this.area).afterLoad(() -> {
            this.player = new ClonePlayer(this, parent);
        });
    }

    public void play(VideoInfo info) {
        if (this.source.isEmpty()) {
            IVideoPlayer iVideoPlayer;
            IVideoPlayer old = this.player;
            this.player = VideoPlayers.from(info, this, this.player);
            if (this.player == null) {
                return;
            }
            if (this.player != old) {
                if (old != null) {
                    old.cleanup();
                }
                this.player.init();
            }
            if ((iVideoPlayer = this.player) instanceof MetaListener) {
                MetaListener m = (MetaListener)((Object)iVideoPlayer);
                m.onMetaChanged();
            }
            if (this.toSeek > 0L) {
                this.startTime = System.currentTimeMillis() - this.toSeek;
                this.player.setTargetTime(this.toSeek);
                this.toSeek = -1L;
            } else {
                this.player.setTargetTime(-1L);
                this.startTime = System.currentTimeMillis();
            }
            this.player.play(info);
        }
    }

    public void setToPlay(VideoInfo info) {
        this.toPlay = info;
    }

    public void setToSeek(long seek) {
        this.toSeek = seek;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setProgress(long progress) {
        this.player.setProgress(progress);
        this.startTime = System.currentTimeMillis() - progress;
    }

    public void unload() {
        VideoPlayerClient.screens.remove(this);
        if (this.player != null) {
            this.player.cleanup();
        }
    }

    public boolean isPostUpdate() {
        return this.player != null && this.player.isPostUpdate();
    }

    public static ClientVideoScreen from(VideoScreen screen) {
        return new ClientVideoScreen(screen.area, screen.name, screen.p1, screen.p2, screen.p3, screen.p4, screen.source);
    }
}

