/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.IVideoPlayer;
import com.github.squi2rel.vp.video.VideoPlayer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public record ClonePlayer(ClientVideoScreen screen, ClientVideoScreen source) implements IVideoPlayer
{
    private final ClientVideoScreen screen;

    @Override
    @Nullable
    public ClientVideoScreen screen() {
        return this.source;
    }

    @Override
    @Nullable
    public ClientVideoScreen getTrackingScreen() {
        return this.screen;
    }

    @Override
    public boolean canPause() {
        return false;
    }

    @Override
    public void play(VideoInfo info) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public int getTextureId() {
        return this.source.player.getTextureId();
    }

    @Override
    public void stop() {
        if (this.source.player != null) {
            this.source.player.stop();
        }
    }

    @Override
    public void pause(boolean pause) {
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public void setVolume(int volume) {
    }

    @Override
    public boolean canSetProgress() {
        return false;
    }

    @Override
    public void setProgress(long progress) {
    }

    @Override
    public long getProgress() {
        return this.source.player == null ? 0L : this.source.player.getProgress();
    }

    @Override
    public long getTotalProgress() {
        return this.source.player == null ? 0L : this.source.player.getTotalProgress();
    }

    @Override
    public void setTargetTime(long targetTime) {
    }

    @Override
    public void init() {
    }

    @Override
    public int getWidth() {
        return this.source.player.getWidth();
    }

    @Override
    public int getHeight() {
        return this.source.player.getHeight();
    }

    @Override
    public void updateTexture() {
    }

    @Override
    public void draw(Matrix4f mat, class_4588 consumer, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float u1, float v1, float u2, float v2) {
        IVideoPlayer iVideoPlayer = this.source.player;
        if (iVideoPlayer instanceof VideoPlayer) {
            VideoPlayer p = (VideoPlayer)iVideoPlayer;
            if (p.is3d) {
                p.draw3D(mat, consumer, p1, p2, p3, p4, u1, v1, u2, v2);
                return;
            }
        }
        boolean fx = this.source.player.flippedX();
        boolean fy = this.source.player.flippedY();
        IVideoPlayer.super.draw(mat, consumer, p1, p2, p3, p4, fx ? u2 : u1, fy ? v2 : v1, fx ? u1 : u2, fy ? v1 : v2);
    }
}

