/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.ScreenRenderer;
import com.github.squi2rel.vp.VideoPlayerClient;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.MetaListener;
import com.github.squi2rel.vp.video.VideoPlayer;
import com.github.squi2rel.vp.vivecraft.Vivecraft;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_8555;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class Degree360Player
extends VideoPlayer
implements MetaListener {
    private static final Quaternionf tmp = new Quaternionf();
    protected float[] vertices;
    protected int vertexCount;
    protected class_291 buffer;
    protected boolean dirty = true;
    protected int old;
    protected float x;
    protected float y;
    protected float z;
    protected int rot;
    protected boolean skybox = false;

    public Degree360Player(ClientVideoScreen screen, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4) {
        super(screen, p1, p2, p3, p4);
    }

    @Override
    public synchronized void init() {
        super.init();
        this.buffer = new class_291(class_8555.field_54339);
    }

    @Override
    public void draw(class_4587 matrices, class_4597.class_4598 immediate, ClientVideoScreen s) {
        int gray;
        super.draw(matrices, immediate, s);
        if (this.vertices == null) {
            return;
        }
        matrices.method_22903();
        ScreenRenderer.rotateMatrix(matrices);
        if (this.skybox) {
            ScreenRenderer.skybox = true;
        } else {
            matrices.method_46416(this.x - ScreenRenderer.cameraX, this.y - ScreenRenderer.cameraY, this.z - ScreenRenderer.cameraZ);
        }
        if (this.rot != 0) {
            matrices.method_22907(tmp.rotationY((float)Math.toRadians(this.rot)));
        }
        if (this.old != (gray = (int)((double)VideoPlayerClient.config.brightness / 100.0 * 255.0))) {
            this.dirty = true;
            this.old = gray;
        }
        int color = 0xFF000000 | gray << 16 | gray << 8 | gray;
        this.buffer.method_1353();
        if (this.dirty) {
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27380, class_290.field_1575);
            for (int i = 0; i < this.vertexCount; ++i) {
                int idx = i * 5;
                bufferBuilder.method_22912(this.vertices[idx], this.vertices[idx + 1], this.vertices[idx + 2]).method_22913(this.vertices[idx + 3], this.vertices[idx + 4]).method_39415(color);
            }
            this.buffer.method_1352(bufferBuilder.method_60800());
            this.dirty = false;
        }
        if (this.is3d && Vivecraft.loaded && Vivecraft.isVRActive() && Vivecraft.isRightEye()) {
            matrices.method_22907(tmp.rotationY((float)Math.PI));
        }
        ScreenRenderer.drawTriangles(this.getTextureId(), () -> this.buffer.method_34427(matrices.method_23760().method_23761(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader()));
        matrices.method_22909();
    }

    @Override
    public void onMetaChanged() {
        super.onMetaChanged();
        this.x = this.p1.x + Float.intBitsToFloat(this.screen.meta.getOrDefault("x", 0));
        this.y = this.p1.y + Float.intBitsToFloat(this.screen.meta.getOrDefault("y", 0));
        this.z = this.p1.z + Float.intBitsToFloat(this.screen.meta.getOrDefault("z", 0));
        this.vertices = Degree360Player.genVertices(this.screen.meta.getOrDefault("radius", 10).intValue(), this.screen.meta.getOrDefault("lat", 32), this.screen.meta.getOrDefault("lon", 32), this.screen.u1, this.screen.u2, this.screen.v1, this.screen.v2);
        this.skybox = this.screen.meta.getOrDefault("skybox", 0) != 0;
        this.rot = this.screen.meta.getOrDefault("rot", 0);
        this.vertexCount = this.vertices.length / 5;
        this.dirty = true;
    }

    @Override
    public synchronized void cleanup() {
        super.cleanup();
        this.buffer.close();
    }

    protected static float[] genVertices(float radius, int latSegments, int lonSegments, float us, float ue, float vs, float ve) {
        int vertexCount = latSegments * (lonSegments + 1) * 2;
        float[] data = new float[vertexCount * 5];
        int idx = 0;
        for (int lat = 0; lat < latSegments; ++lat) {
            double theta1 = Math.PI * (double)lat / (double)latSegments;
            double theta2 = Math.PI * (double)(lat + 1) / (double)latSegments;
            for (int lon = 0; lon <= lonSegments; ++lon) {
                double phi = Math.PI * 2 * (double)lon / (double)lonSegments;
                float y1 = (float)((double)radius * Math.cos(theta1));
                float y2 = (float)((double)radius * Math.cos(theta2));
                float r1 = (float)((double)radius * Math.sin(theta1));
                float r2 = (float)((double)radius * Math.sin(theta2));
                float x1 = (float)((double)r1 * Math.cos(phi));
                float x2 = (float)((double)r2 * Math.cos(phi));
                float z1 = (float)((double)r1 * Math.sin(phi));
                float z2 = (float)((double)r2 * Math.sin(phi));
                float u = class_3532.method_16439((float)((float)lon / (float)lonSegments), (float)us, (float)ue);
                float v1 = class_3532.method_16439((float)((float)lat / (float)latSegments), (float)vs, (float)ve);
                float v2 = class_3532.method_16439((float)((float)(lat + 1) / (float)latSegments), (float)vs, (float)ve);
                data[idx++] = x1;
                data[idx++] = y1;
                data[idx++] = z1;
                data[idx++] = u;
                data[idx++] = v1;
                data[idx++] = x2;
                data[idx++] = y2;
                data[idx++] = z2;
                data[idx++] = u;
                data[idx++] = v2;
            }
        }
        return data;
    }
}

