/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.CameraRenderer;
import com.github.squi2rel.vp.mixin.client.ClientWorldAccessor;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.AbstractCameraPlayer;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.MetaListener;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class EntityCameraPlayer
extends AbstractCameraPlayer
implements MetaListener {
    public class_1297 entity;
    public UUID uuid;
    public int fov = 70;

    public EntityCameraPlayer(ClientVideoScreen screen) {
        super(screen);
    }

    @Override
    public void play(VideoInfo info) {
        this.uuid = UUID.fromString(info.rawPath());
        this.entity = EntityCameraPlayer.getEntity(this.uuid);
    }

    @Override
    public void stop() {
        this.entity = null;
        this.uuid = null;
    }

    @Override
    public void updateTexture() {
        if (this.uuid == null) {
            return;
        }
        if (this.entity == null) {
            this.entity = EntityCameraPlayer.getEntity(this.uuid);
            if (this.entity == null || this.entity.method_31481()) {
                this.entity = null;
                return;
            }
        }
        super.updateTexture();
        CameraRenderer.renderWorld(this.entity, this.pool, this.framebuffer, this.entityOutlineFramebuffer, this.aspect, this.fov);
    }

    @Override
    public void onMetaChanged() {
        super.onMetaChanged();
        this.fov = this.screen.meta.getOrDefault("fov", 70);
    }

    public static class_1297 getEntity(UUID uuid) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return null;
        }
        return (class_1297)((ClientWorldAccessor)client.field_1687).getEntityManager().method_31866().method_31808(uuid);
    }
}

