/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.ScreenRenderer;
import com.github.squi2rel.vp.VideoPlayerClient;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10142;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public interface IVideoPlayer {
    public static final Vector3f tmp1 = new Vector3f();
    public static final Vector3f tmp2 = new Vector3f();
    public static final Vector3f tmp3 = new Vector3f();
    public static final Vector3f tmp4 = new Vector3f();

    @Nullable
    public ClientVideoScreen screen();

    @Nullable
    public ClientVideoScreen getTrackingScreen();

    public boolean canPause();

    public void init();

    public static boolean accept(VideoInfo info) {
        return false;
    }

    public int getWidth();

    public int getHeight();

    public void play(VideoInfo var1);

    public void cleanup();

    public int getTextureId();

    public void stop();

    public void pause(boolean var1);

    public boolean isPaused();

    public void setVolume(int var1);

    public boolean canSetProgress();

    public void setProgress(long var1);

    public long getProgress();

    public long getTotalProgress();

    public void setTargetTime(long var1);

    default public void swapTexture() {
    }

    public void updateTexture();

    default public boolean isPostUpdate() {
        return false;
    }

    default public boolean flippedX() {
        return false;
    }

    default public boolean flippedY() {
        return false;
    }

    default public void draw(class_4587 matrices, class_4597.class_4598 immediate, ClientVideoScreen s) {
        boolean vertical;
        float scale;
        float sy;
        ClientVideoScreen screen = this.screen();
        if (screen == null || screen.player == null) {
            return;
        }
        Vector3f p1 = s.p1;
        Vector3f p2 = s.p2;
        Vector3f p3 = s.p3;
        Vector3f p4 = s.p4;
        float sx = p1.sub((Vector3fc)p4, tmp1).length() / ((float)this.getWidth() * Math.abs(s.u1 - s.u2));
        if (sx < (sy = p1.sub((Vector3fc)p2, tmp1).length() / ((float)this.getHeight() * Math.abs(s.v1 - s.v2)))) {
            scale = sx / sy;
            vertical = true;
        } else {
            scale = sy / sx;
            vertical = false;
        }
        boolean fx = this.flippedX();
        boolean fy = this.flippedY();
        matrices.method_22903();
        matrices.method_46416(-ScreenRenderer.cameraX, -ScreenRenderer.cameraY, -ScreenRenderer.cameraZ);
        Matrix4f mat = matrices.method_23760().method_23761();
        matrices.method_22909();
        class_4668.class_5942 program = new class_4668.class_5942(class_10142.field_53880);
        class_1921 layer = ScreenRenderer.getLayer(this.getTextureId());
        class_4588 consumer = immediate.getBuffer(layer);
        if (scale == 1.0f) {
            this.draw(mat, consumer, p1, p2, p3, p4, fx ? s.u2 : s.u1, fy ? s.v2 : s.v1, fx ? s.u1 : s.u2, fy ? s.v1 : s.v2);
            return;
        }
        float inv = (1.0f - scale) / 2.0f;
        if (vertical) {
            this.draw(mat, consumer, s, p1, p2, p1, p2, fx, fy, inv, p3.lerp((Vector3fc)p4, inv, tmp3), p4.lerp((Vector3fc)p3, inv, tmp4));
        } else {
            this.draw(mat, consumer, s, p1, p2, p3, p4, fx, fy, inv, p3.lerp((Vector3fc)p2, inv, tmp3), p4.lerp((Vector3fc)p1, inv, tmp4));
        }
        immediate.method_22994(layer);
    }

    private void draw(Matrix4f mat, class_4588 consumer, ClientVideoScreen s, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, boolean fx, boolean fy, float inv, Vector3f lerp, Vector3f lerp2) {
        this.draw(mat, consumer, p1.lerp((Vector3fc)p4, inv, tmp1), p2.lerp((Vector3fc)p3, inv, tmp2), lerp, lerp2, fx ? s.u2 : s.u1, fy ? s.v2 : s.v1, fx ? s.u1 : s.u2, fy ? s.v1 : s.v2);
    }

    default public void draw(Matrix4f mat, class_4588 consumer, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float u1, float v1, float u2, float v2) {
        int gray = (int)((double)VideoPlayerClient.config.brightness / 100.0 * 255.0);
        int color = 0xFF000000 | gray << 16 | gray << 8 | gray;
        consumer.method_22918(mat, p1.x, p1.y, p1.z).method_22913(u1, v1).method_39415(color);
        consumer.method_22918(mat, p2.x, p2.y, p2.z).method_22913(u1, v2).method_39415(color);
        consumer.method_22918(mat, p3.x, p3.y, p3.z).method_22913(u2, v2).method_39415(color);
        consumer.method_22918(mat, p4.x, p4.y, p4.z).method_22913(u2, v1).method_39415(color);
    }
}

