/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL21;

@Environment(value=EnvType.CLIENT)
public class PBOManager {
    private final int[] id = new int[2];
    private boolean allocated = false;
    private boolean next = false;
    private ByteBuffer buffer;
    private final ReentrantLock lock = new ReentrantLock();

    private static void initPBO(int id, int width, int height) {
        GL21.glBindBuffer((int)35052, (int)id);
        GL21.glBufferData((int)35052, (long)((long)(width * height) * 4L), (int)35040);
    }

    public void init(int width, int height) {
        if (!this.allocated) {
            GL21.glGenBuffers((int[])this.id);
            this.allocated = true;
        }
        int prevPBO = GL21.glGetInteger((int)35055);
        PBOManager.initPBO(this.id[0], width, height);
        PBOManager.initPBO(this.id[1], width, height);
        GL21.glBindBuffer((int)35052, (int)prevPBO);
        this.buffer = ByteBuffer.allocateDirect(width * height * 4);
    }

    public void release() {
        this.lock.lock();
        if (this.allocated) {
            int[] i = new int[]{this.id[0], this.id[1]};
            class_310.method_1551().execute(() -> GL21.glDeleteBuffers((int[])i));
            this.allocated = false;
            this.buffer = null;
        }
        this.lock.unlock();
    }

    public void bind() {
        if (!this.allocated) {
            throw new IllegalStateException("PBO not allocated");
        }
        GL21.glBindBuffer((int)35052, (int)(this.next ? this.id[1] : this.id[0]));
        this.next = !this.next;
    }

    public ByteBuffer map() {
        this.lock.lock();
        if (!this.allocated) {
            throw new IllegalStateException("PBO not allocated");
        }
        return GL21.glMapBuffer((int)35052, (int)35001, (long)this.buffer.capacity(), (ByteBuffer)this.buffer.position(0));
    }

    public void unmap() {
        GL21.glUnmapBuffer((int)35052);
        this.lock.unlock();
    }

    public boolean allocated() {
        return this.allocated;
    }
}

