/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.IVideoListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;

public class StreamListener
implements IVideoListener {
    private static final ConcurrentHashMap<MediaPlayer, StreamListener> references = new ConcurrentHashMap();
    public static MediaPlayerFactory factory;
    private MediaPlayer player;
    private Consumer<Boolean> playing = seekable -> {};
    private Runnable stopped = () -> {};
    private Runnable errored = () -> {};
    private Runnable timeout = () -> {};
    private final VideoInfo info;
    private static final MediaPlayerEventAdapter callback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void finish(MediaPlayer mediaPlayer) {
        StreamListener listener = references.get(mediaPlayer);
        if (listener == null) {
            return;
        }
        StreamListener streamListener = listener;
        synchronized (streamListener) {
            if (listener.player == null) {
                return;
            }
            references.remove(mediaPlayer);
            listener.player = null;
            listener.stopped.run();
        }
        mediaPlayer.submit(() -> ((MediaPlayer)mediaPlayer).release());
    }

    public StreamListener(VideoInfo info) {
        this.info = info;
        this.player = factory.mediaPlayers().newMediaPlayer();
        StreamListener.runAsync(() -> {
            try {
                Thread.sleep(10000L);
                if (this.isPlaying()) {
                    return;
                }
                MediaPlayer p = this.player;
                StreamListener streamListener = this;
                synchronized (streamListener) {
                    if (this.player == null) {
                        return;
                    }
                    references.remove(p);
                    this.player = null;
                    this.timeout.run();
                    this.stopped.run();
                }
                p.submit(() -> {
                    p.controls().stop();
                    p.release();
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.player.events().addMediaPlayerEventListener((MediaPlayerEventListener)callback);
    }

    public static boolean accept(VideoInfo info) {
        return !info.path().isEmpty();
    }

    @Override
    public long getProgress() {
        return this.player.status().time();
    }

    @Override
    public boolean isPlaying() {
        return this.player != null;
    }

    @Override
    public void playing(Consumer<Boolean> playing) {
        this.playing = playing;
    }

    @Override
    public void stopped(Runnable stopped) {
        this.stopped = stopped;
    }

    @Override
    public void errored(Runnable errored) {
        this.errored = errored;
    }

    @Override
    public void timeout(Runnable timeout) {
        this.timeout = timeout;
    }

    @Override
    public void listen() {
        references.put(this.player, this);
        this.player.media().play(this.info.path().replace("rtspt://", "rtsp://"), this.info.params());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        MediaPlayer p = this.player;
        StreamListener streamListener = this;
        synchronized (streamListener) {
            if (this.player == null) {
                return;
            }
            references.remove(this.player);
            this.player = null;
        }
        p.submit(() -> {
            p.controls().stop();
            p.release();
        });
    }

    public static void runAsync(Runnable runnable) {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        t.start();
    }

    public static void load() {
        factory = new MediaPlayerFactory(new String[]{"--no-video", "--aout=none", "--no-xlib", "--intf=dummy", "--quiet"});
    }

    static {
        callback = new MediaPlayerEventAdapter(){

            public void playing(MediaPlayer mediaPlayer) {
                StreamListener listener = references.get(mediaPlayer);
                if (listener == null) {
                    return;
                }
                listener.playing.accept(listener.player.status().isSeekable());
            }

            public void stopped(MediaPlayer mediaPlayer) {
                StreamListener.finish(mediaPlayer);
            }

            public void finished(MediaPlayer mediaPlayer) {
                StreamListener.finish(mediaPlayer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void error(MediaPlayer mediaPlayer) {
                StreamListener listener = references.get(mediaPlayer);
                if (listener == null) {
                    return;
                }
                StreamListener streamListener = listener;
                synchronized (streamListener) {
                    if (listener.player == null) {
                        return;
                    }
                    references.remove(mediaPlayer);
                    listener.errored.run();
                    listener.stopped.run();
                    listener.player = null;
                    mediaPlayer.submit(() -> {
                        mediaPlayer.controls().stop();
                        mediaPlayer.release();
                    });
                }
            }
        };
    }
}

