/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.network.ByteBufUtils;
import com.github.squi2rel.vp.video.VideoScreen;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_243;
import org.joml.Vector3f;

public class VideoArea {
    public Vector3f min = new Vector3f();
    public Vector3f max = new Vector3f();
    public String name;
    public String dim;
    private transient HashSet<UUID> players;
    public ArrayList<VideoScreen> screens = new ArrayList();

    public VideoArea(Vector3f v1, Vector3f v2, String name, String dim) {
        this.min.set(Math.min(v1.x, v2.x), Math.min(v1.y, v2.y), Math.min(v1.z, v2.z));
        this.max.set(Math.max(v1.x, v2.x), Math.max(v1.y, v2.y), Math.max(v1.z, v2.z));
        this.name = name;
        this.dim = dim;
    }

    public void afterLoad() {
        for (VideoScreen screen : this.screens) {
            screen.area = this;
            screen.initServer();
        }
    }

    public synchronized void remove() {
        for (VideoScreen screen : this.screens) {
            screen.remove();
        }
    }

    public void initServer() {
        this.players = new HashSet();
    }

    public boolean inBounds(class_243 v) {
        return (double)this.min.x <= v.field_1352 && (double)this.min.y <= v.field_1351 && (double)this.min.z <= v.field_1350 && (double)this.max.x >= v.field_1352 && (double)this.max.y >= v.field_1351 && (double)this.max.z >= v.field_1350;
    }

    public synchronized boolean addPlayer(UUID uuid) {
        return this.players.add(uuid);
    }

    public synchronized boolean removePlayer(UUID uuid) {
        boolean removed = this.players.remove(uuid);
        if (removed) {
            for (VideoScreen screen : this.screens) {
                screen.removePlayer(uuid);
            }
        }
        return removed;
    }

    public synchronized boolean containsPlayer(UUID uuid) {
        return this.players.contains(uuid);
    }

    public synchronized void forEachPlayer(Consumer<UUID> consumer) {
        for (UUID player : this.players) {
            consumer.accept(player);
        }
    }

    public synchronized boolean hasPlayer() {
        return !this.players.isEmpty();
    }

    public synchronized int players() {
        return this.players.size();
    }

    public void addScreen(VideoScreen screen) {
        screen.area = this;
        this.screens.add(screen);
    }

    public VideoScreen getScreen(String name) {
        for (VideoScreen screen : this.screens) {
            if (!screen.name.equals(name)) continue;
            return screen;
        }
        return null;
    }

    public VideoScreen removeScreen(String name) {
        VideoScreen screen = this.getScreen(name);
        if (screen != null) {
            screen.remove();
            this.screens.remove(screen);
            return screen;
        }
        return null;
    }

    public static VideoArea from(Vector3f v, Vector3f v2, String name, String dim) {
        return new VideoArea(v, v2, name, dim);
    }

    public static void write(ByteBuf buf, VideoArea area) {
        ByteBufUtils.writeVec3(buf, area.min);
        ByteBufUtils.writeVec3(buf, area.max);
        ByteBufUtils.writeString(buf, area.name);
        ByteBufUtils.writeString(buf, area.dim);
    }
}

