/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.VideoPlayerClient;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.video.ClientVideoScreen;
import com.github.squi2rel.vp.video.IVideoPlayer;
import com.github.squi2rel.vp.video.MetaListener;
import com.github.squi2rel.vp.video.VideoQuad;
import com.github.squi2rel.vp.video.VlcDecoder;
import com.github.squi2rel.vp.vivecraft.Vivecraft;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class VideoPlayer
implements IVideoPlayer,
MetaListener {
    public final Vector3f p1;
    public final Vector3f p2;
    public final Vector3f p3;
    public final Vector3f p4;
    protected VlcDecoder decoder;
    protected VideoQuad quad;
    protected boolean initialized = false;
    protected boolean changed = false;
    protected long targetTime = -1L;
    protected boolean is3d = false;
    public int videoWidth;
    public int videoHeight;
    protected final ClientVideoScreen screen;

    public VideoPlayer(ClientVideoScreen screen, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4) {
        this.screen = screen;
        this.p1 = new Vector3f((Vector3fc)p1);
        this.p2 = new Vector3f((Vector3fc)p2);
        this.p3 = new Vector3f((Vector3fc)p3);
        this.p4 = new Vector3f((Vector3fc)p4);
    }

    @Override
    @Nullable
    public ClientVideoScreen screen() {
        return this.screen;
    }

    @Override
    @Nullable
    public ClientVideoScreen getTrackingScreen() {
        return this.screen;
    }

    @Override
    public void updateTexture() {
        if (this.changed || !this.initialized) {
            return;
        }
        ByteBuffer buf = this.decoder.decodeNextFrame();
        if (buf == null || buf.capacity() == 0) {
            return;
        }
        this.quad.updateTexture(buf);
    }

    @Override
    public synchronized void init() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.decoder = new VlcDecoder();
        this.decoder.onSizeChanged((w, h) -> {
            this.changed = true;
            class_310.method_1551().execute(() -> {
                this.videoWidth = w;
                this.videoHeight = h;
                this.quad.resize((int)w, (int)h);
                this.changed = false;
            });
        });
        this.decoder.onFinish(() -> class_310.method_1551().execute(() -> this.quad.resize(1, 1)));
        this.quad = new VideoQuad(this.decoder.getWidth(), this.decoder.getHeight());
        this.initialized = true;
    }

    @Override
    public int getWidth() {
        return this.is3d ? this.videoWidth / 2 : this.videoWidth;
    }

    @Override
    public int getHeight() {
        return this.videoHeight;
    }

    @Override
    public void play(VideoInfo info) {
        if (this.targetTime > 0L) {
            String[] params = info.params();
            String[] newParams = new String[params.length + 1];
            System.arraycopy(params, 0, newParams, 0, params.length);
            newParams[newParams.length - 1] = ":start-time=" + (float)this.targetTime / 1000.0f;
            info = new VideoInfo(info.playerName(), info.name(), info.path(), info.rawPath(), info.expire(), info.seekable(), newParams);
        }
        this.decoder.onPlay(() -> this.decoder.submit(() -> this.decoder.setVolume(VideoPlayerClient.config.volume)));
        this.decoder.init(info);
    }

    @Override
    public int getTextureId() {
        if (this.initialized) {
            return this.quad.getTextureId();
        }
        return -1;
    }

    @Override
    public void stop() {
        this.decoder.stop();
        this.quad.stop();
    }

    @Override
    public boolean canPause() {
        return this.decoder.canPause();
    }

    @Override
    public void pause(boolean pause) {
        this.decoder.pause(pause);
    }

    @Override
    public boolean isPaused() {
        return this.decoder.isPaused();
    }

    @Override
    public void setVolume(int volume) {
        this.decoder.setVolume(volume);
    }

    @Override
    public boolean canSetProgress() {
        return this.decoder.canSetProgress();
    }

    @Override
    public void setProgress(long progress) {
        this.decoder.setProgress(progress);
    }

    @Override
    public long getProgress() {
        return this.decoder.getProgress();
    }

    @Override
    public long getTotalProgress() {
        return this.decoder.getTotalProgress();
    }

    @Override
    public void setTargetTime(long targetTime) {
        this.targetTime = targetTime;
    }

    @Override
    public synchronized void cleanup() {
        this.initialized = false;
        if (this.decoder != null) {
            this.decoder.cleanup();
        }
        if (this.quad != null) {
            this.quad.cleanup();
        }
    }

    @Override
    public void onMetaChanged() {
        this.is3d = this.screen.meta.getOrDefault("3d", 0) != 0;
    }

    @Override
    public void draw(Matrix4f mat, class_4588 consumer, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float u1, float v1, float u2, float v2) {
        if (this.is3d) {
            this.draw3D(mat, consumer, p1, p2, p3, p4, u1, v1, u2, v2);
            return;
        }
        IVideoPlayer.super.draw(mat, consumer, p1, p2, p3, p4, u1, v1, u2, v2);
    }

    public void draw3D(Matrix4f mat, class_4588 consumer, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, float u1, float v1, float u2, float v2) {
        if (Vivecraft.loaded && Vivecraft.isRightEye()) {
            IVideoPlayer.super.draw(mat, consumer, p1, p2, p3, p4, (u1 + u2) / 2.0f, v1, u2, v2);
        } else {
            IVideoPlayer.super.draw(mat, consumer, p1, p2, p3, p4, u1, v1, (u1 + u2) / 2.0f, v2);
        }
    }
}

