/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.video.PBOManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL21;

@Environment(value=EnvType.CLIENT)
public class VideoQuad {
    private int textureId;
    private int width;
    private int height;
    private boolean textureInitialized = false;
    private final PBOManager pbo = new PBOManager();

    public VideoQuad(int width, int height) {
        this.width = width;
        this.height = height;
        this.initializeTexture();
        this.pbo.init(width, height);
    }

    public synchronized void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.regenTexture();
        this.pbo.init(width, height);
    }

    private void initializeTexture() {
        this.textureId = GL21.glGenTextures();
        this.regenTexture();
    }

    public synchronized void stop() {
        this.pbo.release();
    }

    private void regenTexture() {
        RenderSystem.bindTexture((int)this.textureId);
        GL21.glTexParameteri((int)3553, (int)10242, (int)33648);
        GL21.glTexParameteri((int)3553, (int)10243, (int)33648);
        GL21.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL21.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL21.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        RenderSystem.bindTexture((int)0);
        this.textureInitialized = true;
    }

    public synchronized void updateTexture(ByteBuffer frameData) {
        if (!this.pbo.allocated()) {
            return;
        }
        RenderSystem.bindTexture((int)this.textureId);
        RenderSystem.pixelStore((int)3317, (int)4);
        RenderSystem.pixelStore((int)3314, (int)this.width);
        RenderSystem.pixelStore((int)3315, (int)0);
        RenderSystem.pixelStore((int)3316, (int)0);
        int prevPBO = GL21.glGetInteger((int)35055);
        this.pbo.bind();
        ByteBuffer buf = this.pbo.map();
        if (buf.remaining() == frameData.remaining()) {
            buf.put(frameData);
        }
        this.pbo.unmap();
        GL21.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (long)0L);
        GL21.glBindBuffer((int)35052, (int)prevPBO);
        RenderSystem.bindTexture((int)0);
    }

    public void cleanup() {
        if (this.textureInitialized) {
            class_310.method_1551().execute(() -> {
                GL21.glDeleteTextures((int)this.textureId);
                this.pbo.release();
            });
            this.textureInitialized = false;
        }
    }

    public int getTextureId() {
        return this.textureId;
    }
}

