/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.DataHolder;
import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.network.ByteBufUtils;
import com.github.squi2rel.vp.network.ServerPacketHandler;
import com.github.squi2rel.vp.provider.NamedProviderSource;
import com.github.squi2rel.vp.provider.VideoInfo;
import com.github.squi2rel.vp.provider.VideoProviders;
import com.github.squi2rel.vp.video.IVideoListener;
import com.github.squi2rel.vp.video.VideoArea;
import com.github.squi2rel.vp.video.VideoListeners;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.class_3324;
import org.joml.Vector3f;

public class VideoScreen {
    public static final int MAX_NAME_LENGTH = 32;
    public transient VideoArea area;
    public String name;
    public Vector3f p1;
    public Vector3f p2;
    public Vector3f p3;
    public Vector3f p4;
    public float u1 = 0.0f;
    public float v1 = 0.0f;
    public float u2 = 1.0f;
    public float v2 = 1.0f;
    public String source;
    public float skipPercent = 0.5f;
    public Map<String, Integer> meta = new HashMap<String, Integer>();
    public transient ArrayDeque<VideoInfo> infos = new ArrayDeque();
    private transient IVideoListener now;
    private transient CompletableFuture<IVideoListener> nextTask;
    private transient HashSet<UUID> skipped;
    private transient ReentrantLock lock;

    public VideoScreen(VideoArea area, String name, Vector3f p1, Vector3f p2, Vector3f p3, Vector3f p4, String source) {
        this.area = area;
        this.name = name;
        this.p1 = p1;
        this.p2 = p2;
        this.p3 = p3;
        this.p4 = p4;
        this.source = source;
    }

    public void readMeta(ByteBuf buf) {
        int size = buf.readUnsignedByte();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < size; ++i) {
            map.put(ByteBufUtils.readString(buf, 32), buf.readInt());
        }
        this.meta = map;
    }

    public void writeMeta(ByteBuf buf) {
        buf.writeByte(this.meta.size());
        for (Map.Entry<String, Integer> entry : this.meta.entrySet()) {
            ByteBufUtils.writeString(buf, entry.getKey());
            buf.writeInt(entry.getValue().intValue());
        }
    }

    public void syncInfo() {
        class_3324 pm = DataHolder.server.method_3760();
        this.lock();
        byte[] data = ServerPacketHandler.updatePlaylist(List.of(this));
        this.unlock();
        this.area.forEachPlayer(u -> ServerPacketHandler.sendTo(pm.method_14602(u), data));
    }

    public void initServer() {
        this.skipped = new HashSet();
        this.infos = new ArrayDeque();
        this.lock = new ReentrantLock();
        this.playNext();
    }

    public synchronized void addInfo(VideoInfo info) {
        VideoPlayerMain.LOGGER.info("added info: {} {} {}", new Object[]{info.playerName(), info.name(), info.path()});
        this.lock();
        this.infos.offer(info);
        this.unlock();
        this.playNext();
        this.syncInfo();
    }

    public long getProgress() {
        VideoInfo info = this.infos.peek();
        if (this.now == null || info == null || !info.seekable()) {
            return -1L;
        }
        return this.now.getProgress();
    }

    public synchronized void voteSkip(UUID uuid) {
        this.skipped.add(uuid);
        if (this.shouldSkip()) {
            this.skip();
        }
    }

    public synchronized void setSkipPercent(float skipPercent) {
        this.skipPercent = skipPercent;
        if (this.shouldSkip()) {
            this.skip();
        }
    }

    private boolean shouldSkip() {
        return (float)this.skipped.size() > (float)this.area.players() * this.skipPercent;
    }

    public synchronized void skip() {
        this.lock();
        if (this.nextTask != null) {
            this.nextTask.cancel(true);
            this.nextTask = null;
        }
        if (this.now != null) {
            this.now.cancel();
            this.now = null;
        }
        this.infos.poll();
        this.unlock();
        this.playNext();
        this.syncInfo();
    }

    public synchronized void removePlayer(UUID uuid) {
        this.skipped.remove(uuid);
        if (this.shouldSkip()) {
            this.skip();
        }
    }

    public synchronized void remove() {
        this.lock();
        if (this.now != null) {
            this.now.cancel();
        }
        if (this.nextTask != null) {
            this.nextTask.cancel(true);
        }
        this.now = null;
        this.nextTask = null;
        this.infos.clear();
        this.unlock();
        this.syncInfo();
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public synchronized void playNext() {
        if (this.nextTask != null && !this.nextTask.isDone() || this.now != null && this.now.isPlaying()) {
            return;
        }
        this.now = null;
        this.skipped.clear();
        this.nextTask = CompletableFuture.supplyAsync(() -> {
            this.lock();
            VideoInfo info = this.infos.peek();
            this.unlock();
            if (info == null) {
                if (this.area.hasPlayer()) {
                    class_3324 pm = DataHolder.server.method_3760();
                    byte[] data = ServerPacketHandler.skip(this);
                    DataHolder.lock();
                    this.area.forEachPlayer(u -> ServerPacketHandler.sendTo(pm.method_14602(u), data));
                    DataHolder.unlock();
                    this.syncInfo();
                }
                return null;
            }
            VideoPlayerMain.LOGGER.info("playing info: {} {} {}", new Object[]{info.playerName(), info.name(), info.path()});
            if (info.expire() > 0L && System.currentTimeMillis() > info.expire()) {
                try {
                    VideoPlayerMain.LOGGER.info("expired, {} {}", (Object)info.expire(), (Object)info.name());
                    info = Objects.requireNonNull(VideoProviders.from(info.rawPath(), new NamedProviderSource(info.playerName()))).get();
                }
                catch (Exception pm) {
                    // empty catch block
                }
            }
            if (info == null || info.expire() > 0L && System.currentTimeMillis() > info.expire()) {
                return null;
            }
            if (this.area.hasPlayer()) {
                class_3324 pm = DataHolder.server.method_3760();
                byte[] data = ServerPacketHandler.request(this, info);
                DataHolder.lock();
                this.area.forEachPlayer(u -> ServerPacketHandler.sendTo(pm.method_14602(u), data));
                DataHolder.unlock();
            }
            this.syncInfo();
            if (!info.rawPath().isEmpty()) {
                try {
                    info = Objects.requireNonNull(VideoProviders.from(info.rawPath(), new NamedProviderSource(info.playerName()))).get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.now = VideoListeners.from(info);
            return this.now;
        });
        this.nextTask.thenAccept(s -> {
            if (s == null) {
                return;
            }
            VideoScreen videoScreen = this;
            synchronized (videoScreen) {
                this.nextTask = null;
                s.stopped(() -> {
                    this.lock();
                    this.infos.poll();
                    this.unlock();
                    this.playNext();
                });
                s.listen();
            }
        });
    }

    public VideoInfo currentPlaying() {
        return this.infos.peek();
    }

    public static VideoScreen read(ByteBuf buf, VideoArea area) {
        return new VideoScreen(area, ByteBufUtils.readString(buf, 32), ByteBufUtils.readVec3(buf), ByteBufUtils.readVec3(buf), ByteBufUtils.readVec3(buf), ByteBufUtils.readVec3(buf), ByteBufUtils.readString(buf, 32));
    }

    public static void write(ByteBuf buf, VideoScreen screen) {
        ByteBufUtils.writeString(buf, screen.name);
        ByteBufUtils.writeVec3(buf, screen.p1);
        ByteBufUtils.writeVec3(buf, screen.p2);
        ByteBufUtils.writeVec3(buf, screen.p3);
        ByteBufUtils.writeVec3(buf, screen.p4);
        ByteBufUtils.writeString(buf, screen.source);
    }
}

