/*
 * Decompiled with CFR 0.152.
 */
package com.github.squi2rel.vp.video;

import com.github.squi2rel.vp.VideoPlayerMain;
import com.github.squi2rel.vp.provider.VideoInfo;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.BufferUtils;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.base.MediaPlayerEventListener;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import uk.co.caprica.vlcj.player.embedded.videosurface.CallbackVideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurface;
import uk.co.caprica.vlcj.player.embedded.videosurface.VideoSurfaceAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallbackAdapter;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

@Environment(value=EnvType.CLIENT)
public class VlcDecoder {
    private static MediaPlayerFactory factory;
    private final EmbeddedMediaPlayer mediaPlayer;
    private int width = 1;
    private int height = 1;
    private final TextureRenderFormatCallback callback = new TextureRenderFormatCallback();
    private ByteBuffer buffer;
    private ByteBuffer glBuffer;
    private BiConsumer<Integer, Integer> sizeListener = (a, b) -> {};
    private Runnable playListener = () -> {};
    private Runnable finishListener = () -> {};

    public VlcDecoder() {
        this.mediaPlayer = factory.mediaPlayers().newEmbeddedMediaPlayer();
        this.mediaPlayer.videoSurface().set((VideoSurface)new CallbackVideoSurface((BufferFormatCallback)new BufferFormatCallbackAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                if (VlcDecoder.this.buffer == null || VlcDecoder.this.glBuffer == null || VlcDecoder.this.width != sourceWidth || VlcDecoder.this.height != sourceHeight) {
                    TextureRenderFormatCallback textureRenderFormatCallback = VlcDecoder.this.callback;
                    synchronized (textureRenderFormatCallback) {
                        VlcDecoder.this.sizeListener.accept(sourceWidth, sourceHeight);
                        VlcDecoder.this.width = sourceWidth;
                        VlcDecoder.this.height = sourceHeight;
                        int bytes = sourceWidth * sourceHeight * 4;
                        VlcDecoder.this.glBuffer = BufferUtils.createByteBuffer((int)bytes);
                        VlcDecoder.this.buffer = BufferUtils.createByteBuffer((int)bytes);
                        VlcDecoder.this.sizeListener.accept(VlcDecoder.this.width, VlcDecoder.this.height);
                    }
                }
                return new RGBAFormat(sourceWidth, sourceHeight);
            }
        }, (RenderCallback)this.callback, true, (VideoSurfaceAdapter & Serializable)(a, b) -> {}));
        this.mediaPlayer.events().addMediaPlayerEventListener((MediaPlayerEventListener)new MediaPlayerEventAdapter(){

            public void playing(MediaPlayer mediaPlayer) {
                VlcDecoder.this.playListener.run();
            }

            public void finished(MediaPlayer mediaPlayer) {
                VlcDecoder.this.finishListener.run();
            }

            public void error(MediaPlayer mediaPlayer) {
                mediaPlayer.submit(() -> mediaPlayer.controls().stop());
            }
        });
    }

    public static void load() {
        VideoPlayerMain.LOGGER.info("loading library");
        factory = new MediaPlayerFactory();
        VideoPlayerMain.LOGGER.info("loaded library");
    }

    public void onSizeChanged(BiConsumer<Integer, Integer> sizeListener) {
        this.sizeListener = sizeListener;
    }

    public void onFinish(Runnable finishListener) {
        this.finishListener = finishListener;
    }

    public void onPlay(Runnable playListener) {
        this.playListener = playListener;
    }

    public void submit(Runnable r) {
        this.mediaPlayer.submit(r);
    }

    public void init(VideoInfo info) {
        this.mediaPlayer.media().play(info.path().replace("rtspt://", "rtsp://"), info.params());
    }

    public ByteBuffer decodeNextFrame() {
        return this.callback.copy();
    }

    public void cleanup() {
        this.stop();
        this.mediaPlayer.submit(() -> ((EmbeddedMediaPlayer)this.mediaPlayer).release());
    }

    public void stop() {
        this.mediaPlayer.submit(() -> this.mediaPlayer.controls().stop());
        this.glBuffer = null;
        this.buffer = null;
    }

    public boolean canPause() {
        return this.mediaPlayer.status().canPause();
    }

    public void pause(boolean pause) {
        this.mediaPlayer.controls().setPause(pause);
    }

    public boolean isPaused() {
        return this.mediaPlayer.status().isPlaying();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setVolume(int volume) {
        this.mediaPlayer.audio().setVolume(volume);
    }

    public boolean canSetProgress() {
        return this.mediaPlayer.status().isSeekable();
    }

    public void setProgress(long progress) {
        this.mediaPlayer.controls().setTime(progress);
    }

    public long getProgress() {
        return this.mediaPlayer.status().time();
    }

    public long getTotalProgress() {
        return this.mediaPlayer.status().length();
    }

    @Environment(value=EnvType.CLIENT)
    private class TextureRenderFormatCallback
    implements RenderCallback {
        private static final ByteBuffer empty = BufferUtils.createByteBuffer((int)0);

        private TextureRenderFormatCallback() {
        }

        public synchronized ByteBuffer copy() {
            if (VlcDecoder.this.buffer == null || VlcDecoder.this.glBuffer == null || VlcDecoder.this.buffer.capacity() != VlcDecoder.this.glBuffer.remaining()) {
                return empty;
            }
            VlcDecoder.this.buffer.position(0).put(VlcDecoder.this.glBuffer).flip();
            return VlcDecoder.this.buffer;
        }

        public void lock(MediaPlayer m) {
        }

        public synchronized void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat, int displayWidth, int displayHeight) {
            if (VlcDecoder.this.glBuffer == null) {
                return;
            }
            VlcDecoder.this.glBuffer.position(0).put(nativeBuffers[0].position(0).limit(VlcDecoder.this.glBuffer.capacity())).flip();
        }

        public void unlock(MediaPlayer m) {
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class RGBAFormat
    extends BufferFormat {
        public RGBAFormat(int width, int height) {
            super("RGBA", width, height, new int[]{width * 4}, new int[]{height});
        }
    }
}

