/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.parcoolskill.handler;

import com.xm666.parcoolskill.network.BulletTimePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(modid="parcoolskill")
public class BulletTimeHandler {
    public static Ticker clientTicker = new Ticker();
    public static Ticker serverTicker = new Ticker();
    public static boolean modifyRunsNormally = true;
    public static boolean modifyGameTimeDeltaPartialTick = true;
    public static boolean canRunsNormally = true;

    @SubscribeEvent
    static void onClientTick(ClientTickEvent.Pre event) {
        if (!Minecraft.getInstance().isPaused()) {
            clientTicker.tick();
        }
    }

    @SubscribeEvent
    static void onServerTick(ServerTickEvent.Pre event) {
        serverTicker.tick();
    }

    public static void addScale(float timeScale, int timeScaleTicks) {
        BulletTimeHandler.addScale(serverTicker, timeScale, timeScaleTicks);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BulletTimePayload(timeScale, timeScaleTicks), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handlePayload(BulletTimePayload payload, IPayloadContext context) {
        BulletTimeHandler.addScale(clientTicker, payload.timeScale(), payload.timeScaleTicks());
    }

    public static void addScale(Ticker ticker, float timeScale, int timeScaleTicks) {
        ticker.timeScale = ticker.timeScaleTicks > 0 ? Math.min(ticker.timeScale, timeScale) : timeScale;
        ticker.timeScaleTicks = Math.min(ticker.timeScaleTicks + timeScaleTicks, 600);
    }

    public static class Ticker {
        public float timeScale;
        public int timeScaleTicks;
        public float partialTick;
        public boolean runTick;

        public float getDefaultTimeScale() {
            return 1.0f;
        }

        public float getTimeScale() {
            return this.timeScaleTicks > 0 ? this.timeScale : this.getDefaultTimeScale();
        }

        public void tick() {
            if (this.timeScaleTicks > 0) {
                --this.timeScaleTicks;
            }
            this.partialTick += this.getTimeScale();
            this.runTick = (double)this.partialTick >= 1.0;
            this.partialTick -= (float)Mth.floor((float)this.partialTick);
        }
    }
}

