/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.parcoolskill.handler;

import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.Action;
import com.xm666.parcoolskill.Config;
import com.xm666.parcoolskill.action.SkillSlide;
import com.xm666.parcoolskill.damage.DamageTypes;
import com.xm666.parcoolskill.effect.Effects;
import com.xm666.parcoolskill.handler.BulletTimeHandler;
import com.xm666.parcoolskill.handler.DropkickHandler;
import com.xm666.parcoolskill.handler.SlidekickHandler;
import com.xm666.parcoolskill.network.KickPayload;
import com.xm666.parcoolskill.network.StaminaRecoverPayload;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(modid="parcoolskill")
public class KickHandler {
    @SubscribeEvent
    static void onSlideStart(ParCoolActionEvent.StartEvent event) {
        Action action = event.getAction();
        if (!(action instanceof SkillSlide)) {
            return;
        }
        SkillSlide slide = (SkillSlide)action;
        slide.parcoolskill$setQueueInvulnerable(false);
        DropkickHandler.onSlideStart(event);
        SlidekickHandler.onSlideStart(event);
    }

    public static void handlePayload(KickPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        Entity target = level.getEntity(payload.targetId());
        Entity source = level.getEntity(payload.sourceId());
        KickPayload.Type type = KickPayload.Type.values()[payload.kickType()];
        if (target != null && source instanceof Player) {
            Player player = (Player)source;
            float amount = (float)((Double)Config.KICK_BASE_DAMAGE.get() + KickHandler.calculateValue((LivingEntity)player, (Holder<Attribute>)Attributes.ATTACK_DAMAGE, m -> !m.is(ResourceLocation.parse((String)"minecraft:base_attack_damage"))) + KickHandler.calculateValue((LivingEntity)player, (Holder<Attribute>)Attributes.ARMOR, m -> m.is(ResourceLocation.parse((String)"minecraft:armor.leggings")) || m.is(ResourceLocation.parse((String)"minecraft:armor.boots"))) + KickHandler.calculateValue((LivingEntity)player, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, m -> m.is(ResourceLocation.parse((String)"minecraft:armor.leggings")) || m.is(ResourceLocation.parse((String)"minecraft:armor.boots"))));
            DamageSource damageSource = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.KICK_ATTACK), (Entity)player, (Entity)player, player.position());
            target.hurt(damageSource, amount);
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                switch (type) {
                    case DROPKICK: {
                        float strength = ((Double)Config.DROPKICK_BASE_KNOCKBACK.get()).floatValue();
                        livingTarget.knockback((double)((strength += (float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK)) * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        if (!livingTarget.hasEffect(Effects.VULNERABLE)) break;
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StaminaRecoverPayload(200), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        BulletTimeHandler.addScale(0.5f, 60);
                        break;
                    }
                    case SLIDEKICK: {
                        int duration = 60;
                        MobEffectInstance targetEffect = livingTarget.getEffect(MobEffects.MOVEMENT_SLOWDOWN);
                        livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration += targetEffect != null ? targetEffect.getDuration() : 0, 2, false, false), (Entity)player);
                        if (!livingTarget.hasEffect(MobEffects.WEAKNESS)) break;
                        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new StaminaRecoverPayload(80), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        BulletTimeHandler.addScale(0.5f, 60);
                    }
                }
            }
            SoundEvent sound = switch (type) {
                default -> throw new MatchException(null, null);
                case KickPayload.Type.DROPKICK -> SoundEvents.PLAYER_ATTACK_KNOCKBACK;
                case KickPayload.Type.SLIDEKICK -> SoundEvents.PLAYER_ATTACK_STRONG;
            };
            level.playSound(null, source.getX(), source.getY(), source.getZ(), sound, source.getSoundSource(), 1.0f, 1.0f);
        }
    }

    private static double calculateValue(LivingEntity living, Holder<Attribute> attribute, Predicate<AttributeModifier> predicate) {
        AttributeInstance attributeInstance = living.getAttribute(attribute);
        return KickHandler.calculateValue(attribute, living.getAttributeBaseValue(attribute), attributeInstance != null ? (AttributeModifier[])attributeInstance.getModifiers().stream().filter(predicate).toArray(AttributeModifier[]::new) : new AttributeModifier[]{});
    }

    private static double calculateValue(Holder<Attribute> attribute, double baseValue, AttributeModifier[] modifiers) {
        for (AttributeModifier attributemodifier : (AttributeModifier[])Arrays.stream(modifiers).filter(m -> m.operation() == AttributeModifier.Operation.ADD_VALUE).toArray(AttributeModifier[]::new)) {
            baseValue += attributemodifier.amount();
        }
        double value = baseValue;
        for (AttributeModifier attributemodifier : (AttributeModifier[])Arrays.stream(modifiers).filter(m -> m.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE).toArray(AttributeModifier[]::new)) {
            value += baseValue * attributemodifier.amount();
        }
        for (AttributeModifier attributemodifier : (AttributeModifier[])Arrays.stream(modifiers).filter(m -> m.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).toArray(AttributeModifier[]::new)) {
            value *= 1.0 + attributemodifier.amount();
        }
        return ((Attribute)attribute.value()).sanitizeValue(value);
    }
}

