/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.parcoolskill.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.xm666.parcoolskill.handler.BulletTimeHandler;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

public class BulletTimeMixin {

    @Mixin(value={Minecraft.class})
    private static class MinecraftMixin {
        private MinecraftMixin() {
        }

        @WrapOperation(method={"runTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;isLevelRunningNormally()Z")})
        private boolean wrapLevelRunningNormally(Minecraft instance, Operation<Boolean> original) {
            BulletTimeHandler.modifyRunsNormally = false;
            Boolean levelRunningNormally = (Boolean)original.call(new Object[]{instance});
            BulletTimeHandler.modifyRunsNormally = true;
            return levelRunningNormally;
        }
    }

    @Mixin(value={GameRenderer.class})
    private static class GameRendererMixin {
        @Final
        @Shadow
        Minecraft minecraft;

        private GameRendererMixin() {
        }

        @ModifyArg(method={"renderLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setup(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/world/entity/Entity;ZZF)V"), index=4)
        private float modifyPartialTick(float partialTick, @Local Entity entity, @Local(argsOnly=true) DeltaTracker deltaTracker) {
            BulletTimeHandler.canRunsNormally = false;
            boolean frozen = this.minecraft.level != null && this.minecraft.level.tickRateManager().isEntityFrozen(entity);
            BulletTimeHandler.canRunsNormally = true;
            BulletTimeHandler.modifyGameTimeDeltaPartialTick = frozen;
            partialTick = deltaTracker.getGameTimeDeltaPartialTick(true);
            BulletTimeHandler.modifyGameTimeDeltaPartialTick = true;
            return partialTick;
        }
    }

    @Mixin(value={LevelRenderer.class})
    private static class LevelRendererMixin {
        private LevelRendererMixin() {
        }

        @WrapOperation(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/DeltaTracker;getGameTimeDeltaPartialTick(Z)F")})
        private float wrapGameTimeDeltaPartialTick(DeltaTracker instance, boolean b, Operation<Float> original, @Local TickRateManager tickratemanager, @Local Entity entity) {
            BulletTimeHandler.canRunsNormally = false;
            boolean frozen = tickratemanager.isEntityFrozen(entity);
            BulletTimeHandler.canRunsNormally = true;
            BulletTimeHandler.modifyGameTimeDeltaPartialTick = frozen;
            Float partialTick = (Float)original.call(new Object[]{instance, frozen});
            BulletTimeHandler.modifyGameTimeDeltaPartialTick = true;
            return partialTick.floatValue();
        }
    }

    @Mixin(value={DeltaTracker.Timer.class})
    private static class DeltaTrackerTimerMixin {
        private DeltaTrackerTimerMixin() {
        }

        @ModifyReturnValue(method={"getGameTimeDeltaPartialTick"}, at={@At(value="RETURN")})
        private float modifyGameTimeDeltaPartialTick(float original) {
            return BulletTimeHandler.modifyGameTimeDeltaPartialTick ? original * BulletTimeHandler.clientTicker.getTimeScale() + BulletTimeHandler.clientTicker.partialTick : original;
        }
    }

    @Mixin(value={TickRateManager.class})
    private static class TickRateManagerMixin {
        private TickRateManagerMixin() {
        }

        @ModifyReturnValue(method={"runsNormally"}, at={@At(value="RETURN")})
        private boolean modifyRunsNormally(boolean original) {
            return original && (!BulletTimeHandler.modifyRunsNormally || (this instanceof ServerTickRateManager ? BulletTimeHandler.serverTicker : BulletTimeHandler.clientTicker).runTick) && BulletTimeHandler.canRunsNormally;
        }
    }
}

