/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.parcoolskill.handler;

import com.xm666.parcoolskill.damage.DamageTypes;
import com.xm666.parcoolskill.network.KickPayload;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class KickHandler {
    public static void handlePayload(KickPayload payload, IPayloadContext context) {
        Level level = context.player().level();
        Entity target = level.getEntity(payload.targetId());
        Entity source = level.getEntity(payload.sourceId());
        KickPayload.Type type = KickPayload.Type.values()[payload.kickType()];
        if (target != null && source instanceof Player) {
            Player player = (Player)source;
            float amount = 7.0f;
            double baseArmor = player.getAttributeBaseValue(Attributes.ARMOR);
            double baseToughness = player.getAttributeBaseValue(Attributes.ARMOR_TOUGHNESS);
            amount += (float)baseArmor + (float)baseToughness;
            ItemStack feet = player.getItemBySlot(EquipmentSlot.FEET);
            amount += (float)KickHandler.getAttributeValue(feet, EquipmentSlot.FEET, (Holder<Attribute>)Attributes.ARMOR, baseArmor);
            amount += (float)KickHandler.getAttributeValue(feet, EquipmentSlot.FEET, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, baseToughness);
            ItemStack legs = player.getItemBySlot(EquipmentSlot.LEGS);
            amount += (float)KickHandler.getAttributeValue(legs, EquipmentSlot.LEGS, (Holder<Attribute>)Attributes.ARMOR, baseArmor);
            DamageSource damageSource = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.KICK_ATTACK), (Entity)player, (Entity)player, player.position());
            target.hurt(damageSource, amount += (float)KickHandler.getAttributeValue(legs, EquipmentSlot.LEGS, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS, baseToughness));
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                switch (type) {
                    case DROPKICK: {
                        float strength = 2.0f;
                        living.knockback((double)((strength += (float)player.getAttributeValue(Attributes.ATTACK_KNOCKBACK)) * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        break;
                    }
                    case SLIDEKICK: {
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 3));
                    }
                }
            }
            level.playSound(null, source.getX(), source.getY(), source.getZ(), SoundEvents.PLAYER_ATTACK_KNOCKBACK, source.getSoundSource(), 1.0f, 1.0f);
        }
    }

    private static double getAttributeValue(ItemStack stack, EquipmentSlot slot, Holder<Attribute> attribute, double baseValue) {
        double value = baseValue;
        List modifiers = stack.getAttributeModifiers().modifiers();
        for (ItemAttributeModifiers.Entry entry : modifiers) {
            if (!entry.slot().test(slot) || !entry.attribute().equals(attribute)) continue;
            double amount = entry.modifier().amount();
            double addition = switch (entry.modifier().operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> amount;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> amount * baseValue;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> amount * value;
            };
            value += addition;
        }
        return value -= baseValue;
    }
}

