/*
 * Decompiled with CFR 0.152.
 */
package com.xm666.parcoolskill.handler;

import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.impl.Dodge;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@EventBusSubscriber(modid="parcoolskill")
public class BackstabHandler {
    static boolean queueAttack;

    @SubscribeEvent
    static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        DamageSource source = event.getSource();
        Entity sourceEntity = source.getEntity();
        if (sourceEntity instanceof Player) {
            Vec3 sourcePosition;
            Player player = (Player)sourceEntity;
            if (source.is(DamageTypes.PLAYER_ATTACK) && queueAttack && (sourcePosition = source.getSourcePosition()) != null) {
                LivingEntity targetEntity = event.getEntity();
                Vec3 targetEyePosition = targetEntity.getEyePosition(1.0f);
                Vec3 targetViewVector = targetEntity.getViewVector(1.0f);
                Vec3 sourcePositionDifference = sourcePosition.subtract(targetEyePosition);
                Vec2 forward = new Vec2((float)targetViewVector.x, (float)targetViewVector.z);
                Vec2 target = new Vec2((float)sourcePositionDifference.x, (float)sourcePositionDifference.z);
                if (BackstabHandler.isBehind(forward, target)) {
                    event.setAmount(event.getAmount() * 2.0f);
                    player.magicCrit((Entity)targetEntity);
                    queueAttack = false;
                }
            }
        }
    }

    static boolean isBehind(Vec2 forward, Vec2 target) {
        float dot = (forward = forward.normalized()).dot(target = target.normalized());
        return dot < 0.0f;
    }

    @SubscribeEvent
    public static void onDodgeStart(ParCoolActionEvent.StartEvent event) {
        if (!(event.getAction() instanceof Dodge)) {
            return;
        }
        queueAttack = true;
    }

    @SubscribeEvent
    public static void onDodgeStop(ParCoolActionEvent.StopEvent event) {
        if (!(event.getAction() instanceof Dodge)) {
            return;
        }
        queueAttack = false;
    }
}

