/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer;

import com.minetracer.features.minetracer.NewOptimizedLogStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ContainerInteractionListener {
    private static final Map<UUID, Map<class_2338, List<class_1799>>> containerSnapshots = new ConcurrentHashMap<UUID, Map<class_2338, List<class_1799>>>();
    private static final Map<UUID, Long> lastCheckTime = new ConcurrentHashMap<UUID, Long>();
    private static final long CHECK_INTERVAL = 1000L;
    private static final Set<class_2248> TRACKED_CONTAINERS = Set.of(class_2246.field_10034, class_2246.field_10380, class_2246.field_16328, class_2246.field_10443, class_2246.field_10199, class_2246.field_10407, class_2246.field_10063, class_2246.field_10203, class_2246.field_10600, class_2246.field_10275, class_2246.field_10051, class_2246.field_10140, class_2246.field_10320, class_2246.field_10532, class_2246.field_10268, class_2246.field_10605, class_2246.field_10373, class_2246.field_10055, class_2246.field_10068, class_2246.field_10371);

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (hand != class_1268.field_5808 || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            class_2248 block = world.method_8320(pos).method_26204();
            if (TRACKED_CONTAINERS.contains(block)) {
                ContainerInteractionListener.takeContainerSnapshot((class_3222)player, world, pos);
                ContainerInteractionListener.scheduleContainerCheck((class_3222)player, pos);
            }
            return class_1269.field_5811;
        });
    }

    private static void takeContainerSnapshot(class_3222 player, class_1937 world, class_2338 pos) {
        try {
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof class_1263)) {
                return;
            }
            class_1263 inventory = (class_1263)blockEntity;
            UUID playerId = player.method_5667();
            ArrayList<class_1799> snapshot = new ArrayList<class_1799>();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                snapshot.add(inventory.method_5438(i).method_7972());
            }
            containerSnapshots.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).put(pos, snapshot);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void scheduleContainerCheck(class_3222 player, class_2338 pos) {
        UUID playerId = player.method_5667();
        lastCheckTime.put(playerId, System.currentTimeMillis());
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(2000L);
                ContainerInteractionListener.checkContainerChanges(player, pos);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private static void checkContainerChanges(class_3222 player, class_2338 pos) {
        try {
            UUID playerId = player.method_5667();
            Map<class_2338, List<class_1799>> playerSnapshots = containerSnapshots.get(playerId);
            if (playerSnapshots == null || !playerSnapshots.containsKey(pos)) {
                return;
            }
            List<class_1799> oldSnapshot = playerSnapshots.get(pos);
            class_3218 world = player.method_51469();
            class_2586 blockEntity = world.method_8321(pos);
            if (!(blockEntity instanceof class_1263)) {
                return;
            }
            class_1263 inventory = (class_1263)blockEntity;
            for (int i = 0; i < Math.min(oldSnapshot.size(), inventory.method_5439()); ++i) {
                class_1799 diff;
                class_1799 newStack;
                class_1799 oldStack = oldSnapshot.get(i);
                if (class_1799.method_7973((class_1799)oldStack, (class_1799)(newStack = inventory.method_5438(i)))) continue;
                if (oldStack.method_7960() && !newStack.method_7960()) {
                    NewOptimizedLogStorage.logContainerAction("deposited", (class_1657)player, pos, newStack);
                    continue;
                }
                if (!oldStack.method_7960() && newStack.method_7960()) {
                    NewOptimizedLogStorage.logContainerAction("withdrew", (class_1657)player, pos, oldStack);
                    continue;
                }
                if (oldStack.method_7960() || newStack.method_7960()) continue;
                if (newStack.method_7947() > oldStack.method_7947()) {
                    diff = newStack.method_7972();
                    diff.method_7939(newStack.method_7947() - oldStack.method_7947());
                    NewOptimizedLogStorage.logContainerAction("deposited", (class_1657)player, pos, diff);
                    continue;
                }
                if (newStack.method_7947() >= oldStack.method_7947()) continue;
                diff = oldStack.method_7972();
                diff.method_7939(oldStack.method_7947() - newStack.method_7947());
                NewOptimizedLogStorage.logContainerAction("withdrew", (class_1657)player, pos, diff);
            }
            playerSnapshots.remove(pos);
            if (playerSnapshots.isEmpty()) {
                containerSnapshots.remove(playerId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanupPlayerSnapshots(UUID playerId) {
        containerSnapshots.remove(playerId);
        lastCheckTime.remove(playerId);
    }
}

