/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.minetracer.features.minetracer.OptimizedLogStorage;
import com.minetracer.features.minetracer.database.MineTracerLookup;
import com.minetracer.features.minetracer.util.MaterialMatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class MineTracerCommand {
    private static final Map<UUID, UndoOperation> lastOperations = new ConcurrentHashMap<UUID, UndoOperation>();
    public static final Map<UUID, QueryContext> lastQueries = new HashMap<UUID, QueryContext>();

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"minetracer").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"lookup").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.lookup", (int)2))).then(class_2170.method_9244((String)"arg", (ArgumentType)StringArgumentType.greedyString()).suggests(MineTracerCommand::suggestPlayers).executes(MineTracerCommand::lookup)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rollback").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.rollback", (int)2))).then(class_2170.method_9244((String)"arg", (ArgumentType)StringArgumentType.greedyString()).suggests(MineTracerCommand::suggestPlayers).executes(MineTracerCommand::rollback)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"restore").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.restore", (int)2))).then(class_2170.method_9244((String)"arg", (ArgumentType)StringArgumentType.greedyString()).suggests(MineTracerCommand::suggestPlayers).executes(MineTracerCommand::restore)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"undo").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.undo", (int)2))).executes(MineTracerCommand::undo))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"page").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.page", (int)2))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(MineTracerCommand::lookupPage)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"inspector").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.inspector", (int)2))).executes(MineTracerCommand::toggleInspector))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"save").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.save", (int)2))).executes(MineTracerCommand::save))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"saves").requires(source -> Permissions.check((class_2172)source, (String)"minetracer.command.saves", (int)2))).executes(MineTracerCommand::showSaveHistory))).executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid command usage. Use /minetracer <lookup|rollback|restore|undo|page|inspector|save|saves>"));
            return 0;
        })));
    }

    public static CompletableFuture<Suggestions> suggestPlayers(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        String input = builder.getInput();
        String remaining = builder.getRemaining();
        String[] remainingParts = remaining.split(" ");
        String currentTyping = remainingParts[remainingParts.length - 1];
        boolean justAddedSpace = remaining.endsWith(" ");
        HashSet<String> usedFilters = new HashSet<String>();
        for (String part : remaining.split(" ")) {
            if (!part.contains(":")) continue;
            String filterType = part.substring(0, part.indexOf(":") + 1);
            usedFilters.add(filterType);
        }
        if (justAddedSpace) {
            baseText = remaining.trim() + " ";
            if (!usedFilters.contains("user:")) {
                builder.suggest((String)baseText + "user:");
            }
            if (!usedFilters.contains("time:")) {
                builder.suggest((String)baseText + "time:");
            }
            if (!usedFilters.contains("action:")) {
                builder.suggest((String)baseText + "action:");
            }
            if (!usedFilters.contains("range:")) {
                builder.suggest((String)baseText + "range:");
            }
            if (!usedFilters.contains("include:")) {
                builder.suggest((String)baseText + "include:");
            }
        } else if (currentTyping.startsWith("user:")) {
            String userPart = currentTyping.substring(5);
            String beforeCurrent = remaining.substring(0, remaining.lastIndexOf(currentTyping));
            HashSet<String> allPlayerNames = new HashSet<String>();
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                allPlayerNames.add(player.method_5477().getString());
            }
            try {
                allPlayerNames.addAll(MineTracerLookup.getAllPlayerNames());
            }
            catch (Exception part) {
                // empty catch block
            }
            for (String playerName : allPlayerNames) {
                if (!playerName.toLowerCase().startsWith(userPart.toLowerCase())) continue;
                builder.suggest(beforeCurrent + "user:" + playerName);
            }
        } else if (currentTyping.startsWith("action:")) {
            String actionPart = currentTyping.substring(7);
            String[] actions = new String[]{"withdrew", "deposited", "broke", "placed", "pickup", "drop", "sign", "kill"};
            String beforeCurrent = remaining.substring(0, remaining.lastIndexOf(currentTyping));
            int lastComma = actionPart.lastIndexOf(44);
            String currentAction = lastComma >= 0 ? actionPart.substring(lastComma + 1) : actionPart;
            for (String action : actions) {
                if (!action.toLowerCase().startsWith(currentAction.toLowerCase())) continue;
                if (lastComma >= 0) {
                    String prefix = actionPart.substring(0, lastComma + 1);
                    builder.suggest(beforeCurrent + "action:" + prefix + action);
                    continue;
                }
                builder.suggest(beforeCurrent + "action:" + action);
            }
        } else if (currentTyping.startsWith("time:")) {
            String timePart = currentTyping.substring(5);
            String[] timeOptions = new String[]{"1h", "30m", "2d", "1w", "12h", "3d"};
            String beforeCurrent = remaining.substring(0, remaining.lastIndexOf(currentTyping));
            for (String time : timeOptions) {
                if (!time.startsWith(timePart)) continue;
                builder.suggest(beforeCurrent + "time:" + time);
            }
        } else if (currentTyping.startsWith("range:")) {
            String rangePart = currentTyping.substring(6);
            String[] rangeOptions = new String[]{"10", "25", "50", "100", "200", "500"};
            String beforeCurrent = remaining.substring(0, remaining.lastIndexOf(currentTyping));
            for (String range : rangeOptions) {
                if (!range.startsWith(rangePart)) continue;
                builder.suggest(beforeCurrent + "range:" + range);
            }
        } else if (currentTyping.startsWith("include:")) {
            String itemPart = currentTyping.substring(8);
            String beforeCurrent = remaining.substring(0, remaining.lastIndexOf(currentTyping));
            List<String> itemSuggestions = MaterialMatcher.getSuggestions(itemPart);
            List<String> blockSuggestions = MaterialMatcher.getBlockSuggestions(itemPart);
            for (String suggestion : itemSuggestions) {
                builder.suggest(beforeCurrent + "include:" + suggestion);
            }
            for (String suggestion : blockSuggestions) {
                if (itemSuggestions.contains(suggestion)) continue;
                builder.suggest(beforeCurrent + "include:" + suggestion);
            }
        } else if (!currentTyping.isEmpty()) {
            String beforeCurrent = remaining.substring(0, remaining.lastIndexOf(currentTyping));
            if (!usedFilters.contains("user:") && "user:".startsWith(currentTyping.toLowerCase())) {
                builder.suggest(beforeCurrent + "user:");
            }
            if (!usedFilters.contains("time:") && "time:".startsWith(currentTyping.toLowerCase())) {
                builder.suggest(beforeCurrent + "time:");
            }
            if (!usedFilters.contains("action:") && "action:".startsWith(currentTyping.toLowerCase())) {
                builder.suggest(beforeCurrent + "action:");
            }
            if (!usedFilters.contains("range:") && "range:".startsWith(currentTyping.toLowerCase())) {
                builder.suggest(beforeCurrent + "range:");
            }
            if (!usedFilters.contains("include:") && "include:".startsWith(currentTyping.toLowerCase())) {
                builder.suggest(beforeCurrent + "include:");
            }
        } else {
            baseText = remaining.trim();
            if (!((String)baseText).isEmpty()) {
                baseText = (String)baseText + " ";
            }
            if (!usedFilters.contains("user:")) {
                builder.suggest((String)baseText + "user:");
            }
            if (!usedFilters.contains("time:")) {
                builder.suggest((String)baseText + "time:");
            }
            if (!usedFilters.contains("action:")) {
                builder.suggest((String)baseText + "action:");
            }
            if (!usedFilters.contains("range:")) {
                builder.suggest((String)baseText + "range:");
            }
            if (!usedFilters.contains("include:")) {
                builder.suggest((String)baseText + "include:");
            }
        }
        return builder.buildFuture();
    }

    public static int lookup(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.lookup", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        String arg = StringArgumentType.getString(ctx, (String)"arg");
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            CompletableFuture<List<MineTracerLookup.ItemPickupDropLogEntry>> itemLogsFuture;
            CompletableFuture<List<MineTracerLookup.KillLogEntry>> killLogsFuture;
            CompletableFuture<List<MineTracerLookup.ContainerLogEntry>> containerLogsFuture;
            CompletableFuture<List> signLogsFuture;
            CompletableFuture<List<MineTracerLookup.BlockLogEntry>> blockLogsFuture;
            boolean hasUser;
            boolean hasTime;
            boolean hasRange;
            int restrictionCount;
            String userFilter = null;
            String timeArg = null;
            int range = 100;
            HashSet<String> actionFilters = new HashSet<String>();
            String includeItem = null;
            String excludeItem = null;
            for (String part : arg.split(" ")) {
                if (part.startsWith("user:")) {
                    userFilter = part.substring(5);
                    continue;
                }
                if (part.startsWith("time:")) {
                    timeArg = part.substring(5);
                    continue;
                }
                if (part.startsWith("range:")) {
                    try {
                        range = Integer.parseInt(part.substring(6));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (part.startsWith("action:")) {
                    String actions = part.substring(7).toLowerCase();
                    for (String act : actions.split(",")) {
                        if ((act = act.trim()).equals("place")) {
                            act = "placed";
                        }
                        if (act.equals("sign")) {
                            act = "edit";
                        }
                        if (act.isEmpty()) continue;
                        actionFilters.add(act);
                    }
                    continue;
                }
                if (part.startsWith("include:") || part.startsWith("i:")) {
                    includeItem = part.startsWith("include:") ? part.substring(8) : part.substring(2);
                    continue;
                }
                if (!part.startsWith("exclude:") && !part.startsWith("e:")) continue;
                excludeItem = part.startsWith("exclude:") ? part.substring(8) : part.substring(2);
            }
            class_2338 playerPos = source.method_44023().method_24515();
            Instant cutoff = null;
            if (timeArg != null) {
                long seconds = MineTracerCommand.parseTimeArg(timeArg);
                cutoff = Instant.now().minusSeconds(seconds);
            }
            if ((restrictionCount = ((hasRange = range != 100) ? 1 : 0) + ((hasTime = timeArg != null) ? 1 : 0) + ((hasUser = userFilter != null) ? 1 : 0)) < 2) {
                source.method_9213((class_2561)class_2561.method_43470((String)"Lookup requires at least 2 of these filters: range:<blocks>, time:<duration>, user:<player>. Examples: 'range:50 user:PlayerName' or 'time:1h user:PlayerName' or 'range:20 time:30m'"));
                return null;
            }
            class_2338 searchCenter = playerPos;
            int searchRange = range;
            if (hasUser && !hasRange) {
                searchRange = 50000;
            }
            boolean filterByKiller = actionFilters.contains("kill");
            class_3222 player = source.method_44023();
            String worldName = player.method_51469().method_27983().method_29177().toString();
            if (hasUser && !hasRange) {
                blockLogsFuture = MineTracerLookup.getBlockLogsForUserAsync(userFilter, worldName);
                signLogsFuture = CompletableFuture.supplyAsync(() -> new ArrayList());
                containerLogsFuture = MineTracerLookup.getContainerLogsForUserAsync(userFilter, worldName);
                killLogsFuture = MineTracerLookup.getKillLogsForUserAsync(userFilter, worldName);
                itemLogsFuture = MineTracerLookup.getItemPickupDropLogsForUserAsync(userFilter, worldName);
            } else {
                blockLogsFuture = MineTracerLookup.getBlockLogsInRangeAsync(playerPos, range, userFilter, worldName);
                signLogsFuture = MineTracerLookup.getSignLogsInRangeAsync(playerPos, range, userFilter, worldName);
                containerLogsFuture = MineTracerLookup.getContainerLogsInRangeAsync(playerPos, range, userFilter, worldName);
                killLogsFuture = MineTracerLookup.getKillLogsInRangeAsync(playerPos, range, userFilter, worldName);
                itemLogsFuture = userFilter != null ? MineTracerLookup.getItemPickupDropLogsForUserAsync(userFilter, worldName) : CompletableFuture.supplyAsync(() -> new ArrayList());
            }
            try {
                List<MineTracerLookup.BlockLogEntry> blockLogs = blockLogsFuture.get();
                List signLogs = signLogsFuture.get();
                List<MineTracerLookup.ContainerLogEntry> containerLogs = containerLogsFuture.get();
                List<MineTracerLookup.KillLogEntry> killLogs = killLogsFuture.get();
                List<MineTracerLookup.ItemPickupDropLogEntry> itemLogs = itemLogsFuture.get();
                if (userFilter != null && (!hasUser || hasRange)) {
                    String userFilterFinal = userFilter;
                    containerLogs.removeIf(entry -> !entry.playerName.equalsIgnoreCase(userFilterFinal));
                }
                if (cutoff != null) {
                    Instant cutoffFinal = cutoff;
                    blockLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
                    signLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
                    containerLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
                    killLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
                    itemLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
                }
                if (!actionFilters.isEmpty()) {
                    containerLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
                    blockLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
                    signLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
                    killLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
                    itemLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
                }
                if (includeItem != null && !includeItem.isEmpty()) {
                    String includeItemFinal = includeItem;
                    containerLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), includeItemFinal));
                    blockLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(entry.blockId, includeItemFinal));
                    itemLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), includeItemFinal));
                }
                if (excludeItem != null && !excludeItem.isEmpty()) {
                    String excludeItemFinal = excludeItem;
                    containerLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), excludeItemFinal));
                    blockLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(entry.blockId, excludeItemFinal));
                    itemLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), excludeItemFinal));
                }
                ArrayList<FlatLogEntry> flatList = new ArrayList<FlatLogEntry>();
                for (MineTracerLookup.ContainerLogEntry containerLogEntry : containerLogs) {
                    flatList.add(new FlatLogEntry(containerLogEntry, "container"));
                }
                for (MineTracerLookup.BlockLogEntry blockLogEntry : blockLogs) {
                    flatList.add(new FlatLogEntry(blockLogEntry, "block"));
                }
                for (MineTracerLookup.SignLogEntry signLogEntry : signLogs) {
                    flatList.add(new FlatLogEntry(signLogEntry, "sign"));
                }
                for (MineTracerLookup.KillLogEntry killLogEntry : killLogs) {
                    flatList.add(new FlatLogEntry(killLogEntry, "kill"));
                }
                for (MineTracerLookup.ItemPickupDropLogEntry itemPickupDropLogEntry : itemLogs) {
                    flatList.add(new FlatLogEntry(itemPickupDropLogEntry, "item"));
                }
                flatList.sort((a, b) -> {
                    Instant aTime;
                    Instant instant = a.entry instanceof MineTracerLookup.ContainerLogEntry ? ((MineTracerLookup.ContainerLogEntry)a.entry).timestamp : (a.entry instanceof MineTracerLookup.BlockLogEntry ? ((MineTracerLookup.BlockLogEntry)a.entry).timestamp : (a.entry instanceof MineTracerLookup.SignLogEntry ? ((MineTracerLookup.SignLogEntry)a.entry).timestamp : (a.entry instanceof MineTracerLookup.KillLogEntry ? ((MineTracerLookup.KillLogEntry)a.entry).timestamp : (aTime = a.entry instanceof MineTracerLookup.ItemPickupDropLogEntry ? ((MineTracerLookup.ItemPickupDropLogEntry)a.entry).timestamp : Instant.EPOCH))));
                    Instant bTime = b.entry instanceof MineTracerLookup.ContainerLogEntry ? ((MineTracerLookup.ContainerLogEntry)b.entry).timestamp : (b.entry instanceof MineTracerLookup.BlockLogEntry ? ((MineTracerLookup.BlockLogEntry)b.entry).timestamp : (b.entry instanceof MineTracerLookup.SignLogEntry ? ((MineTracerLookup.SignLogEntry)b.entry).timestamp : (b.entry instanceof MineTracerLookup.KillLogEntry ? ((MineTracerLookup.KillLogEntry)b.entry).timestamp : (b.entry instanceof MineTracerLookup.ItemPickupDropLogEntry ? ((MineTracerLookup.ItemPickupDropLogEntry)b.entry).timestamp : Instant.EPOCH))));
                    return bTime.compareTo(aTime);
                });
                return flatList;
            }
            catch (Exception e) {
                throw new RuntimeException("Error executing lookup", e);
            }
        }).thenAccept(flatList -> {
            QueryContext queryContext = new QueryContext((List<FlatLogEntry>)flatList, arg, source.method_44023().method_24515());
            lastQueries.put(source.method_44023().method_5667(), queryContext);
            MineTracerCommand.displayPage(source, flatList, 1, queryContext.entriesPerPage);
        })).exceptionally(throwable -> {
            source.method_9213((class_2561)class_2561.method_43470((String)("Error performing lookup: " + throwable.getMessage())));
            return null;
        });
        return 1;
    }

    public static void displayPage(class_2168 source, List<FlatLogEntry> logs, int page, int entriesPerPage) {
        int totalEntries = logs.size();
        int totalPages = (totalEntries + entriesPerPage - 1) / entriesPerPage;
        int start = (page - 1) * entriesPerPage;
        int end = Math.min(start + entriesPerPage, totalEntries);
        if (start >= totalEntries || page < 1) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Invalid page number."));
            return;
        }
        source.method_9226(() -> class_2561.method_43470((String)"----- MineTracer Lookup Results -----").method_27692(class_124.field_1075), false);
        for (int i = start; i < end; ++i) {
            FlatLogEntry fle = logs.get(i);
            source.method_9226(() -> MineTracerCommand.formatCoordinatesForChat(fle.entry), false);
            source.method_9226(() -> MineTracerCommand.formatLogEntryForChat(fle.entry), false);
            if (!(fle.entry instanceof MineTracerLookup.SignLogEntry)) continue;
            MineTracerLookup.SignLogEntry se = (MineTracerLookup.SignLogEntry)fle.entry;
            if (!se.action.equals("edit") || se.nbt == null || se.nbt.isEmpty()) continue;
            try {
                Gson gson = new Gson();
                JsonObject nbtObj = (JsonObject)gson.fromJson(se.nbt, JsonObject.class);
                String[] beforeLines = (String[])gson.fromJson(nbtObj.get("before"), String[].class);
                String[] afterLines = (String[])gson.fromJson(nbtObj.get("after"), String[].class);
                source.method_9226(() -> class_2561.method_43470((String)"[before]").method_27692(class_124.field_1061), false);
                for (String line : beforeLines) {
                    if (line == null || line.trim().isEmpty()) continue;
                    source.method_9226(() -> class_2561.method_43470((String)("  " + line)).method_27692(class_124.field_1068), false);
                }
                source.method_9226(() -> class_2561.method_43470((String)"[after]").method_27692(class_124.field_1060), false);
                for (String line : afterLines) {
                    if (line == null || line.trim().isEmpty()) continue;
                    source.method_9226(() -> class_2561.method_43470((String)("  " + line)).method_27692(class_124.field_1068), false);
                }
                continue;
            }
            catch (Exception e) {
                source.method_9226(() -> class_2561.method_43470((String)"  (Sign text parsing failed)").method_27692(class_124.field_1080), false);
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)("Page " + page + "/" + totalPages + " (" + totalEntries + " entries) - Use /minetracer page <number> for other pages")).method_27692(class_124.field_1080), false);
    }

    public static class_2561 formatLogEntryForChat(Object entry) {
        if (entry instanceof MineTracerLookup.ContainerLogEntry) {
            MineTracerLookup.ContainerLogEntry ce = (MineTracerLookup.ContainerLogEntry)entry;
            String timeAgo = MineTracerCommand.getTimeAgo(Duration.between(ce.timestamp, Instant.now()).getSeconds());
            String itemId = class_7923.field_41178.method_10221((Object)ce.stack.method_7909()).toString();
            String itemName = ce.stack.method_7909().method_7848().getString();
            boolean isRolledBack = ce.rolledBack;
            class_5250 base = class_2561.method_43470((String)(timeAgo + " ago")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" \u2014 ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)ce.playerName).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" " + ce.action + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(ce.stack.method_7947() + "x ")).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)("#" + itemId)).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(" (" + itemName + ")")).method_27692(class_124.field_1080));
            if (isRolledBack) {
                base = base.method_27661().method_10862(base.method_10866().method_36140(Boolean.valueOf(true)).method_10977(class_124.field_1063));
            }
            return base;
        }
        if (entry instanceof MineTracerLookup.BlockLogEntry) {
            MineTracerLookup.BlockLogEntry be = (MineTracerLookup.BlockLogEntry)entry;
            String timeAgo = MineTracerCommand.getTimeAgo(Duration.between(be.timestamp, Instant.now()).getSeconds());
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(be.blockId));
            String blockName = block.method_9518().getString();
            boolean isRolledBack = be.rolledBack;
            class_5250 base = class_2561.method_43470((String)(timeAgo + " ago")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" \u2014 ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)be.playerName).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" " + be.action + " block ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("#" + be.blockId)).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(" (" + blockName + ")")).method_27692(class_124.field_1080));
            if (isRolledBack) {
                base = base.method_27661().method_10862(base.method_10866().method_36140(Boolean.valueOf(true)).method_10977(class_124.field_1063));
            }
            return base;
        }
        if (entry instanceof MineTracerLookup.SignLogEntry) {
            MineTracerLookup.SignLogEntry se = (MineTracerLookup.SignLogEntry)entry;
            String timeAgo = MineTracerCommand.getTimeAgo(Duration.between(se.timestamp, Instant.now()).getSeconds());
            boolean isRolledBack = se.rolledBack;
            class_5250 base = class_2561.method_43470((String)(timeAgo + " ago")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" \u2014 ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)se.playerName).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" edited sign").method_27692(class_124.field_1054));
            if (isRolledBack) {
                base = base.method_27661().method_10862(base.method_10866().method_36140(Boolean.valueOf(true)).method_10977(class_124.field_1063));
            }
            return base;
        }
        if (entry instanceof MineTracerLookup.KillLogEntry) {
            MineTracerLookup.KillLogEntry ke = (MineTracerLookup.KillLogEntry)entry;
            String timeAgo = MineTracerCommand.getTimeAgo(Duration.between(ke.timestamp, Instant.now()).getSeconds());
            boolean isRolledBack = ke.rolledBack;
            class_5250 base = class_2561.method_43470((String)(timeAgo + " ago")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" \u2014 ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)ke.killerName).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" killed ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)ke.victimName).method_27692(class_124.field_1061));
            if (isRolledBack) {
                base = base.method_27661().method_10862(base.method_10866().method_36140(Boolean.valueOf(true)).method_10977(class_124.field_1063));
            }
            return base;
        }
        if (entry instanceof MineTracerLookup.ItemPickupDropLogEntry) {
            MineTracerLookup.ItemPickupDropLogEntry ie = (MineTracerLookup.ItemPickupDropLogEntry)entry;
            String timeAgo = MineTracerCommand.getTimeAgo(Duration.between(ie.timestamp, Instant.now()).getSeconds());
            String itemId = class_7923.field_41178.method_10221((Object)ie.stack.method_7909()).toString();
            String itemName = ie.stack.method_7909().method_7848().getString();
            class_5250 base = class_2561.method_43470((String)(timeAgo + " ago")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)" \u2014 ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)ie.playerName).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" " + ie.action + " ")).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(ie.stack.method_7947() + "x ")).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)("#" + itemId)).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(" (" + itemName + ")")).method_27692(class_124.field_1080));
            return base;
        }
        return class_2561.method_43470((String)"Unknown log entry").method_27692(class_124.field_1080);
    }

    public static class_2561 formatCoordinatesForChat(Object entry) {
        class_2338 pos = null;
        if (entry instanceof MineTracerLookup.ContainerLogEntry) {
            pos = ((MineTracerLookup.ContainerLogEntry)entry).pos;
        } else if (entry instanceof MineTracerLookup.BlockLogEntry) {
            pos = ((MineTracerLookup.BlockLogEntry)entry).pos;
        } else if (entry instanceof MineTracerLookup.SignLogEntry) {
            pos = ((MineTracerLookup.SignLogEntry)entry).pos;
        } else if (entry instanceof MineTracerLookup.KillLogEntry) {
            pos = ((MineTracerLookup.KillLogEntry)entry).pos;
        } else if (entry instanceof MineTracerLookup.ItemPickupDropLogEntry) {
            pos = ((MineTracerLookup.ItemPickupDropLogEntry)entry).pos;
        }
        if (pos != null) {
            String coordText = "(x" + pos.method_10263() + "/y" + pos.method_10264() + "/z" + pos.method_10260() + ")";
            String teleportCommand = "/tp @s " + pos.method_10263() + " " + pos.method_10264() + " " + pos.method_10260();
            return class_2561.method_43470((String)coordText).method_27692(class_124.field_1065).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, teleportCommand)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to teleport to this location").method_27692(class_124.field_1054))).method_30938(Boolean.valueOf(true)));
        }
        return class_2561.method_43470((String)"").method_27692(class_124.field_1080);
    }

    /*
     * WARNING - void declaration
     */
    public static int rollback(CommandContext<class_2168> ctx) {
        List<MineTracerLookup.KillLogEntry> killLogs;
        List<MineTracerLookup.ContainerLogEntry> containerLogs;
        List<MineTracerLookup.SignLogEntry> signLogs;
        List<MineTracerLookup.BlockLogEntry> blockLogs;
        boolean hasUser;
        boolean hasTime;
        boolean hasRange;
        int restrictionCount;
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.rollback", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        String arg = StringArgumentType.getString(ctx, (String)"arg");
        String userFilter = null;
        String timeArg = null;
        int range = 100;
        HashSet<String> actionFilters = new HashSet<String>();
        String includeItem = null;
        String excludeItem = null;
        boolean preview = false;
        for (String part : arg.split(" ")) {
            if (part.startsWith("user:")) {
                userFilter = part.substring(5);
                continue;
            }
            if (part.startsWith("time:")) {
                timeArg = part.substring(5);
                continue;
            }
            if (part.startsWith("range:")) {
                try {
                    range = Integer.parseInt(part.substring(6));
                }
                catch (Exception exception) {}
                continue;
            }
            if (part.startsWith("action:")) {
                String actions = part.substring(7).toLowerCase();
                for (String act : actions.split(",")) {
                    if ((act = act.trim()).equals("place")) {
                        act = "placed";
                    }
                    if (act.equals("sign")) {
                        act = "edit";
                    }
                    if (act.isEmpty()) continue;
                    actionFilters.add(act);
                }
                continue;
            }
            if (part.startsWith("include:") || part.startsWith("i:")) {
                includeItem = part.startsWith("include:") ? part.substring(8) : part.substring(2);
                continue;
            }
            if (part.startsWith("exclude:") || part.startsWith("e:")) {
                excludeItem = part.startsWith("exclude:") ? part.substring(8) : part.substring(2);
                continue;
            }
            if (!part.equals("#preview")) continue;
            preview = true;
        }
        class_2338 playerPos = source.method_44023().method_24515();
        Instant cutoff = null;
        if (timeArg != null) {
            long seconds = MineTracerCommand.parseTimeArg(timeArg);
            cutoff = Instant.now().minusSeconds(seconds);
        }
        if ((restrictionCount = ((hasRange = range != 100) ? 1 : 0) + ((hasTime = timeArg != null) ? 1 : 0) + ((hasUser = userFilter != null) ? 1 : 0)) < 2) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Rollback requires at least 2 of these filters: range:<blocks>, time:<duration>, user:<player>. Examples: 'range:50 user:PlayerName' or 'time:1h user:PlayerName' or 'range:20 time:30m'"));
            return 1;
        }
        String worldName = source.method_44023().method_51469().method_27983().method_29177().toString();
        try {
            blockLogs = MineTracerLookup.getBlockLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
            signLogs = MineTracerLookup.getSignLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
            containerLogs = MineTracerLookup.getContainerLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
            killLogs = MineTracerLookup.getKillLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("[MineTracer] Error querying database: " + e.getMessage())));
            e.printStackTrace();
            return 1;
        }
        boolean filterByKiller = actionFilters.contains("kill");
        if (userFilter != null) {
            String userFilterFinal = userFilter;
            containerLogs.removeIf(entry -> !entry.playerName.equalsIgnoreCase(userFilterFinal));
        }
        if (cutoff != null) {
            Instant cutoffFinal = cutoff;
            blockLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
            signLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
            containerLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
            killLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
        }
        if (!actionFilters.isEmpty()) {
            containerLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
            blockLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
            signLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
            killLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
        }
        if (includeItem != null && !includeItem.isEmpty()) {
            String includeItemFinal = includeItem;
            containerLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), includeItemFinal));
            blockLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(entry.blockId, includeItemFinal));
        }
        if (excludeItem != null && !excludeItem.isEmpty()) {
            String excludeItemFinal = excludeItem;
            containerLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), excludeItemFinal));
            blockLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(entry.blockId, excludeItemFinal));
        }
        int successfulRollbacks = 0;
        int failedRollbacks = 0;
        class_3218 world = source.method_9225();
        int totalActions = containerLogs.size() + blockLogs.size() + signLogs.size();
        if (totalActions == 0) {
            source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] No actions found matching the specified filters.").method_27692(class_124.field_1054), false);
            return 1;
        }
        if (preview) {
            void var27_40;
            source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] PREVIEW MODE - Showing ghost blocks...").method_27692(class_124.field_1054), false);
            source.method_9226(() -> class_2561.method_43470((String)("Found " + totalActions + " actions to preview.")).method_27692(class_124.field_1075), false);
            class_3222 player = source.method_44023();
            boolean bl = false;
            for (MineTracerLookup.BlockLogEntry entry2 : blockLogs) {
                if (entry2.rolledBack) continue;
                if ("broke".equals(entry2.action)) {
                    MineTracerCommand.sendGhostBlock(player, entry2.pos, entry2.blockId, entry2.nbt);
                    ++var27_40;
                    continue;
                }
                if (!"placed".equals(entry2.action)) continue;
                MineTracerCommand.sendGhostBlock(player, entry2.pos, "minecraft:air", null);
                ++var27_40;
            }
            void finalGhostBlocksShown = var27_40;
            source.method_9226(() -> MineTracerCommand.lambda$rollback$68((int)finalGhostBlocksShown), false);
            source.method_9226(() -> class_2561.method_43470((String)"Run without #preview to execute the rollback.").method_27692(class_124.field_1054), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Found " + totalActions + " actions to rollback.")).method_27692(class_124.field_1075), false);
        if (actionFilters.isEmpty()) {
            blockLogs.sort((a, b) -> b.timestamp.compareTo(a.timestamp));
            signLogs.sort((a, b) -> b.timestamp.compareTo(a.timestamp));
            containerLogs.sort((a, b) -> b.timestamp.compareTo(a.timestamp));
            source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] Processing rollback in reverse chronological order (newest actions first).").method_27692(class_124.field_1080), false);
        }
        if (actionFilters.isEmpty()) {
            for (MineTracerLookup.BlockLogEntry blockLogEntry : blockLogs) {
                if (!"broke".equals(blockLogEntry.action) || blockLogEntry.rolledBack) continue;
                if (MineTracerCommand.performBlockPlaceRollback(world, blockLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
            for (MineTracerLookup.BlockLogEntry blockLogEntry : blockLogs) {
                if (!"placed".equals(blockLogEntry.action) || blockLogEntry.rolledBack) continue;
                if (MineTracerCommand.performBlockBreakRollback(world, blockLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
            for (MineTracerLookup.ContainerLogEntry containerLogEntry : containerLogs) {
                if (containerLogEntry.rolledBack) continue;
                if ("withdrew".equals(containerLogEntry.action)) {
                    if (MineTracerCommand.performWithdrawalRollback(world, containerLogEntry)) {
                        ++successfulRollbacks;
                        continue;
                    }
                    ++failedRollbacks;
                    continue;
                }
                if (!"deposited".equals(containerLogEntry.action)) continue;
                if (MineTracerCommand.performDepositRollback(world, containerLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
            for (MineTracerLookup.SignLogEntry signLogEntry : signLogs) {
                if (!"edit".equals(signLogEntry.action) || signLogEntry.rolledBack) continue;
                if (MineTracerCommand.performSignRollback(world, signLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
        } else {
            for (MineTracerLookup.ContainerLogEntry containerLogEntry : containerLogs) {
                if (containerLogEntry.rolledBack) continue;
                if ("withdrew".equals(containerLogEntry.action)) {
                    if (MineTracerCommand.performWithdrawalRollback(world, containerLogEntry)) {
                        ++successfulRollbacks;
                        continue;
                    }
                    ++failedRollbacks;
                    continue;
                }
                if (!"deposited".equals(containerLogEntry.action)) continue;
                if (MineTracerCommand.performDepositRollback(world, containerLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
            for (MineTracerLookup.BlockLogEntry blockLogEntry : blockLogs) {
                if (blockLogEntry.rolledBack) continue;
                if ("placed".equals(blockLogEntry.action)) {
                    if (MineTracerCommand.performBlockBreakRollback(world, blockLogEntry)) {
                        ++successfulRollbacks;
                        continue;
                    }
                    ++failedRollbacks;
                    continue;
                }
                if (!"broke".equals(blockLogEntry.action)) continue;
                if (MineTracerCommand.performBlockPlaceRollback(world, blockLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
            for (MineTracerLookup.SignLogEntry signLogEntry : signLogs) {
                if (!"edit".equals(signLogEntry.action) || signLogEntry.rolledBack) continue;
                if (MineTracerCommand.performSignRollback(world, signLogEntry)) {
                    ++successfulRollbacks;
                    continue;
                }
                ++failedRollbacks;
            }
        }
        if (successfulRollbacks > 0 || failedRollbacks > 0) {
            int finalSuccessfulRollbacks = successfulRollbacks;
            int n = failedRollbacks;
            source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Rollback complete: " + finalSuccessfulRollbacks + " actions restored, " + finalFailedRollbacks + " failed.")).method_27692(class_124.field_1060), false);
            try {
                UUID playerId = source.method_44023().method_5667();
                UndoOperation undoOp = new UndoOperation("rollback", blockLogs, signLogs, containerLogs);
                lastOperations.put(playerId, undoOp);
                source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] Use /minetracer undo to revert this rollback.").method_27692(class_124.field_1080), false);
            }
            catch (Exception exception) {}
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] No actions found to rollback.").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    public static int restore(CommandContext<class_2168> ctx) {
        int totalActions;
        List<MineTracerLookup.ContainerLogEntry> containerLogs;
        List<MineTracerLookup.SignLogEntry> signLogs;
        List<MineTracerLookup.BlockLogEntry> blockLogs;
        boolean hasUser;
        boolean hasTime;
        boolean hasRange;
        int restrictionCount;
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.restore", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        String arg = StringArgumentType.getString(ctx, (String)"arg");
        boolean previewMode = arg.contains("#preview");
        if (previewMode) {
            arg = arg.replace("#preview", "").trim();
        }
        String userFilter = null;
        String timeArg = null;
        int range = 100;
        HashSet<String> actionFilters = new HashSet<String>();
        String includeItem = null;
        String excludeItem = null;
        for (String part : arg.split(" ")) {
            if (part.startsWith("user:")) {
                userFilter = part.substring(5);
                continue;
            }
            if (part.startsWith("time:")) {
                timeArg = part.substring(5);
                continue;
            }
            if (part.startsWith("range:")) {
                try {
                    range = Integer.parseInt(part.substring(6));
                }
                catch (Exception exception) {}
                continue;
            }
            if (part.startsWith("action:")) {
                String actions = part.substring(7).toLowerCase();
                for (String act : actions.split(",")) {
                    if ((act = act.trim()).equals("place")) {
                        act = "placed";
                    }
                    if (act.equals("sign")) {
                        act = "edit";
                    }
                    if (act.isEmpty()) continue;
                    actionFilters.add(act);
                }
                continue;
            }
            if (part.startsWith("include:") || part.startsWith("i:")) {
                includeItem = part.startsWith("include:") ? part.substring(8) : part.substring(2);
                continue;
            }
            if (!part.startsWith("exclude:") && !part.startsWith("e:")) continue;
            excludeItem = part.startsWith("exclude:") ? part.substring(8) : part.substring(2);
        }
        class_2338 playerPos = source.method_44023().method_24515();
        Instant cutoff = null;
        if (timeArg != null) {
            long seconds = MineTracerCommand.parseTimeArg(timeArg);
            cutoff = Instant.now().minusSeconds(seconds);
        }
        if ((restrictionCount = ((hasRange = range != 100) ? 1 : 0) + ((hasTime = timeArg != null) ? 1 : 0) + ((hasUser = userFilter != null) ? 1 : 0)) < 2) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Restore requires at least 2 of these filters: range:<blocks>, time:<duration>, user:<player>. Add #preview to see what would be restored."));
            return 1;
        }
        String worldName = source.method_44023().method_51469().method_27983().method_29177().toString();
        try {
            blockLogs = MineTracerLookup.getBlockLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
            signLogs = MineTracerLookup.getSignLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
            containerLogs = MineTracerLookup.getContainerLogsInRangeAsync(playerPos, range, userFilter, worldName).get();
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("[MineTracer] Error querying database: " + e.getMessage())));
            e.printStackTrace();
            return 1;
        }
        if (userFilter != null) {
            String userFilterFinal = userFilter;
            containerLogs.removeIf(entry -> !entry.playerName.equalsIgnoreCase(userFilterFinal));
        }
        if (cutoff != null) {
            Instant cutoffFinal = cutoff;
            blockLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
            signLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
            containerLogs.removeIf(entry -> entry.timestamp.isBefore(cutoffFinal));
        }
        if (!actionFilters.isEmpty()) {
            containerLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
            blockLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
            signLogs.removeIf(entry -> actionFilters.stream().noneMatch(filter -> entry.action.equalsIgnoreCase((String)filter)));
        }
        if (includeItem != null && !includeItem.isEmpty()) {
            String includeItemFinal = includeItem;
            containerLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), includeItemFinal));
            blockLogs.removeIf(entry -> !MaterialMatcher.matchesIncludeFilter(entry.blockId, includeItemFinal));
        }
        if (excludeItem != null && !excludeItem.isEmpty()) {
            String excludeItemFinal = excludeItem;
            containerLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(class_7923.field_41178.method_10221((Object)entry.stack.method_7909()).toString(), excludeItemFinal));
            blockLogs.removeIf(entry -> MaterialMatcher.matchesExcludeFilter(entry.blockId, excludeItemFinal));
        }
        if ((totalActions = containerLogs.size() + blockLogs.size() + signLogs.size()) == 0) {
            source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] No actions found matching the specified filters.").method_27692(class_124.field_1054), false);
            return 1;
        }
        if (previewMode) {
            source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Preview: Would restore " + totalActions + " actions:")).method_27692(class_124.field_1075), false);
            source.method_9226(() -> class_2561.method_43470((String)("  - " + blockLogs.size() + " block changes")).method_27692(class_124.field_1080), false);
            source.method_9226(() -> class_2561.method_43470((String)("  - " + containerLogs.size() + " container transactions")).method_27692(class_124.field_1080), false);
            source.method_9226(() -> class_2561.method_43470((String)("  - " + signLogs.size() + " sign edits")).method_27692(class_124.field_1080), false);
            source.method_9226(() -> class_2561.method_43470((String)"Remove #preview to execute the restore.").method_27692(class_124.field_1054), false);
            return 1;
        }
        int successfulRestores = 0;
        int failedRestores = 0;
        class_3218 world = source.method_9225();
        source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Found " + totalActions + " actions to restore.")).method_27692(class_124.field_1075), false);
        for (MineTracerLookup.BlockLogEntry blockLogEntry : blockLogs) {
            if ("placed".equals(blockLogEntry.action) && !blockLogEntry.rolledBack) {
                if (MineTracerCommand.performBlockRestore(world, blockLogEntry)) {
                    ++successfulRestores;
                    continue;
                }
                ++failedRestores;
                continue;
            }
            if (!"broke".equals(blockLogEntry.action) || blockLogEntry.rolledBack) continue;
            if (MineTracerCommand.performBlockBreakRestore(world, blockLogEntry)) {
                ++successfulRestores;
                continue;
            }
            ++failedRestores;
        }
        for (MineTracerLookup.ContainerLogEntry containerLogEntry : containerLogs) {
            if (containerLogEntry.rolledBack) continue;
            if ("withdrew".equals(containerLogEntry.action)) {
                if (MineTracerCommand.performWithdrawalRestore(world, containerLogEntry)) {
                    ++successfulRestores;
                    continue;
                }
                ++failedRestores;
                continue;
            }
            if (!"deposited".equals(containerLogEntry.action)) continue;
            if (MineTracerCommand.performDepositRestore(world, containerLogEntry)) {
                ++successfulRestores;
                continue;
            }
            ++failedRestores;
        }
        if (successfulRestores > 0 || failedRestores > 0) {
            int finalSuccessfulRestores = successfulRestores;
            int n = failedRestores;
            source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Restore complete: " + finalSuccessfulRestores + " actions reapplied, " + finalFailedRestores + " failed.")).method_27692(class_124.field_1060), false);
            try {
                UUID playerId = source.method_44023().method_5667();
                UndoOperation undoOp = new UndoOperation("restore", blockLogs, signLogs, containerLogs);
                lastOperations.put(playerId, undoOp);
                source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] Use /minetracer undo to revert this restore.").method_27692(class_124.field_1080), false);
            }
            catch (Exception exception) {}
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"[MineTracer] No actions found to restore.").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    public static int undo(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.undo", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        try {
            UUID playerId = source.method_44023().method_5667();
            UndoOperation lastOp = lastOperations.get(playerId);
            if (lastOp == null) {
                source.method_9213((class_2561)class_2561.method_43470((String)"[MineTracer] No recent rollback or restore to undo."));
                return 0;
            }
            long minutesAgo = Duration.between(lastOp.timestamp, Instant.now()).toMinutes();
            if (minutesAgo > 5L) {
                source.method_9213((class_2561)class_2561.method_43470((String)("[MineTracer] Last operation was " + minutesAgo + " minutes ago. Undo is only available for recent operations (within 5 minutes).")));
                return 0;
            }
            int successfulUndos = 0;
            int failedUndos = 0;
            class_3218 world = source.method_9225();
            source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Undoing last " + lastOp.type + " operation...")).method_27692(class_124.field_1075), false);
            boolean isUndoingRollback = "rollback".equals(lastOp.type);
            for (MineTracerLookup.BlockLogEntry blockLogEntry : lastOp.blockLogs) {
                if (isUndoingRollback) {
                    if ("broke".equals(blockLogEntry.action)) {
                        if (MineTracerCommand.performBlockBreakRestore(world, blockLogEntry)) {
                            ++successfulUndos;
                            continue;
                        }
                        ++failedUndos;
                        continue;
                    }
                    if (!"placed".equals(blockLogEntry.action)) continue;
                    if (MineTracerCommand.performBlockRestore(world, blockLogEntry)) {
                        ++successfulUndos;
                        continue;
                    }
                    ++failedUndos;
                    continue;
                }
                if ("broke".equals(blockLogEntry.action)) {
                    if (MineTracerCommand.performBlockPlaceRollback(world, blockLogEntry)) {
                        ++successfulUndos;
                        continue;
                    }
                    ++failedUndos;
                    continue;
                }
                if (!"placed".equals(blockLogEntry.action)) continue;
                if (MineTracerCommand.performBlockBreakRollback(world, blockLogEntry)) {
                    ++successfulUndos;
                    continue;
                }
                ++failedUndos;
            }
            for (MineTracerLookup.ContainerLogEntry containerLogEntry : lastOp.containerLogs) {
                if (isUndoingRollback) {
                    if ("withdrew".equals(containerLogEntry.action)) {
                        if (MineTracerCommand.performWithdrawalRestore(world, containerLogEntry)) {
                            ++successfulUndos;
                            continue;
                        }
                        ++failedUndos;
                        continue;
                    }
                    if (!"deposited".equals(containerLogEntry.action)) continue;
                    if (MineTracerCommand.performDepositRestore(world, containerLogEntry)) {
                        ++successfulUndos;
                        continue;
                    }
                    ++failedUndos;
                    continue;
                }
                if ("withdrew".equals(containerLogEntry.action)) {
                    if (MineTracerCommand.performWithdrawalRollback(world, containerLogEntry)) {
                        ++successfulUndos;
                        continue;
                    }
                    ++failedUndos;
                    continue;
                }
                if (!"deposited".equals(containerLogEntry.action)) continue;
                if (MineTracerCommand.performDepositRollback(world, containerLogEntry)) {
                    ++successfulUndos;
                    continue;
                }
                ++failedUndos;
            }
            lastOperations.remove(playerId);
            int finalSuccessfulUndos = successfulUndos;
            int n = failedUndos;
            source.method_9226(() -> class_2561.method_43470((String)("[MineTracer] Undo complete: " + finalSuccessfulUndos + " changes reverted, " + finalFailedUndos + " failed.")).method_27692(class_124.field_1060), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("[MineTracer] Failed to undo: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    private static boolean performWithdrawalRollback(class_3218 world, MineTracerLookup.ContainerLogEntry entry) {
        try {
            class_2338 pos = entry.pos;
            class_1799 stackToRestore = entry.stack.method_7972();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1263 inventory = (class_1263)blockEntity;
                class_1799 remaining = MineTracerCommand.addItemToInventory(inventory, stackToRestore);
                inventory.method_5431();
                return remaining.method_7947() < stackToRestore.method_7947();
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static boolean performDepositRollback(class_3218 world, MineTracerLookup.ContainerLogEntry entry) {
        try {
            class_2338 pos = entry.pos;
            class_1799 stackToRemove = entry.stack.method_7972();
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1263 inventory = (class_1263)blockEntity;
                class_1799 remaining = MineTracerCommand.removeItemFromInventory(inventory, stackToRemove);
                inventory.method_5431();
                return remaining.method_7947() < stackToRemove.method_7947();
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private static class_1799 removeItemFromInventory(class_1263 inventory, class_1799 stackToRemove) {
        class_1799 remaining = stackToRemove.method_7972();
        for (int i = 0; i < inventory.method_5439() && !remaining.method_7960(); ++i) {
            int canRemove;
            class_1799 existingStack = inventory.method_5438(i);
            if (existingStack.method_7960() || !class_1799.method_31577((class_1799)existingStack, (class_1799)remaining) || (canRemove = Math.min(existingStack.method_7947(), remaining.method_7947())) <= 0) continue;
            existingStack.method_7934(canRemove);
            remaining.method_7934(canRemove);
            if (existingStack.method_7960()) {
                inventory.method_5447(i, class_1799.field_8037);
                continue;
            }
            inventory.method_5447(i, existingStack);
        }
        return remaining;
    }

    private static class_1799 addItemToInventory(class_1263 inventory, class_1799 stack) {
        int maxStackSize;
        class_1799 existingStack;
        int i;
        class_1799 remaining = stack.method_7972();
        for (i = 0; i < inventory.method_5439() && !remaining.method_7960(); ++i) {
            int canAdd;
            existingStack = inventory.method_5438(i);
            if (existingStack.method_7960() || !class_1799.method_31577((class_1799)existingStack, (class_1799)remaining) || (canAdd = (maxStackSize = existingStack.method_7914()) - existingStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(canAdd, remaining.method_7947());
            existingStack.method_7933(toAdd);
            remaining.method_7934(toAdd);
            inventory.method_5447(i, existingStack);
        }
        for (i = 0; i < inventory.method_5439() && !remaining.method_7960(); ++i) {
            existingStack = inventory.method_5438(i);
            if (!existingStack.method_7960()) continue;
            maxStackSize = remaining.method_7914();
            int toPlace = Math.min(maxStackSize, remaining.method_7947());
            class_1799 toSet = remaining.method_7972();
            toSet.method_7939(toPlace);
            inventory.method_5447(i, toSet);
            remaining.method_7934(toPlace);
        }
        return remaining;
    }

    private static boolean performBlockBreakRollback(class_3218 world, MineTracerLookup.BlockLogEntry entry) {
        try {
            class_2338 pos = entry.pos;
            world.method_8501(pos, class_2246.field_10124.method_9564());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean performBlockPlaceRollback(class_3218 world, MineTracerLookup.BlockLogEntry entry) {
        try {
            class_2338 pos = entry.pos;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(entry.blockId));
            if (block != null && block != class_2246.field_10124) {
                block13: {
                    class_2680 blockState = block.method_9564();
                    if (entry.nbt != null && !entry.nbt.isEmpty() && !entry.nbt.equals("{}")) {
                        try {
                            class_2487 nbtCompound = class_2522.method_10718((String)entry.nbt);
                            if (nbtCompound.method_10545("Properties")) {
                                class_2487 properties = nbtCompound.method_10562("Properties");
                                for (String key : properties.method_10541()) {
                                    String value = properties.method_10558(key);
                                    try {
                                        class_2769 property = null;
                                        for (class_2769 prop : blockState.method_28501()) {
                                            if (!prop.method_11899().equals(key)) continue;
                                            property = prop;
                                            break;
                                        }
                                        if (property == null) continue;
                                        blockState = MineTracerCommand.setBlockStateProperty(blockState, property, value);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            world.method_8501(pos, blockState);
                            if (!nbtCompound.method_10545("BlockEntityTag")) break block13;
                            class_2487 blockEntityData = nbtCompound.method_10562("BlockEntityTag");
                            class_2586 blockEntity = world.method_8321(pos);
                            if (blockEntity != null) {
                                blockEntity.method_11014(blockEntityData);
                                blockEntity.method_5431();
                            }
                        }
                        catch (Exception e) {
                            world.method_8501(pos, blockState);
                        }
                    } else {
                        world.method_8501(pos, blockState);
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static <T extends Comparable<T>> class_2680 setBlockStateProperty(class_2680 state, class_2769<T> property, String value) {
        Optional parsedValue = property.method_11900(value);
        if (parsedValue.isPresent()) {
            return (class_2680)state.method_11657(property, (Comparable)parsedValue.get());
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean performSignRollback(class_3218 world, MineTracerLookup.SignLogEntry entry) {
        class_2338 pos = entry.pos;
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof class_2625)) return false;
        class_2625 signEntity = (class_2625)blockEntity;
        if (entry.nbt == null || entry.nbt.isEmpty()) return false;
        try {
            Gson gson = new Gson();
            JsonObject nbtObj = (JsonObject)gson.fromJson(entry.nbt, JsonObject.class);
            String[] beforeLines = (String[])gson.fromJson(nbtObj.get("before"), String[].class);
            class_2561[] beforeTexts = new class_2561[4];
            for (int i = 0; i < 4; ++i) {
                beforeTexts[i] = i < beforeLines.length && beforeLines[i] != null ? class_2561.method_43470((String)beforeLines[i]) : class_2561.method_43470((String)"");
            }
            try {
                class_2487 signNbt = signEntity.method_38244();
                if (signNbt.method_10545("front_text")) {
                    class_2487 frontText = signNbt.method_10562("front_text");
                    class_2499 messages = new class_2499();
                    for (class_2561 text : beforeTexts) {
                        String jsonText = class_2561.class_2562.method_10867((class_2561)text);
                        messages.add((Object)class_2519.method_23256((String)jsonText));
                    }
                    frontText.method_10566("messages", (class_2520)messages);
                    signNbt.method_10566("front_text", (class_2520)frontText);
                    signEntity.method_11014(signNbt);
                }
            }
            catch (Exception nbtError) {
                return false;
            }
            signEntity.method_5431();
            world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
            return true;
        }
        catch (Exception e) {
            try {
                return false;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    private static boolean performWithdrawalRestore(class_3218 world, MineTracerLookup.ContainerLogEntry entry) {
        return MineTracerCommand.performDepositRollback(world, entry);
    }

    private static boolean performDepositRestore(class_3218 world, MineTracerLookup.ContainerLogEntry entry) {
        return MineTracerCommand.performWithdrawalRollback(world, entry);
    }

    private static boolean performBlockRestore(class_3218 world, MineTracerLookup.BlockLogEntry entry) {
        try {
            class_2338 pos = entry.pos;
            String blockId = entry.blockId;
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(blockId));
            if (block != null) {
                class_2680 newState = block.method_9564();
                world.method_8652(pos, newState, 3);
                if (entry.nbt != null && !entry.nbt.isEmpty()) {
                    try {
                        class_2487 nbt = class_2522.method_10718((String)entry.nbt);
                        class_2586 blockEntity = world.method_8321(pos);
                        if (blockEntity != null) {
                            blockEntity.method_11014(nbt);
                            blockEntity.method_5431();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean performBlockBreakRestore(class_3218 world, MineTracerLookup.BlockLogEntry entry) {
        try {
            class_2338 pos = entry.pos;
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int lookupPage(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.page", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        UUID playerId = source.method_44023().method_5667();
        QueryContext queryContext = lastQueries.get(playerId);
        if (queryContext == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"No previous lookup found. Please run a lookup command first."));
            return 0;
        }
        int page = IntegerArgumentType.getInteger(ctx, (String)"page");
        MineTracerCommand.displayPage(source, queryContext.results, page, queryContext.entriesPerPage);
        return 1;
    }

    public static int toggleInspector(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.inspector", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        class_3222 player = source.method_44023();
        boolean isInspector = OptimizedLogStorage.isInspectorMode(player);
        if (isInspector) {
            OptimizedLogStorage.setInspectorMode(player, false);
            source.method_9226(() -> class_2561.method_43470((String)"Inspector mode disabled.").method_27692(class_124.field_1054), false);
        } else {
            OptimizedLogStorage.setInspectorMode(player, true);
            source.method_9226(() -> class_2561.method_43470((String)"Inspector mode enabled. Right-click or break blocks to see their history.").method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    public static int save(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.save", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Forcing save of all log data...").method_27692(class_124.field_1054), false);
        try {
            OptimizedLogStorage.forceSave();
            source.method_9226(() -> class_2561.method_43470((String)"Successfully saved all log data to disk.").method_27692(class_124.field_1060), false);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Error saving log data: " + e.getMessage())));
            return 0;
        }
        return 1;
    }

    public static int showSaveHistory(CommandContext<class_2168> ctx) {
        class_2168 source = (class_2168)ctx.getSource();
        if (!Permissions.check((class_2172)source, (String)"minetracer.command.saves", (int)2)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You do not have permission to use this command."));
            return 0;
        }
        List<OptimizedLogStorage.SaveHistory> saveHistory = OptimizedLogStorage.getSaveHistory();
        if (saveHistory.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No save history available yet.").method_27692(class_124.field_1054), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)("=== MineTracer Save History (Last " + saveHistory.size() + " saves) ===")).method_27692(class_124.field_1065), false);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss").withZone(ZoneId.systemDefault());
        for (int i = 0; i < saveHistory.size(); ++i) {
            OptimizedLogStorage.SaveHistory save = saveHistory.get(i);
            String timeStr = formatter.format(save.timestamp);
            long kilobytes = save.fileSizeBytes / 1024L;
            class_5250 message = class_2561.method_43470((String)String.format("[%d] %s - %,d entries (%,d KB)", i + 1, timeStr, save.totalEntries, kilobytes)).method_27692(class_124.field_1068);
            source.method_9226(() -> MineTracerCommand.lambda$showSaveHistory$110((class_2561)message), false);
        }
        return 1;
    }

    private static long parseTimeArg(String timeArg) {
        try {
            if (timeArg.endsWith("s")) {
                return Long.parseLong(timeArg.substring(0, timeArg.length() - 1));
            }
            if (timeArg.endsWith("m")) {
                return Long.parseLong(timeArg.substring(0, timeArg.length() - 1)) * 60L;
            }
            if (timeArg.endsWith("h")) {
                return Long.parseLong(timeArg.substring(0, timeArg.length() - 1)) * 3600L;
            }
            if (timeArg.endsWith("d")) {
                return Long.parseLong(timeArg.substring(0, timeArg.length() - 1)) * 86400L;
            }
            return Long.parseLong(timeArg);
        }
        catch (NumberFormatException e) {
            return 3600L;
        }
    }

    private static String getTimeAgo(long seconds) {
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            double minutes = (double)seconds / 60.0;
            return String.format("%.1fm", minutes);
        }
        if (seconds < 86400L) {
            double hours = (double)seconds / 3600.0;
            return String.format("%.1fh", hours);
        }
        double days = (double)seconds / 86400.0;
        return String.format("%.1fd", days);
    }

    private static void sendGhostBlock(class_3222 player, class_2338 pos, String blockId, String nbtString) {
        try {
            class_2960 identifier = new class_2960(blockId);
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
            class_2680 state = block.method_9564();
            class_2626 packet = new class_2626(pos, state);
            player.field_13987.method_14364((class_2596)packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ class_2561 lambda$showSaveHistory$110(class_2561 message) {
        return message;
    }

    public static class FlatLogEntry {
        public final Object entry;
        public final String type;

        public FlatLogEntry(Object entry, String type) {
            this.entry = entry;
            this.type = type;
        }
    }

    private static class UndoOperation {
        final String type;
        final List<MineTracerLookup.BlockLogEntry> blockLogs;
        final List<MineTracerLookup.SignLogEntry> signLogs;
        final List<MineTracerLookup.ContainerLogEntry> containerLogs;
        final Instant timestamp;

        UndoOperation(String type, List<MineTracerLookup.BlockLogEntry> blockLogs, List<MineTracerLookup.SignLogEntry> signLogs, List<MineTracerLookup.ContainerLogEntry> containerLogs) {
            this.type = type;
            this.blockLogs = new ArrayList<MineTracerLookup.BlockLogEntry>(blockLogs);
            this.signLogs = new ArrayList<MineTracerLookup.SignLogEntry>(signLogs);
            this.containerLogs = new ArrayList<MineTracerLookup.ContainerLogEntry>(containerLogs);
            this.timestamp = Instant.now();
        }
    }

    public static class QueryContext {
        public List<FlatLogEntry> results;
        public String originalQuery;
        public class_2338 queryPos;
        public int entriesPerPage = 15;

        public QueryContext(List<FlatLogEntry> results, String originalQuery, class_2338 queryPos) {
            this.results = results;
            this.originalQuery = originalQuery;
            this.queryPos = queryPos;
        }
    }
}

