/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer;

import com.minetracer.features.minetracer.database.MineTracerConsumer;
import com.minetracer.features.minetracer.database.MineTracerDatabase;
import com.minetracer.features.minetracer.database.MineTracerLookup;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class NewOptimizedLogStorage {
    private static volatile boolean initialized = false;
    private static final Set<UUID> inspectorPlayers = new HashSet<UUID>();

    public static boolean initialize() {
        if (initialized) {
            return true;
        }
        if (!MineTracerDatabase.initializeDatabase()) {
            System.err.println("[MineTracer] Failed to initialize database");
            return false;
        }
        MineTracerConsumer.startConsumer();
        initialized = true;
        System.out.println("[MineTracer] New optimized storage system initialized");
        return true;
    }

    public static void shutdown() {
        if (initialized) {
            MineTracerConsumer.stopConsumer();
            MineTracerDatabase.shutdown();
            MineTracerLookup.shutdown();
            initialized = false;
            System.out.println("[MineTracer] Storage system shutdown completed");
        }
    }

    public static void logContainerAction(String action, class_1657 player, class_2338 pos, class_1799 stack) {
        if (stack.method_7960() || !initialized) {
            return;
        }
        String worldName = NewOptimizedLogStorage.getWorldName(player.method_37908());
        Object[] data = new Object[]{action, player.method_5477().getString(), pos, stack, worldName};
        MineTracerConsumer.queueEntry(0, data, null);
    }

    public static void logBlockAction(String action, class_1657 player, class_2338 pos, String blockId, String nbt) {
        if (!initialized) {
            return;
        }
        String worldName = NewOptimizedLogStorage.getWorldName(player.method_37908());
        Object[] data = new Object[]{action, player.method_5477().getString(), pos, blockId, nbt, worldName};
        MineTracerConsumer.queueEntry(1, data, null);
    }

    public static void logSignAction(String action, class_1657 player, class_2338 pos, String text, String nbt) {
        if (!initialized) {
            return;
        }
        String playerName = player != null ? player.method_5477().getString() : "unknown";
        String worldName = player != null ? NewOptimizedLogStorage.getWorldName(player.method_37908()) : "unknown";
        Object[] data = new Object[]{action, playerName, pos, text, nbt, worldName};
        MineTracerConsumer.queueEntry(2, data, null);
    }

    public static void logKillAction(String killerName, String victimName, class_2338 pos, String world) {
        if (!initialized) {
            return;
        }
        Object[] data = new Object[]{killerName, victimName, pos, world};
        MineTracerConsumer.queueEntry(3, data, null);
    }

    public static void logItemPickupDropAction(String action, class_1657 player, class_2338 pos, class_1799 stack, String world) {
        if (stack.method_7960() || player == null || !initialized) {
            return;
        }
        Object[] data = new Object[]{action, player.method_5477().getString(), pos, stack, world};
        MineTracerConsumer.queueEntry(4, data, null);
    }

    public static void logInventoryAction(String action, class_1657 player, class_1799 stack) {
        NewOptimizedLogStorage.logContainerAction(action, player, class_2338.field_10980, stack);
    }

    public static CompletableFuture<List<MineTracerLookup.ContainerLogEntry>> getLogsInRangeAsync(class_2338 center, int range, String worldName) {
        if (!initialized) {
            return CompletableFuture.completedFuture(List.of());
        }
        return MineTracerLookup.getContainerLogsInRangeAsync(center, range, null, worldName);
    }

    public static CompletableFuture<List<MineTracerLookup.BlockLogEntry>> getBlockLogsInRangeAsync(class_2338 center, int range, String userFilter, String worldName) {
        if (!initialized) {
            return CompletableFuture.completedFuture(List.of());
        }
        return MineTracerLookup.getBlockLogsInRangeAsync(center, range, userFilter, worldName);
    }

    public static CompletableFuture<List<MineTracerLookup.ContainerLogEntry>> getContainerLogsForUserAsync(String userFilter) {
        if (!initialized) {
            return CompletableFuture.completedFuture(List.of());
        }
        return MineTracerLookup.getContainerLogsForUserAsync(userFilter);
    }

    public static List<MineTracerLookup.ContainerLogEntry> getLogsInRange(class_2338 center, int range, String worldName) {
        if (!initialized) {
            return List.of();
        }
        return MineTracerLookup.getLogsInRange(center, range, worldName);
    }

    public static List<MineTracerLookup.BlockLogEntry> getBlockLogsInRange(class_2338 center, int range, String userFilter, String worldName) {
        if (!initialized) {
            return List.of();
        }
        return MineTracerLookup.getBlockLogsInRange(center, range, userFilter, worldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInspectorMode(class_3222 player, boolean enabled) {
        Set<UUID> set = inspectorPlayers;
        synchronized (set) {
            if (enabled) {
                inspectorPlayers.add(player.method_5667());
            } else {
                inspectorPlayers.remove(player.method_5667());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInspectorMode(class_3222 player) {
        Set<UUID> set = inspectorPlayers;
        synchronized (set) {
            return inspectorPlayers.contains(player.method_5667());
        }
    }

    public static void toggleInspectorMode(class_3222 player) {
        NewOptimizedLogStorage.setInspectorMode(player, !NewOptimizedLogStorage.isInspectorMode(player));
    }

    private static String getWorldName(class_1937 world) {
        if (world == null) {
            return "unknown";
        }
        String dimensionKey = world.method_27983().method_29177().toString();
        return dimensionKey;
    }

    public static void registerServerLifecycle() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (!NewOptimizedLogStorage.initialize()) {
                System.err.println("[MineTracer] CRITICAL: Failed to initialize storage system!");
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            System.out.println("[MineTracer] Server stopping - shutting down storage system...");
            NewOptimizedLogStorage.shutdown();
        });
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getQueueStatus() {
        if (!initialized) {
            return "Storage system not initialized";
        }
        int queueSize = MineTracerConsumer.getQueueSize();
        boolean consumerRunning = MineTracerConsumer.isRunning();
        boolean paused = MineTracerConsumer.isPaused();
        return String.format("Queue: %d entries, Consumer: %s%s", queueSize, consumerRunning ? "running" : "stopped", paused ? " (paused)" : "");
    }

    public static void forceSave() {
        System.out.println("[MineTracer] Force save requested - data is automatically persisted to database");
    }

    public static Set<String> getAllPlayerNames() {
        if (!initialized) {
            return new HashSet<String>();
        }
        return MineTracerLookup.getAllPlayerNames();
    }
}

