/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.minetracer.features.minetracer.NewOptimizedLogStorage;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_3222;

public class OptimizedLogStorage {
    private static final List<LogEntry> logs = new ArrayList<LogEntry>();
    private static final List<BlockLogEntry> blockLogs = new ArrayList<BlockLogEntry>();
    private static final List<SignLogEntry> signLogs = new ArrayList<SignLogEntry>();
    private static final List<KillLogEntry> killLogs = new ArrayList<KillLogEntry>();
    private static final List<ItemPickupDropLogEntry> itemPickupDropLogs = new ArrayList<ItemPickupDropLogEntry>();
    private static final Object2ObjectOpenHashMap<String, List<LogEntry>> playerContainerLogs = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, List<BlockLogEntry>> playerBlockLogs = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, List<SignLogEntry>> playerSignLogs = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, List<KillLogEntry>> playerKillLogs = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, List<ItemPickupDropLogEntry>> playerItemLogs = new Object2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<List<LogEntry>> chunkContainerLogs = new Long2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<List<BlockLogEntry>> chunkBlockLogs = new Long2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<List<SignLogEntry>> chunkSignLogs = new Long2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<List<KillLogEntry>> chunkKillLogs = new Long2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<List<ItemPickupDropLogEntry>> chunkItemLogs = new Long2ObjectOpenHashMap();
    private static final Path LOG_FILE = Path.of("config", "minetracer", "logs.json");
    private static final Path BACKUP_DIR = Path.of("config", "minetracer", "backups");
    private static final Path TEMP_SAVE_FILE = Path.of("config", "minetracer", "logs_temp.json");
    private static volatile long lastKnownFileSize = 0L;
    private static volatile long totalLogEntries = 0L;
    private static final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private static final Object saveLock = new Object();
    private static volatile boolean hasUnsavedChanges = false;
    private static volatile boolean isShuttingDown = false;
    private static volatile boolean logsLoaded = false;
    private static ScheduledExecutorService saveScheduler;
    private static ExecutorService queryExecutor;
    private static ExecutorService indexingExecutor;
    private static Cache<String, List<?>> queryCache;
    private static volatile boolean cacheInvalidationPending;
    private static final ScheduledExecutorService cacheInvalidationExecutor;
    private static final Deque<SaveHistory> saveHistoryQueue;
    private static final Object saveHistoryLock;
    private static ScheduledExecutorService backupScheduler;
    private static final Gson GSON;
    private static final Set<UUID> inspectorPlayers;

    private static void verifyFileIntegrity() {
        try {
            if (!Files.exists(LOG_FILE, new LinkOption[0])) {
                System.out.println("[MineTracer] WARNING: Log file does not exist, this is normal for first run");
                return;
            }
            long currentFileSize = Files.size(LOG_FILE);
            if (lastKnownFileSize > 0L && currentFileSize < lastKnownFileSize) {
                System.err.println("[MineTracer] CRITICAL WARNING: Log file has shrunk from " + lastKnownFileSize + " to " + currentFileSize + " bytes! Possible data corruption detected!");
                OptimizedLogStorage.createEmergencyBackup();
            }
            lastKnownFileSize = currentFileSize;
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Error verifying file integrity: " + e.getMessage());
        }
    }

    private static void createEmergencyBackup() {
        try {
            Files.createDirectories(BACKUP_DIR, new FileAttribute[0]);
            Path emergencyBackup = BACKUP_DIR.resolve("emergency_backup_" + System.currentTimeMillis() + ".json");
            if (Files.exists(LOG_FILE, new LinkOption[0])) {
                Files.copy(LOG_FILE, emergencyBackup, new CopyOption[0]);
                System.out.println("[MineTracer] Emergency backup created: " + emergencyBackup);
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to create emergency backup: " + e.getMessage());
        }
    }

    private static void createRegularBackup() {
        try {
            if (!Files.exists(LOG_FILE, new LinkOption[0])) {
                return;
            }
            Files.createDirectories(BACKUP_DIR, new FileAttribute[0]);
            try {
                Files.list(BACKUP_DIR).filter(p -> p.getFileName().toString().startsWith("backup_") && p.getFileName().toString().endsWith(".json")).sorted((a, b) -> b.getFileName().toString().compareTo(a.getFileName().toString())).skip(9L).forEach(p -> {
                    try {
                        Files.deleteIfExists(p);
                    }
                    catch (Exception e) {
                        System.err.println("[MineTracer] Failed to delete old backup: " + e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[MineTracer] Error cleaning up old backups: " + e.getMessage());
            }
            Path backup = BACKUP_DIR.resolve("backup_" + System.currentTimeMillis() + ".json");
            Files.copy(LOG_FILE, backup, new CopyOption[0]);
            System.out.println("[MineTracer] Regular backup created: " + backup.getFileName());
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to create regular backup: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performAtomicSave() {
        Object object = saveLock;
        synchronized (object) {
            try {
                HashMap<String, ArrayList<Object>> allLogs;
                Files.createDirectories(LOG_FILE.getParent(), new FileAttribute[0]);
                OptimizedLogStorage.verifyFileIntegrity();
                dataLock.readLock().lock();
                try {
                    ArrayList<LogEntryJson> containerLogsJson = new ArrayList<LogEntryJson>();
                    for (LogEntry logEntry : logs) {
                        try {
                            containerLogsJson.add(new LogEntryJson(logEntry));
                        }
                        catch (Exception exception) {
                            System.err.println("[MineTracer] Failed to serialize container log entry: " + exception.getMessage());
                        }
                    }
                    ArrayList<BlockLogEntryJson> blockLogsJson = new ArrayList<BlockLogEntryJson>();
                    for (BlockLogEntry blockLogEntry : blockLogs) {
                        blockLogsJson.add(new BlockLogEntryJson(blockLogEntry));
                    }
                    ArrayList<SignLogEntryJson> arrayList = new ArrayList<SignLogEntryJson>();
                    for (SignLogEntry signLogEntry : signLogs) {
                        arrayList.add(new SignLogEntryJson(signLogEntry));
                    }
                    ArrayList<KillLogEntryJson> arrayList2 = new ArrayList<KillLogEntryJson>();
                    for (KillLogEntry entry : killLogs) {
                        arrayList2.add(new KillLogEntryJson(entry));
                    }
                    ArrayList<ItemPickupDropLogEntryJson> arrayList3 = new ArrayList<ItemPickupDropLogEntryJson>();
                    for (ItemPickupDropLogEntry entry : itemPickupDropLogs) {
                        try {
                            arrayList3.add(new ItemPickupDropLogEntryJson(entry));
                        }
                        catch (Exception e) {
                            System.err.println("[MineTracer] Failed to serialize item log entry: " + e.getMessage());
                        }
                    }
                    allLogs = new HashMap<String, ArrayList<Object>>();
                    allLogs.put("container", containerLogsJson);
                    allLogs.put("block", blockLogsJson);
                    allLogs.put("sign", arrayList);
                    allLogs.put("kill", arrayList2);
                    allLogs.put("itemPickupDrop", arrayList3);
                    totalLogEntries = logs.size() + blockLogs.size() + signLogs.size() + killLogs.size() + itemPickupDropLogs.size();
                }
                finally {
                    dataLock.readLock().unlock();
                }
                String json = GSON.toJson(allLogs);
                Files.writeString(TEMP_SAVE_FILE, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
                Files.move(TEMP_SAVE_FILE, LOG_FILE, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                hasUnsavedChanges = false;
                lastKnownFileSize = Files.size(LOG_FILE);
                Object object2 = saveHistoryLock;
                synchronized (object2) {
                    if (saveHistoryQueue.size() >= 8) {
                        saveHistoryQueue.removeFirst();
                    }
                    saveHistoryQueue.addLast(new SaveHistory(Instant.now(), (int)totalLogEntries, lastKnownFileSize));
                }
            }
            catch (Exception e) {
                System.err.println("[MineTracer] CRITICAL: Failed to save logs! " + e.getMessage());
                e.printStackTrace();
                try {
                    Files.deleteIfExists(TEMP_SAVE_FILE);
                }
                catch (Exception cleanupEx) {
                    System.err.println("[MineTracer] Failed to cleanup temp file: " + cleanupEx.getMessage());
                }
            }
        }
    }

    private static long getChunkKey(class_2338 pos) {
        return (long)(pos.method_10263() >> 4) << 32 | (long)(pos.method_10260() >> 4) & 0xFFFFFFFFL;
    }

    private static void indexLogEntryAsync(LogEntry entry) {
        indexingExecutor.submit(() -> {
            dataLock.writeLock().lock();
            try {
                ((List)playerContainerLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                long chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                ((List)chunkContainerLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
            }
            finally {
                dataLock.writeLock().unlock();
            }
        });
    }

    private static void indexBlockLogEntryAsync(BlockLogEntry entry) {
        indexingExecutor.submit(() -> {
            dataLock.writeLock().lock();
            try {
                ((List)playerBlockLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                long chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                ((List)chunkBlockLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
            }
            finally {
                dataLock.writeLock().unlock();
            }
        });
    }

    private static void indexSignLogEntryAsync(SignLogEntry entry) {
        indexingExecutor.submit(() -> {
            dataLock.writeLock().lock();
            try {
                ((List)playerSignLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                long chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                ((List)chunkSignLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
            }
            finally {
                dataLock.writeLock().unlock();
            }
        });
    }

    private static void indexKillLogEntryAsync(KillLogEntry entry) {
        indexingExecutor.submit(() -> {
            dataLock.writeLock().lock();
            try {
                ((List)playerKillLogs.computeIfAbsent((Object)entry.killerName, k -> new ArrayList())).add(entry);
                long chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                ((List)chunkKillLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
            }
            finally {
                dataLock.writeLock().unlock();
            }
        });
    }

    private static void indexItemLogEntryAsync(ItemPickupDropLogEntry entry) {
        indexingExecutor.submit(() -> {
            dataLock.writeLock().lock();
            try {
                ((List)playerItemLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                long chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                ((List)chunkItemLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
            }
            finally {
                dataLock.writeLock().unlock();
            }
        });
    }

    private static CompletableFuture<Void> loadAllLogsAsync() {
        return CompletableFuture.runAsync(() -> {
            dataLock.writeLock().lock();
            try {
                logs.clear();
                blockLogs.clear();
                signLogs.clear();
                killLogs.clear();
                itemPickupDropLogs.clear();
                playerContainerLogs.clear();
                playerBlockLogs.clear();
                playerSignLogs.clear();
                playerKillLogs.clear();
                playerItemLogs.clear();
                chunkContainerLogs.clear();
                chunkBlockLogs.clear();
                chunkSignLogs.clear();
                chunkKillLogs.clear();
                chunkItemLogs.clear();
                Files.createDirectories(LOG_FILE.getParent(), new FileAttribute[0]);
                OptimizedLogStorage.verifyFileIntegrity();
                if (Files.exists(LOG_FILE, new LinkOption[0])) {
                    long fileSize = Files.size(LOG_FILE);
                    System.out.println("[MineTracer] Loading logs from file (" + fileSize + " bytes)");
                    String json = Files.readString(LOG_FILE, StandardCharsets.UTF_8);
                    Type type = new TypeToken<Map<String, Object>>(){}.getType();
                    Map allLogs = (Map)GSON.fromJson(json, type);
                    if (allLogs != null) {
                        long chunkKey;
                        List containerList = allLogs.getOrDefault("container", new ArrayList());
                        for (Object obj : containerList) {
                            String[] posParts = ((String)obj.get("pos")).split(",");
                            class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                            try {
                                class_2487 nbt = class_2522.method_10718((String)((String)obj.get("itemNbt")));
                                class_1799 stack = class_1799.method_7915((class_2487)nbt);
                                LogEntry entry = new LogEntry((String)obj.get("action"), (String)obj.get("playerName"), pos, stack, Instant.parse((String)obj.get("timestamp")));
                                logs.add(entry);
                                ((List)playerContainerLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                                chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                                ((List)chunkContainerLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
                            }
                            catch (Exception nbt) {}
                        }
                        List blockList = allLogs.getOrDefault("block", new ArrayList());
                        for (Object obj : blockList) {
                            String[] posParts = ((String)obj.get("pos")).split(",");
                            class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                            BlockLogEntry entry = new BlockLogEntry((String)obj.get("action"), (String)obj.get("playerName"), pos, (String)obj.get("blockId"), (String)obj.get("nbt"), Instant.parse((String)obj.get("timestamp")));
                            blockLogs.add(entry);
                            ((List)playerBlockLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                            long chunkKey2 = OptimizedLogStorage.getChunkKey(entry.pos);
                            ((List)chunkBlockLogs.computeIfAbsent(chunkKey2, k -> new ArrayList())).add(entry);
                        }
                        List signList = allLogs.getOrDefault("sign", new ArrayList());
                        for (Object obj : signList) {
                            String[] posParts = ((String)obj.get("pos")).split(",");
                            class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                            SignLogEntry entry = new SignLogEntry((String)obj.get("action"), (String)obj.get("playerName"), pos, (String)obj.get("text"), (String)obj.get("nbt"), Instant.parse((String)obj.get("timestamp")));
                            signLogs.add(entry);
                            ((List)playerSignLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                            chunkKey = OptimizedLogStorage.getChunkKey(entry.pos);
                            ((List)chunkSignLogs.computeIfAbsent(chunkKey, k -> new ArrayList())).add(entry);
                        }
                        List killList = allLogs.getOrDefault("kill", new ArrayList());
                        for (Map obj : killList) {
                            String[] posParts = ((String)obj.get("pos")).split(",");
                            class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                            KillLogEntry entry = new KillLogEntry((String)obj.get("killerName"), (String)obj.get("victimName"), pos, (String)obj.get("world"), Instant.parse((String)obj.get("timestamp")));
                            killLogs.add(entry);
                            ((List)playerKillLogs.computeIfAbsent((Object)entry.killerName, k -> new ArrayList())).add(entry);
                            long chunkKey3 = OptimizedLogStorage.getChunkKey(entry.pos);
                            ((List)chunkKillLogs.computeIfAbsent(chunkKey3, k -> new ArrayList())).add(entry);
                        }
                        List itemPickupDropList = allLogs.getOrDefault("itemPickupDrop", new ArrayList());
                        for (Map obj : itemPickupDropList) {
                            try {
                                String[] posParts = ((String)obj.get("pos")).split(",");
                                class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                                class_2487 nbt = class_2522.method_10718((String)((String)obj.get("itemNbt")));
                                class_1799 stack = class_1799.method_7915((class_2487)nbt);
                                ItemPickupDropLogEntry entry = new ItemPickupDropLogEntry((String)obj.get("action"), (String)obj.get("playerName"), pos, stack, (String)obj.get("world"), Instant.parse((String)obj.get("timestamp")));
                                itemPickupDropLogs.add(entry);
                                ((List)playerItemLogs.computeIfAbsent((Object)entry.playerName, k -> new ArrayList())).add(entry);
                                long chunkKey4 = OptimizedLogStorage.getChunkKey(entry.pos);
                                ((List)chunkItemLogs.computeIfAbsent(chunkKey4, k -> new ArrayList())).add(entry);
                            }
                            catch (Exception exception) {}
                        }
                    }
                } else {
                    System.out.println("[MineTracer] No existing log file found - starting fresh");
                }
                hasUnsavedChanges = false;
                logsLoaded = true;
                totalLogEntries = logs.size() + blockLogs.size() + signLogs.size() + killLogs.size() + itemPickupDropLogs.size();
                System.out.println("[MineTracer] Successfully loaded " + totalLogEntries + " log entries");
                System.out.println("[MineTracer] - Container logs: " + logs.size());
                System.out.println("[MineTracer] - Block logs: " + blockLogs.size());
                System.out.println("[MineTracer] - Sign logs: " + signLogs.size());
                System.out.println("[MineTracer] - Kill logs: " + killLogs.size());
                System.out.println("[MineTracer] - Item pickup/drop logs: " + itemPickupDropLogs.size());
            }
            catch (Exception e) {
                System.err.println("[MineTracer] CRITICAL ERROR loading logs: " + e.getMessage());
                e.printStackTrace();
                try {
                    OptimizedLogStorage.createEmergencyBackup();
                }
                catch (Exception backupEx) {
                    System.err.println("[MineTracer] Failed to backup corrupted file: " + backupEx.getMessage());
                }
            }
            finally {
                dataLock.writeLock().unlock();
            }
        }, queryExecutor);
    }

    public static void logContainerAction(String action, class_1657 player, class_2338 pos, class_1799 stack) {
        NewOptimizedLogStorage.logContainerAction(action, player, pos, stack);
        if (stack.method_7960()) {
            return;
        }
        LogEntry entry = new LogEntry(action, player.method_5477().getString(), pos, stack, Instant.now());
        OptimizedLogStorage.getAsyncExecutor().execute(() -> {
            dataLock.writeLock().lock();
            try {
                logs.add(entry);
                hasUnsavedChanges = true;
                if (logs.size() % 100 == 0) {
                    CompletableFuture.runAsync(() -> OptimizedLogStorage.performAtomicSave());
                }
            }
            finally {
                dataLock.writeLock().unlock();
            }
            OptimizedLogStorage.indexLogEntryAsync(entry);
            OptimizedLogStorage.invalidateQueryCache();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logBlockAction(String action, class_1657 player, class_2338 pos, String blockId, String nbt) {
        if (player instanceof class_3222) {
            NewOptimizedLogStorage.logBlockAction(action, player, pos, blockId, nbt);
        }
        BlockLogEntry entry = new BlockLogEntry(action, player.method_5477().getString(), pos, blockId, nbt, Instant.now());
        dataLock.writeLock().lock();
        try {
            blockLogs.add(entry);
            hasUnsavedChanges = true;
            if (blockLogs.size() % 100 == 0) {
                CompletableFuture.runAsync(() -> OptimizedLogStorage.performAtomicSave());
            }
        }
        finally {
            dataLock.writeLock().unlock();
        }
        OptimizedLogStorage.indexBlockLogEntryAsync(entry);
        OptimizedLogStorage.invalidateQueryCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logSignAction(String action, class_1657 player, class_2338 pos, String text, String nbt) {
        String playerName = player != null ? player.method_5477().getString() : "unknown";
        SignLogEntry entry = new SignLogEntry(action, playerName, pos, text, nbt, Instant.now());
        dataLock.writeLock().lock();
        try {
            signLogs.add(entry);
            hasUnsavedChanges = true;
        }
        finally {
            dataLock.writeLock().unlock();
        }
        OptimizedLogStorage.indexSignLogEntryAsync(entry);
        OptimizedLogStorage.invalidateQueryCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logKillAction(String killerName, String victimName, class_2338 pos, String world) {
        NewOptimizedLogStorage.logKillAction(killerName, victimName, pos, world);
        KillLogEntry entry = new KillLogEntry(killerName, victimName, pos, world, Instant.now());
        dataLock.writeLock().lock();
        try {
            killLogs.add(entry);
            hasUnsavedChanges = true;
        }
        finally {
            dataLock.writeLock().unlock();
        }
        OptimizedLogStorage.indexKillLogEntryAsync(entry);
        OptimizedLogStorage.invalidateQueryCache();
    }

    public static void logItemPickupDropAction(String action, class_1657 player, class_2338 pos, class_1799 stack, String world) {
        if (stack.method_7960() || player == null) {
            return;
        }
        if (player instanceof class_3222) {
            NewOptimizedLogStorage.logItemPickupDropAction(action, (class_1657)((class_3222)player), pos, stack, world);
        }
        ItemPickupDropLogEntry entry = new ItemPickupDropLogEntry(action, player.method_5477().getString(), pos, stack, world, Instant.now());
        OptimizedLogStorage.getAsyncExecutor().execute(() -> {
            dataLock.writeLock().lock();
            try {
                itemPickupDropLogs.add(entry);
                hasUnsavedChanges = true;
            }
            finally {
                dataLock.writeLock().unlock();
            }
            OptimizedLogStorage.indexItemLogEntryAsync(entry);
            OptimizedLogStorage.invalidateQueryCache();
        });
    }

    public static void logInventoryAction(String action, class_1657 player, class_1799 stack) {
        OptimizedLogStorage.logContainerAction(action, player, class_2338.field_10980, stack);
    }

    public static CompletableFuture<List<BlockLogEntry>> getBlockLogsInRangeAsync(class_2338 center, int range, String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            String cacheKey = "block_" + center + "_" + range + "_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList<BlockLogEntry> result = new ArrayList<BlockLogEntry>();
                int r2 = range * range;
                int chunkRange = (range >> 4) + 1;
                int centerChunkX = center.method_10263() >> 4;
                int centerChunkZ = center.method_10260() >> 4;
                for (int cx = centerChunkX - chunkRange; cx <= centerChunkX + chunkRange; ++cx) {
                    for (int cz = centerChunkZ - chunkRange; cz <= centerChunkZ + chunkRange; ++cz) {
                        long chunkKey = (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
                        List chunkEntries = (List)chunkBlockLogs.get(chunkKey);
                        if (chunkEntries == null) continue;
                        for (BlockLogEntry entry : chunkEntries) {
                            if (userFilter != null && !entry.playerName.equalsIgnoreCase(userFilter) || !(entry.pos.method_40081((double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260()) <= (double)r2)) continue;
                            result.add(entry);
                        }
                    }
                }
                queryCache.put((Object)cacheKey, result);
                ArrayList<BlockLogEntry> arrayList = result;
                return arrayList;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<SignLogEntry>> getSignLogsInRangeAsync(class_2338 center, int range, String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            String cacheKey = "sign_" + center + "_" + range + "_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList<SignLogEntry> result = new ArrayList<SignLogEntry>();
                int r2 = range * range;
                int chunkRange = (range >> 4) + 1;
                int centerChunkX = center.method_10263() >> 4;
                int centerChunkZ = center.method_10260() >> 4;
                for (int cx = centerChunkX - chunkRange; cx <= centerChunkX + chunkRange; ++cx) {
                    for (int cz = centerChunkZ - chunkRange; cz <= centerChunkZ + chunkRange; ++cz) {
                        long chunkKey = (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
                        List chunkEntries = (List)chunkSignLogs.get(chunkKey);
                        if (chunkEntries == null) continue;
                        for (SignLogEntry entry : chunkEntries) {
                            if (userFilter != null && !entry.playerName.equalsIgnoreCase(userFilter) || !(entry.pos.method_40081((double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260()) <= (double)r2)) continue;
                            result.add(entry);
                        }
                    }
                }
                queryCache.put((Object)cacheKey, result);
                ArrayList<SignLogEntry> arrayList = result;
                return arrayList;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<KillLogEntry>> getKillLogsInRangeAsync(class_2338 center, int range, String userFilter, boolean filterByKiller) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            String cacheKey = "kill_" + center + "_" + range + "_" + userFilter + "_" + filterByKiller;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList<KillLogEntry> result = new ArrayList<KillLogEntry>();
                int r2 = range * range;
                int chunkRange = (range >> 4) + 1;
                int centerChunkX = center.method_10263() >> 4;
                int centerChunkZ = center.method_10260() >> 4;
                for (int cx = centerChunkX - chunkRange; cx <= centerChunkX + chunkRange; ++cx) {
                    for (int cz = centerChunkZ - chunkRange; cz <= centerChunkZ + chunkRange; ++cz) {
                        long chunkKey = (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
                        List chunkEntries = (List)chunkKillLogs.get(chunkKey);
                        if (chunkEntries == null) continue;
                        for (KillLogEntry entry : chunkEntries) {
                            boolean userMatch = true;
                            if (userFilter != null) {
                                userMatch = filterByKiller ? entry.killerName.equalsIgnoreCase(userFilter) : entry.victimName.equalsIgnoreCase(userFilter);
                            }
                            if (!userMatch || !(entry.pos.method_40081((double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260()) <= (double)r2)) continue;
                            result.add(entry);
                        }
                    }
                }
                queryCache.put((Object)cacheKey, result);
                ArrayList<KillLogEntry> arrayList = result;
                return arrayList;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<LogEntry>> getLogsInRangeAsync(class_2338 center, int range) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            String cacheKey = "container_" + center + "_" + range;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList<LogEntry> result = new ArrayList<LogEntry>();
                int r2 = range * range;
                int chunkRange = (range >> 4) + 1;
                int centerChunkX = center.method_10263() >> 4;
                int centerChunkZ = center.method_10260() >> 4;
                for (int cx = centerChunkX - chunkRange; cx <= centerChunkX + chunkRange; ++cx) {
                    for (int cz = centerChunkZ - chunkRange; cz <= centerChunkZ + chunkRange; ++cz) {
                        long chunkKey = (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
                        List chunkEntries = (List)chunkContainerLogs.get(chunkKey);
                        if (chunkEntries == null) continue;
                        for (LogEntry entry : chunkEntries) {
                            if (!(entry.pos.method_40081((double)center.method_10263(), (double)center.method_10264(), (double)center.method_10260()) <= (double)r2)) continue;
                            result.add(entry);
                        }
                    }
                }
                queryCache.put((Object)cacheKey, result);
                ArrayList<LogEntry> arrayList = result;
                return arrayList;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<BlockLogEntry>> getBlockLogsForUserAsync(String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            if (userFilter == null || userFilter.isEmpty()) {
                return new ArrayList();
            }
            String cacheKey = "block_user_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList result = new ArrayList();
                for (Map.Entry playerEntry : playerBlockLogs.entrySet()) {
                    if (!((String)playerEntry.getKey()).equalsIgnoreCase(userFilter)) continue;
                    result.addAll((Collection)playerEntry.getValue());
                    break;
                }
                queryCache.put((Object)cacheKey, result);
                Object object = result;
                return object;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<SignLogEntry>> getSignLogsForUserAsync(String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            if (userFilter == null || userFilter.isEmpty()) {
                return new ArrayList();
            }
            String cacheKey = "sign_user_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList result = new ArrayList();
                for (Map.Entry playerEntry : playerSignLogs.entrySet()) {
                    if (!((String)playerEntry.getKey()).equalsIgnoreCase(userFilter)) continue;
                    result.addAll((Collection)playerEntry.getValue());
                    break;
                }
                queryCache.put((Object)cacheKey, result);
                Object object = result;
                return object;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<LogEntry>> getContainerLogsForUserAsync(String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            if (userFilter == null || userFilter.isEmpty()) {
                return new ArrayList();
            }
            String cacheKey = "container_user_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList result = new ArrayList();
                for (Map.Entry playerEntry : playerContainerLogs.entrySet()) {
                    if (!((String)playerEntry.getKey()).equalsIgnoreCase(userFilter)) continue;
                    result.addAll((Collection)playerEntry.getValue());
                    break;
                }
                queryCache.put((Object)cacheKey, result);
                Object object = result;
                return object;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<KillLogEntry>> getKillLogsForUserAsync(String userFilter, boolean filterByKiller) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            if (userFilter == null || userFilter.isEmpty()) {
                return new ArrayList();
            }
            String cacheKey = "kill_user_" + userFilter + "_" + filterByKiller;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList<KillLogEntry> result = new ArrayList<KillLogEntry>();
                if (filterByKiller) {
                    for (Map.Entry playerEntry : playerKillLogs.entrySet()) {
                        if (!((String)playerEntry.getKey()).equalsIgnoreCase(userFilter)) continue;
                        result.addAll((Collection)playerEntry.getValue());
                        break;
                    }
                } else {
                    for (KillLogEntry entry : killLogs) {
                        if (!entry.victimName.equalsIgnoreCase(userFilter)) continue;
                        result.add(entry);
                    }
                }
                queryCache.put((Object)cacheKey, result);
                Object object = result;
                return object;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<ItemPickupDropLogEntry>> getItemPickupDropLogsForUserAsync(String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            if (userFilter == null || userFilter.isEmpty()) {
                return new ArrayList();
            }
            String cacheKey = "item_user_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList result = new ArrayList();
                for (Map.Entry playerEntry : playerItemLogs.entrySet()) {
                    if (!((String)playerEntry.getKey()).equalsIgnoreCase(userFilter)) continue;
                    result.addAll((Collection)playerEntry.getValue());
                    break;
                }
                queryCache.put((Object)cacheKey, result);
                Object object = result;
                return object;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static CompletableFuture<List<ItemPickupDropLogEntry>> getItemPickupDropLogsInRangeAsync(class_2338 center, int range, String userFilter) {
        return CompletableFuture.supplyAsync(() -> {
            OptimizedLogStorage.ensureLogsLoaded();
            String cacheKey = "item_pickup_drop_" + center + "_" + range + "_" + userFilter;
            List cached = (List)queryCache.getIfPresent((Object)cacheKey);
            if (cached != null) {
                return cached;
            }
            dataLock.readLock().lock();
            try {
                ArrayList<ItemPickupDropLogEntry> result = new ArrayList<ItemPickupDropLogEntry>();
                int r2 = range * range;
                int chunkRange = (range >> 4) + 1;
                int centerChunkX = center.method_10263() >> 4;
                int centerChunkZ = center.method_10260() >> 4;
                for (int cx = centerChunkX - chunkRange; cx <= centerChunkX + chunkRange; ++cx) {
                    for (int cz = centerChunkZ - chunkRange; cz <= centerChunkZ + chunkRange; ++cz) {
                        long chunkKey = (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
                        List chunkEntries = (List)chunkItemLogs.get(chunkKey);
                        if (chunkEntries == null) continue;
                        for (ItemPickupDropLogEntry entry : chunkEntries) {
                            double distance;
                            boolean userMatch = userFilter == null || userFilter.isEmpty() || entry.playerName.equalsIgnoreCase(userFilter);
                            if (!userMatch || !((distance = entry.pos.method_10262((class_2382)center)) <= (double)r2)) continue;
                            result.add(entry);
                        }
                    }
                }
                queryCache.put((Object)cacheKey, result);
                ArrayList<ItemPickupDropLogEntry> arrayList = result;
                return arrayList;
            }
            finally {
                dataLock.readLock().unlock();
            }
        }, queryExecutor);
    }

    public static List<BlockLogEntry> getBlockLogsInRange(class_2338 center, int range, String userFilter) {
        try {
            return OptimizedLogStorage.getBlockLogsInRangeAsync(center, range, userFilter).get();
        }
        catch (Exception e) {
            return new ArrayList<BlockLogEntry>();
        }
    }

    public static List<SignLogEntry> getSignLogsInRange(class_2338 center, int range, String userFilter) {
        try {
            return OptimizedLogStorage.getSignLogsInRangeAsync(center, range, userFilter).get();
        }
        catch (Exception e) {
            return new ArrayList<SignLogEntry>();
        }
    }

    public static List<KillLogEntry> getKillLogsInRange(class_2338 center, int range, String userFilter, boolean filterByKiller) {
        try {
            return OptimizedLogStorage.getKillLogsInRangeAsync(center, range, userFilter, filterByKiller).get();
        }
        catch (Exception e) {
            return new ArrayList<KillLogEntry>();
        }
    }

    public static List<KillLogEntry> getKillLogsInRange(class_2338 center, int range, String userFilter) {
        return OptimizedLogStorage.getKillLogsInRange(center, range, userFilter, true);
    }

    public static List<LogEntry> getLogsInRange(class_2338 center, int range) {
        try {
            return OptimizedLogStorage.getLogsInRangeAsync(center, range).get();
        }
        catch (Exception e) {
            return new ArrayList<LogEntry>();
        }
    }

    public static List<LogEntry> getAllLogs() {
        OptimizedLogStorage.ensureLogsLoaded();
        dataLock.readLock().lock();
        try {
            ArrayList<LogEntry> arrayList = new ArrayList<LogEntry>(logs);
            return arrayList;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    public static List<BlockLogEntry> getAllBlockLogs() {
        OptimizedLogStorage.ensureLogsLoaded();
        dataLock.readLock().lock();
        try {
            ArrayList<BlockLogEntry> arrayList = new ArrayList<BlockLogEntry>(blockLogs);
            return arrayList;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    public static List<SignLogEntry> getAllSignLogs() {
        OptimizedLogStorage.ensureLogsLoaded();
        dataLock.readLock().lock();
        try {
            ArrayList<SignLogEntry> arrayList = new ArrayList<SignLogEntry>(signLogs);
            return arrayList;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    public static List<KillLogEntry> getAllKillLogs() {
        OptimizedLogStorage.ensureLogsLoaded();
        dataLock.readLock().lock();
        try {
            ArrayList<KillLogEntry> arrayList = new ArrayList<KillLogEntry>(killLogs);
            return arrayList;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    public static List<ItemPickupDropLogEntry> getAllItemPickupDropLogs() {
        OptimizedLogStorage.ensureLogsLoaded();
        dataLock.readLock().lock();
        try {
            ArrayList<ItemPickupDropLogEntry> arrayList = new ArrayList<ItemPickupDropLogEntry>(itemPickupDropLogs);
            return arrayList;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    public static List<String> getAllPlayerNames() {
        OptimizedLogStorage.ensureLogsLoaded();
        dataLock.readLock().lock();
        try {
            HashSet names = new HashSet();
            names.addAll(playerContainerLogs.keySet());
            names.addAll(playerBlockLogs.keySet());
            names.addAll(playerSignLogs.keySet());
            names.addAll(playerKillLogs.keySet());
            names.addAll(playerItemLogs.keySet());
            ArrayList<String> arrayList = new ArrayList<String>(names);
            return arrayList;
        }
        finally {
            dataLock.readLock().unlock();
        }
    }

    private static void invalidateQueryCache() {
        if (!cacheInvalidationPending) {
            cacheInvalidationPending = true;
            cacheInvalidationExecutor.schedule(() -> {
                queryCache.invalidateAll();
                cacheInvalidationPending = false;
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInspectorMode(class_3222 player, boolean enabled) {
        Set<UUID> set = inspectorPlayers;
        synchronized (set) {
            if (enabled) {
                inspectorPlayers.add(player.method_5667());
            } else {
                inspectorPlayers.remove(player.method_5667());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInspectorMode(class_3222 player) {
        Set<UUID> set = inspectorPlayers;
        synchronized (set) {
            return inspectorPlayers.contains(player.method_5667());
        }
    }

    public static void toggleInspectorMode(class_3222 player) {
        OptimizedLogStorage.setInspectorMode(player, !OptimizedLogStorage.isInspectorMode(player));
    }

    public static ExecutorService getAsyncExecutor() {
        return queryExecutor != null ? queryExecutor : ForkJoinPool.commonPool();
    }

    private static CompletableFuture<Void> saveAllLogsAsync() {
        return CompletableFuture.runAsync(() -> {
            if (hasUnsavedChanges || isShuttingDown) {
                OptimizedLogStorage.performAtomicSave();
            }
        }, queryExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SaveHistory> getSaveHistory() {
        Object object = saveHistoryLock;
        synchronized (object) {
            return new ArrayList<SaveHistory>(saveHistoryQueue);
        }
    }

    public static void forceSave() {
        try {
            OptimizedLogStorage.saveAllLogsAsync().get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void registerServerLifecycle() {
        ServerLifecycleEvents.SERVER_STARTING.register(serverInstance -> {
            try {
                OptimizedLogStorage.loadAllLogsAsync().get();
                OptimizedLogStorage.startPeriodicSaving();
                System.out.println("[MineTracer] Data protection system active - 10s saves, hourly backups, integrity monitoring");
            }
            catch (Exception e) {
                System.err.println("[MineTracer] CRITICAL: Failed to initialize data protection system!");
                e.printStackTrace();
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(serverInstance -> {
            System.out.println("[MineTracer] Server stopping - ensuring all data is saved...");
            isShuttingDown = true;
            try {
                OptimizedLogStorage.createEmergencyBackup();
                if (hasUnsavedChanges) {
                    OptimizedLogStorage.performAtomicSave();
                    System.out.println("[MineTracer] Final save completed successfully");
                }
                OptimizedLogStorage.stopPeriodicSaving();
            }
            catch (Exception e) {
                System.err.println("[MineTracer] ERROR during shutdown save: " + e.getMessage());
                e.printStackTrace();
            }
            if (indexingExecutor != null && !indexingExecutor.isShutdown()) {
                indexingExecutor.shutdown();
            }
            System.out.println("[MineTracer] Shutdown complete - all data protected");
        });
    }

    private static void startPeriodicSaving() {
        if (saveScheduler == null || saveScheduler.isShutdown()) {
            saveScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "MineTracer-LogSaver");
                t.setDaemon(true);
                return t;
            });
            saveScheduler.scheduleWithFixedDelay(() -> {
                if (hasUnsavedChanges && !isShuttingDown) {
                    OptimizedLogStorage.performAtomicSave();
                }
            }, 10L, 10L, TimeUnit.SECONDS);
            backupScheduler.scheduleWithFixedDelay(() -> {
                if (!isShuttingDown) {
                    OptimizedLogStorage.createRegularBackup();
                }
            }, 60L, 60L, TimeUnit.MINUTES);
            System.out.println("[MineTracer] Data protection initialized: 10-second saves, hourly backups");
        }
    }

    private static void stopPeriodicSaving() {
        if (saveScheduler != null && !saveScheduler.isShutdown()) {
            saveScheduler.shutdown();
            try {
                if (!saveScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    saveScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                saveScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        if (backupScheduler != null && !backupScheduler.isShutdown()) {
            backupScheduler.shutdown();
            try {
                if (!backupScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    backupScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                backupScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureLogsLoaded() {
        if (!logsLoaded) {
            Object object = saveLock;
            synchronized (object) {
                if (!logsLoaded) {
                    try {
                        OptimizedLogStorage.loadAllLogsAsync().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static {
        cacheInvalidationPending = false;
        cacheInvalidationExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "MineTracer-CacheInvalidator");
            t.setDaemon(true);
            return t;
        });
        saveHistoryQueue = new ArrayDeque<SaveHistory>(8);
        saveHistoryLock = new Object();
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Instant.class, (Object)new TypeAdapter<Instant>(){

            public void write(JsonWriter out, Instant value) throws IOException {
                out.value(value.toString());
            }

            public Instant read(JsonReader in) throws IOException {
                return Instant.parse(in.nextString());
            }
        }).create();
        queryCache = Caffeine.newBuilder().maximumSize(5000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();
        queryExecutor = ForkJoinPool.commonPool();
        indexingExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "MineTracer-Indexer");
            t.setDaemon(true);
            t.setPriority(4);
            return t;
        });
        backupScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "MineTracer-BackupManager");
            t.setDaemon(true);
            t.setPriority(4);
            return t;
        });
        inspectorPlayers = new HashSet<UUID>();
    }

    public static class LogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final class_1799 stack;
        public final Instant timestamp;
        public boolean rolledBack = false;

        public LogEntry(String action, String playerName, class_2338 pos, class_1799 stack, Instant timestamp) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.stack = stack.method_7972();
            this.timestamp = timestamp;
        }
    }

    private static class LogEntryJson {
        String action;
        String playerName;
        String pos;
        String itemNbt;
        String timestamp;

        LogEntryJson(LogEntry entry) {
            this.action = entry.action;
            this.playerName = entry.playerName;
            this.pos = entry.pos.method_10263() + "," + entry.pos.method_10264() + "," + entry.pos.method_10260();
            try {
                this.itemNbt = entry.stack.method_7953(new class_2487()).toString();
            }
            catch (Exception e) {
                this.itemNbt = "{}";
            }
            this.timestamp = entry.timestamp.toString();
        }
    }

    public static class BlockLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final String blockId;
        public final String nbt;
        public final Instant timestamp;
        public boolean rolledBack = false;

        public BlockLogEntry(String action, String playerName, class_2338 pos, String blockId, String nbt, Instant timestamp) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.blockId = blockId;
            this.nbt = nbt;
            this.timestamp = timestamp;
        }
    }

    private static class BlockLogEntryJson {
        String action;
        String playerName;
        String pos;
        String blockId;
        String nbt;
        String timestamp;

        BlockLogEntryJson(BlockLogEntry entry) {
            this.action = entry.action;
            this.playerName = entry.playerName;
            this.pos = entry.pos.method_10263() + "," + entry.pos.method_10264() + "," + entry.pos.method_10260();
            this.blockId = entry.blockId;
            this.nbt = entry.nbt;
            this.timestamp = entry.timestamp.toString();
        }
    }

    public static class SignLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final String text;
        public final String nbt;
        public final Instant timestamp;
        public boolean rolledBack = false;

        public SignLogEntry(String action, String playerName, class_2338 pos, String text, String nbt, Instant timestamp) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.text = text;
            this.nbt = nbt;
            this.timestamp = timestamp;
        }
    }

    private static class SignLogEntryJson {
        String action;
        String playerName;
        String pos;
        String text;
        String nbt;
        String timestamp;

        SignLogEntryJson(SignLogEntry entry) {
            this.action = entry.action;
            this.playerName = entry.playerName;
            this.pos = entry.pos.method_10263() + "," + entry.pos.method_10264() + "," + entry.pos.method_10260();
            this.text = entry.text;
            this.nbt = entry.nbt;
            this.timestamp = entry.timestamp.toString();
        }
    }

    public static class KillLogEntry {
        public final String action = "kill";
        public final String killerName;
        public final String victimName;
        public final class_2338 pos;
        public final String world;
        public final Instant timestamp;
        public boolean rolledBack = false;

        public KillLogEntry(String killerName, String victimName, class_2338 pos, String world, Instant timestamp) {
            this.killerName = killerName;
            this.victimName = victimName;
            this.pos = pos;
            this.world = world;
            this.timestamp = timestamp;
        }
    }

    private static class KillLogEntryJson {
        String action = "kill";
        String killerName;
        String victimName;
        String pos;
        String world;
        String timestamp;

        KillLogEntryJson(KillLogEntry entry) {
            this.killerName = entry.killerName;
            this.victimName = entry.victimName;
            this.pos = entry.pos.method_10263() + "," + entry.pos.method_10264() + "," + entry.pos.method_10260();
            this.world = entry.world;
            this.timestamp = entry.timestamp.toString();
        }
    }

    public static class ItemPickupDropLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final class_1799 stack;
        public final String world;
        public final Instant timestamp;
        public boolean rolledBack = false;

        public ItemPickupDropLogEntry(String action, String playerName, class_2338 pos, class_1799 stack, String world, Instant timestamp) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.stack = stack.method_7972();
            this.world = world;
            this.timestamp = timestamp;
        }
    }

    private static class ItemPickupDropLogEntryJson {
        String action;
        String playerName;
        String pos;
        String itemNbt;
        String world;
        String timestamp;

        ItemPickupDropLogEntryJson(ItemPickupDropLogEntry entry) {
            this.action = entry.action;
            this.playerName = entry.playerName;
            this.pos = entry.pos.method_10263() + "," + entry.pos.method_10264() + "," + entry.pos.method_10260();
            try {
                this.itemNbt = entry.stack.method_7953(new class_2487()).toString();
            }
            catch (Exception e) {
                this.itemNbt = "{}";
            }
            this.world = entry.world;
            this.timestamp = entry.timestamp.toString();
        }
    }

    public static class SaveHistory {
        public final Instant timestamp;
        public final int totalEntries;
        public final long fileSizeBytes;

        public SaveHistory(Instant timestamp, int totalEntries, long fileSizeBytes) {
            this.timestamp = timestamp;
            this.totalEntries = totalEntries;
            this.fileSizeBytes = fileSizeBytes;
        }
    }
}

