/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.cache;

import com.minetracer.features.minetracer.config.MineTracerConfig;
import com.minetracer.features.minetracer.database.MineTracerDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class UserCache {
    private static final Map<Integer, String> userIdToName = new ConcurrentHashMap<Integer, String>();
    private static final Map<String, Integer> userNameToId = new ConcurrentHashMap<String, Integer>();
    private static final Map<Integer, UUID> userIdToUuid = new ConcurrentHashMap<Integer, UUID>();
    private static final Map<UUID, Integer> userUuidToId = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<Integer, Long> lastAccessTime = new ConcurrentHashMap<Integer, Long>();
    private static long accessCounter = 0L;

    public static int getUserId(String username) {
        if (!MineTracerConfig.USER_CACHING) {
            return UserCache.loadUserIdFromDatabase(username);
        }
        Integer cached = userNameToId.get(username.toLowerCase());
        if (cached != null) {
            UserCache.updateAccessTime(cached);
            return cached;
        }
        int userId = UserCache.loadUserIdFromDatabase(username);
        if (userId > 0) {
            UserCache.cacheUser(userId, username, null);
        }
        return userId;
    }

    public static int getUserId(UUID uuid) {
        if (!MineTracerConfig.USER_CACHING) {
            return UserCache.loadUserIdFromDatabase(uuid);
        }
        Integer cached = userUuidToId.get(uuid);
        if (cached != null) {
            UserCache.updateAccessTime(cached);
            return cached;
        }
        int userId = UserCache.loadUserIdFromDatabase(uuid);
        if (userId > 0) {
            UserCache.cacheUser(userId, null, uuid);
        }
        return userId;
    }

    public static String getUsername(int userId) {
        if (!MineTracerConfig.USER_CACHING) {
            return UserCache.loadUsernameFromDatabase(userId);
        }
        String cached = userIdToName.get(userId);
        if (cached != null) {
            UserCache.updateAccessTime(userId);
            return cached;
        }
        String username = UserCache.loadUsernameFromDatabase(userId);
        if (username != null) {
            UserCache.cacheUser(userId, username, null);
        }
        return username;
    }

    public static UUID getUuid(int userId) {
        if (!MineTracerConfig.USER_CACHING) {
            return UserCache.loadUuidFromDatabase(userId);
        }
        UUID cached = userIdToUuid.get(userId);
        if (cached != null) {
            UserCache.updateAccessTime(userId);
            return cached;
        }
        UUID uuid = UserCache.loadUuidFromDatabase(userId);
        if (uuid != null) {
            UserCache.cacheUser(userId, null, uuid);
        }
        return uuid;
    }

    public static void cacheUser(int userId, String username, UUID uuid) {
        if (!MineTracerConfig.USER_CACHING) {
            return;
        }
        if (userIdToName.size() >= MineTracerConfig.USER_CACHE_SIZE) {
            UserCache.evictLRU();
        }
        if (username != null) {
            userIdToName.put(userId, username);
            userNameToId.put(username.toLowerCase(), userId);
        }
        if (uuid != null) {
            userIdToUuid.put(userId, uuid);
            userUuidToId.put(uuid, userId);
        }
        UserCache.updateAccessTime(userId);
    }

    public static void clearCache() {
        userIdToName.clear();
        userNameToId.clear();
        userIdToUuid.clear();
        userUuidToId.clear();
        lastAccessTime.clear();
        accessCounter = 0L;
    }

    public static String getCacheStats() {
        return String.format("UserCache: %d entries, %d names, %d UUIDs", userIdToName.size(), userNameToId.size(), userUuidToId.size());
    }

    private static void updateAccessTime(int userId) {
        lastAccessTime.put(userId, ++accessCounter);
    }

    private static void evictLRU() {
        int lruUserId = -1;
        long oldestAccess = Long.MAX_VALUE;
        for (Map.Entry<Integer, Long> entry : lastAccessTime.entrySet()) {
            if (entry.getValue() >= oldestAccess) continue;
            oldestAccess = entry.getValue();
            lruUserId = entry.getKey();
        }
        if (lruUserId > 0) {
            String username = userIdToName.remove(lruUserId);
            UUID uuid = userIdToUuid.remove(lruUserId);
            if (username != null) {
                userNameToId.remove(username.toLowerCase());
            }
            if (uuid != null) {
                userUuidToId.remove(uuid);
            }
            lastAccessTime.remove(lruUserId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int loadUserIdFromDatabase(String username) {
        try (Connection conn = MineTracerDatabase.getConnection();){
            if (conn == null) {
                int n = -1;
                return n;
            }
            String query = "SELECT id FROM minetracer_user WHERE name = ? COLLATE NOCASE LIMIT 1";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setString(1, username);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return -1;
                    int n = rs.getInt("id");
                    return n;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to load user ID for " + username + ": " + e.getMessage());
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int loadUserIdFromDatabase(UUID uuid) {
        try (Connection conn = MineTracerDatabase.getConnection();){
            if (conn == null) {
                int n = -1;
                return n;
            }
            String query = "SELECT id FROM minetracer_user WHERE uuid = ? LIMIT 1";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setString(1, uuid.toString());
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return -1;
                    int n = rs.getInt("id");
                    return n;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to load user ID for " + uuid + ": " + e.getMessage());
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadUsernameFromDatabase(int userId) {
        try (Connection conn = MineTracerDatabase.getConnection();){
            if (conn == null) {
                String string = null;
                return string;
            }
            String query = "SELECT name FROM minetracer_user WHERE id = ? LIMIT 1";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setInt(1, userId);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    String string = rs.getString("name");
                    return string;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to load username for ID " + userId + ": " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UUID loadUuidFromDatabase(int userId) {
        try (Connection conn = MineTracerDatabase.getConnection();){
            if (conn == null) {
                UUID uUID = null;
                return uUID;
            }
            String query = "SELECT uuid FROM minetracer_user WHERE id = ? LIMIT 1";
            try (PreparedStatement stmt = conn.prepareStatement(query);){
                stmt.setInt(1, userId);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    String uuidStr = rs.getString("uuid");
                    UUID uUID = uuidStr != null ? UUID.fromString(uuidStr) : null;
                    return uUID;
                }
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to load UUID for ID " + userId + ": " + e.getMessage());
        }
        return null;
    }
}

