/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public class MineTracerConfig {
    private static final Path CONFIG_PATH = Path.of("config", "minetracer", "config.yml");
    private static final Map<String, Object> config = new HashMap<String, Object>();
    public static int MAX_POOL_SIZE = 10;
    public static boolean ENABLE_WAL = true;
    public static int CACHE_SIZE = 10000;
    public static String SYNCHRONOUS = "NORMAL";
    public static String TEMP_STORE = "MEMORY";
    public static boolean LOG_CONTAINER_TRANSACTIONS = true;
    public static boolean LOG_BLOCK_CHANGES = true;
    public static boolean LOG_ITEM_PICKUPS = true;
    public static boolean LOG_ITEM_DROPS = true;
    public static boolean LOG_ENTITY_KILLS = true;
    public static boolean LOG_SIGN_TEXT = true;
    public static boolean LOG_CHAT_MESSAGES = false;
    public static boolean LOG_PLAYER_COMMANDS = false;
    public static int INSPECTOR_COOLDOWN_MS = 100;
    public static int DEFAULT_PAGE_SIZE = 7;
    public static int MAX_SEARCH_RADIUS = 2;
    public static boolean CLICKABLE_COORDINATES = true;
    public static int ASYNC_QUEUE_SIZE = 5000;
    public static int BATCH_INSERT_SIZE = 500;
    public static int BATCH_INSERT_INTERVAL = 100;
    public static boolean VERBOSE = false;
    public static boolean ROLLBACK_ITEMS = true;
    public static boolean ROLLBACK_ENTITIES = false;
    public static int MAX_RADIUS = 100;
    public static int DEFAULT_RADIUS = 10;
    public static boolean ENABLE_PREVIEW = true;
    public static boolean USER_CACHING = true;
    public static int USER_CACHE_SIZE = 1000;
    public static boolean HOPPER_TRANSACTIONS = true;
    public static boolean CHECK_UPDATES = true;

    public static void load() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                MineTracerConfig.copyDefaultConfig();
                System.out.println("[MineTracer] Created default configuration file");
            }
            MineTracerConfig.parseConfig();
            System.out.println("[MineTracer] Configuration loaded successfully");
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to load configuration: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void copyDefaultConfig() throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            writer.write(MineTracerConfig.getDefaultConfig());
        }
    }

    private static void parseConfig() throws IOException {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            String line;
            String currentSection = "";
            while ((line = reader.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                if (line.endsWith(":") && !line.contains(" ")) {
                    currentSection = line.substring(0, line.length() - 1);
                    continue;
                }
                if (!line.contains(":") || (parts = line.split(":", 2)).length != 2) continue;
                String key = parts[0].trim();
                String value = parts[1].trim();
                String fullKey = currentSection.isEmpty() ? key : currentSection + "." + key;
                config.put(fullKey, MineTracerConfig.parseValue(value));
            }
        }
        MineTracerConfig.applyConfig();
    }

    private static Object parseValue(String value) {
        int commentIndex = (value = value.trim()).indexOf(35);
        if (commentIndex > 0) {
            value = value.substring(0, commentIndex).trim();
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }

    private static void applyConfig() {
        MAX_POOL_SIZE = MineTracerConfig.getInt("database.max-pool-size", MAX_POOL_SIZE);
        ENABLE_WAL = MineTracerConfig.getBoolean("database.enable-wal", ENABLE_WAL);
        CACHE_SIZE = MineTracerConfig.getInt("database.cache-size", CACHE_SIZE);
        SYNCHRONOUS = MineTracerConfig.getString("database.synchronous", SYNCHRONOUS);
        TEMP_STORE = MineTracerConfig.getString("database.temp-store", TEMP_STORE);
        LOG_CONTAINER_TRANSACTIONS = MineTracerConfig.getBoolean("logging.container-transactions", LOG_CONTAINER_TRANSACTIONS);
        LOG_BLOCK_CHANGES = MineTracerConfig.getBoolean("logging.block-changes", LOG_BLOCK_CHANGES);
        LOG_ITEM_PICKUPS = MineTracerConfig.getBoolean("logging.item-pickups", LOG_ITEM_PICKUPS);
        LOG_ITEM_DROPS = MineTracerConfig.getBoolean("logging.item-drops", LOG_ITEM_DROPS);
        LOG_ENTITY_KILLS = MineTracerConfig.getBoolean("logging.entity-kills", LOG_ENTITY_KILLS);
        LOG_SIGN_TEXT = MineTracerConfig.getBoolean("logging.sign-text", LOG_SIGN_TEXT);
        LOG_CHAT_MESSAGES = MineTracerConfig.getBoolean("logging.chat-messages", LOG_CHAT_MESSAGES);
        LOG_PLAYER_COMMANDS = MineTracerConfig.getBoolean("logging.player-commands", LOG_PLAYER_COMMANDS);
        INSPECTOR_COOLDOWN_MS = MineTracerConfig.getInt("inspector.cooldown-ms", INSPECTOR_COOLDOWN_MS);
        DEFAULT_PAGE_SIZE = MineTracerConfig.getInt("inspector.default-page-size", DEFAULT_PAGE_SIZE);
        MAX_SEARCH_RADIUS = MineTracerConfig.getInt("inspector.max-search-radius", MAX_SEARCH_RADIUS);
        CLICKABLE_COORDINATES = MineTracerConfig.getBoolean("inspector.clickable-coordinates", CLICKABLE_COORDINATES);
        ASYNC_QUEUE_SIZE = MineTracerConfig.getInt("performance.async-queue-size", ASYNC_QUEUE_SIZE);
        BATCH_INSERT_SIZE = MineTracerConfig.getInt("performance.batch-insert-size", BATCH_INSERT_SIZE);
        BATCH_INSERT_INTERVAL = MineTracerConfig.getInt("performance.batch-insert-interval", BATCH_INSERT_INTERVAL);
        VERBOSE = MineTracerConfig.getBoolean("performance.verbose", VERBOSE);
        ROLLBACK_ITEMS = MineTracerConfig.getBoolean("rollback.rollback-items", ROLLBACK_ITEMS);
        ROLLBACK_ENTITIES = MineTracerConfig.getBoolean("rollback.rollback-entities", ROLLBACK_ENTITIES);
        MAX_RADIUS = MineTracerConfig.getInt("rollback.max-radius", MAX_RADIUS);
        DEFAULT_RADIUS = MineTracerConfig.getInt("rollback.default-radius", DEFAULT_RADIUS);
        ENABLE_PREVIEW = MineTracerConfig.getBoolean("rollback.enable-preview", ENABLE_PREVIEW);
        USER_CACHING = MineTracerConfig.getBoolean("features.user-caching", USER_CACHING);
        USER_CACHE_SIZE = MineTracerConfig.getInt("features.user-cache-size", USER_CACHE_SIZE);
        HOPPER_TRANSACTIONS = MineTracerConfig.getBoolean("features.hopper-transactions", HOPPER_TRANSACTIONS);
        CHECK_UPDATES = MineTracerConfig.getBoolean("features.check-updates", CHECK_UPDATES);
    }

    private static boolean getBoolean(String key, boolean defaultValue) {
        Object value = config.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    private static int getInt(String key, int defaultValue) {
        Object value = config.get(key);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    private static String getString(String key, String defaultValue) {
        Object value = config.get(key);
        return value != null ? value.toString() : defaultValue;
    }

    private static String getDefaultConfig() {
        return "# MineTracer Configuration File\n# https://github.com/HelluPeptic/mine-tracer\n\n# Database Configuration\ndatabase:\n  max-pool-size: 10\n  enable-wal: true\n  cache-size: 10000\n  synchronous: NORMAL\n  temp-store: MEMORY\n\n# Logging Configuration\nlogging:\n  container-transactions: true\n  block-changes: true\n  item-pickups: true\n  item-drops: true\n  entity-kills: true\n  sign-text: true\n  chat-messages: false\n  player-commands: false\n\n# Inspector Configuration\ninspector:\n  cooldown-ms: 100\n  default-page-size: 7\n  max-search-radius: 2\n  clickable-coordinates: true\n\n# Performance Configuration\nperformance:\n  async-queue-size: 5000\n  batch-insert-size: 500\n  batch-insert-interval: 100\n  verbose: false\n\n# Rollback Configuration\nrollback:\n  rollback-items: true\n  rollback-entities: false\n  max-radius: 100\n  default-radius: 10\n  enable-preview: true\n\n# Feature Flags\nfeatures:\n  user-caching: true\n  user-cache-size: 1000\n  hopper-transactions: true\n  check-updates: true\n";
    }
}

