/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.database;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MineTracerDatabase {
    private static final String DATABASE_VERSION = "1.0.0";
    private static final Path DATABASE_PATH = Path.of("config", "minetracer", "database.db");
    private static final ReadWriteLock CONNECTION_LOCK = new ReentrantReadWriteLock();
    public static final int CONTAINER = 0;
    public static final int BLOCK = 1;
    public static final int SIGN = 2;
    public static final int KILL = 3;
    public static final int ITEM_PICKUP_DROP = 4;
    public static final int USER = 5;
    public static final int WORLD = 6;
    private static volatile boolean databaseInitialized = false;
    private static volatile boolean shutdownInProgress = false;

    public static Connection getConnection() {
        return MineTracerDatabase.getConnection(false, 1000);
    }

    public static Connection getConnection(boolean force, int waitTime) {
        Connection connection = null;
        try {
            if (!force && shutdownInProgress) {
                return connection;
            }
            try {
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException e) {
                System.err.println("[MineTracer] SQLite JDBC driver not found: " + e.getMessage());
                return null;
            }
            Files.createDirectories(DATABASE_PATH.getParent(), new FileAttribute[0]);
            String database = "jdbc:sqlite:" + DATABASE_PATH.toAbsolutePath();
            connection = DriverManager.getConnection(database);
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("PRAGMA journal_mode=WAL;");
                statement.executeUpdate("PRAGMA synchronous=NORMAL;");
                statement.executeUpdate("PRAGMA cache_size=10000;");
                statement.executeUpdate("PRAGMA temp_store=MEMORY;");
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Database connection error: " + e.getMessage());
            e.printStackTrace();
        }
        return connection;
    }

    public static boolean initializeDatabase() {
        if (databaseInitialized) {
            return true;
        }
        CONNECTION_LOCK.writeLock().lock();
        try {
            boolean bl;
            block18: {
                Connection connection;
                block16: {
                    boolean bl2;
                    block17: {
                        if (databaseInitialized) {
                            boolean bl3 = true;
                            return bl3;
                        }
                        connection = MineTracerDatabase.getConnection(true, 0);
                        try {
                            if (connection != null) break block16;
                            bl2 = false;
                            if (connection == null) break block17;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (connection != null) {
                                    try {
                                        connection.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                System.err.println("[MineTracer] Failed to initialize database: " + e.getMessage());
                                e.printStackTrace();
                                boolean bl4 = false;
                                return bl4;
                            }
                        }
                        connection.close();
                    }
                    return bl2;
                }
                Statement statement = connection.createStatement();
                MineTracerDatabase.createContainerTable(statement);
                MineTracerDatabase.createBlockTable(statement);
                MineTracerDatabase.createSignTable(statement);
                MineTracerDatabase.createKillTable(statement);
                MineTracerDatabase.createItemPickupDropTable(statement);
                MineTracerDatabase.createUserTable(statement);
                MineTracerDatabase.createWorldTable(statement);
                MineTracerDatabase.createVersionTable(statement);
                MineTracerDatabase.createIndexes(statement);
                MineTracerDatabase.initializeVersion(statement);
                statement.close();
                databaseInitialized = true;
                System.out.println("[MineTracer] Database initialized successfully with optimized schema");
                bl = true;
                if (connection == null) break block18;
                connection.close();
            }
            return bl;
        }
        finally {
            CONNECTION_LOCK.writeLock().unlock();
        }
    }

    private static void createContainerTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_container (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, user INTEGER NOT NULL, wid INTEGER NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, type INTEGER NOT NULL, data BLOB, amount INTEGER NOT NULL, metadata BLOB, action INTEGER NOT NULL, rolled_back INTEGER DEFAULT 0);");
    }

    private static void createBlockTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_block (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, user INTEGER NOT NULL, wid INTEGER NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, type TEXT NOT NULL, data TEXT, nbt TEXT, action TEXT NOT NULL, rolled_back INTEGER DEFAULT 0);");
    }

    private static void createSignTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_sign (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, user INTEGER NOT NULL, wid INTEGER NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, action TEXT NOT NULL, text TEXT, nbt TEXT, rolled_back INTEGER DEFAULT 0);");
    }

    private static void createKillTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_kill (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, killer_user INTEGER NOT NULL, victim_name TEXT NOT NULL, wid INTEGER NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, rolled_back INTEGER DEFAULT 0);");
    }

    private static void createItemPickupDropTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_item (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, user INTEGER NOT NULL, wid INTEGER NOT NULL, x INTEGER NOT NULL, y INTEGER NOT NULL, z INTEGER NOT NULL, type INTEGER NOT NULL, data BLOB, amount INTEGER NOT NULL, action INTEGER NOT NULL, rolled_back INTEGER DEFAULT 0);");
    }

    private static void createUserTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_user (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, user TEXT NOT NULL UNIQUE, uuid TEXT NOT NULL);");
    }

    private static void createWorldTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_world (id INTEGER PRIMARY KEY, world TEXT NOT NULL UNIQUE);");
    }

    private static void createVersionTable(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE IF NOT EXISTS minetracer_version (id INTEGER PRIMARY KEY AUTOINCREMENT, time INTEGER NOT NULL, version TEXT NOT NULL);");
    }

    private static void createIndexes(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_container_location ON minetracer_container(wid,x,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_container_lookup ON minetracer_container(wid,x,y,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_container_user ON minetracer_container(user,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_container_type ON minetracer_container(type,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_container_time_user ON minetracer_container(time,user);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_container_rolled_back ON minetracer_container(rolled_back,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_location ON minetracer_block(wid,x,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_lookup ON minetracer_block(wid,x,y,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_user ON minetracer_block(user,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_type ON minetracer_block(type,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_time_user ON minetracer_block(time,user);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_block_rolled_back ON minetracer_block(rolled_back,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_sign_location ON minetracer_sign(wid,x,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_sign_user ON minetracer_sign(user,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_sign_time ON minetracer_sign(time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_kill_location ON minetracer_kill(wid,x,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_kill_killer ON minetracer_kill(killer_user,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_kill_victim ON minetracer_kill(victim_name,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_item_location ON minetracer_item(wid,x,z,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_item_user ON minetracer_item(user,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_item_type ON minetracer_item(type,time);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_user_name ON minetracer_user(user);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_user_uuid ON minetracer_user(uuid);");
        statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_world_id ON minetracer_world(id);");
    }

    private static void initializeVersion(Statement statement) throws SQLException {
        ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM minetracer_version WHERE version = '1.0.0'");
        if (rs.next() && rs.getInt(1) == 0) {
            statement.executeUpdate("INSERT INTO minetracer_version (time, version) VALUES (" + System.currentTimeMillis() / 1000L + ", '1.0.0')");
        }
        rs.close();
    }

    public static PreparedStatement prepareStatement(Connection connection, int tableType, boolean returnKeys) {
        PreparedStatement preparedStatement = null;
        try {
            String query = MineTracerDatabase.getInsertQuery(tableType);
            if (query != null) {
                preparedStatement = returnKeys ? connection.prepareStatement(query, 1) : connection.prepareStatement(query);
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to prepare statement: " + e.getMessage());
            e.printStackTrace();
        }
        return preparedStatement;
    }

    private static String getInsertQuery(int tableType) {
        switch (tableType) {
            case 0: {
                return "INSERT INTO minetracer_container (time, user, wid, x, y, z, type, data, amount, metadata, action, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            }
            case 1: {
                return "INSERT INTO minetracer_block (time, user, wid, x, y, z, type, data, nbt, action, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            }
            case 2: {
                return "INSERT INTO minetracer_sign (time, user, wid, x, y, z, action, text, nbt, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            }
            case 3: {
                return "INSERT INTO minetracer_kill (time, killer_user, victim_name, wid, x, y, z, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            }
            case 4: {
                return "INSERT INTO minetracer_item (time, user, wid, x, y, z, type, data, amount, action, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            }
            case 5: {
                return "INSERT OR IGNORE INTO minetracer_user (time, user, uuid) VALUES (?, ?, ?)";
            }
            case 6: {
                return "INSERT OR IGNORE INTO minetracer_world (id, world) VALUES (?, ?)";
            }
        }
        return null;
    }

    public static void shutdown() {
        shutdownInProgress = true;
        CONNECTION_LOCK.writeLock().lock();
        try {
            System.out.println("[MineTracer] Database shutdown completed");
        }
        finally {
            CONNECTION_LOCK.writeLock().unlock();
        }
    }

    public static boolean isInitialized() {
        return databaseInitialized;
    }
}

