/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.inspector;

import com.minetracer.features.minetracer.config.MineTracerConfig;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public abstract class BaseInspector {
    protected static final ConcurrentHashMap<String, Object[]> lookupThrottle = new ConcurrentHashMap();

    protected void checkPreconditions(class_3222 player) throws InspectionException {
        String playerName = player.method_5477().getString();
        Object[] throttleInfo = lookupThrottle.get(playerName);
        if (throttleInfo != null) {
            boolean isActive = (Boolean)throttleInfo[0];
            long lastTime = (Long)throttleInfo[1];
            if (isActive || System.currentTimeMillis() - lastTime < (long)MineTracerConfig.INSPECTOR_COOLDOWN_MS) {
                throw new InspectionException("\u00a73MineTracer \u00a7f- \u00a7cDatabase is busy. Please wait.");
            }
        }
    }

    protected void startInspection(class_3222 player) {
        String playerName = player.method_5477().getString();
        lookupThrottle.put(playerName, new Object[]{true, System.currentTimeMillis()});
    }

    protected void finishInspection(class_3222 player) {
        String playerName = player.method_5477().getString();
        lookupThrottle.put(playerName, new Object[]{false, System.currentTimeMillis()});
    }

    protected void sendMessage(class_3222 player, String message) {
        player.method_43496((class_2561)class_2561.method_43470((String)message));
    }

    public static class InspectionException
    extends Exception {
        public InspectionException(String message) {
            super(message);
        }
    }
}

