/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.inspector;

import com.minetracer.features.minetracer.MineTracerCommand;
import com.minetracer.features.minetracer.database.MineTracerLookup;
import com.minetracer.features.minetracer.inspector.BaseInspector;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class ContainerInspector
extends BaseInspector {
    public void performContainerLookup(class_3222 player, class_2338 pos) {
        CompletableFuture.runAsync(() -> {
            try {
                Object nearbyLogs;
                this.checkPreconditions(player);
                this.startInspection(player);
                String worldName = player.method_51469().method_27983().method_29177().toString();
                CompletableFuture<List<MineTracerLookup.ContainerLogEntry>> containerLogsFuture = MineTracerLookup.getContainerLogsInRangeAsync(pos, 0, null, worldName);
                Object containerLogs = containerLogsFuture.get();
                if (containerLogs.isEmpty()) {
                    System.out.println("[MineTracer] No exact match, trying 2-block radius for double chests...");
                    CompletableFuture<List<MineTracerLookup.ContainerLogEntry>> nearbyLogsFuture = MineTracerLookup.getContainerLogsInRangeAsync(pos, 2, null, worldName);
                    nearbyLogs = nearbyLogsFuture.get();
                    if (!nearbyLogs.isEmpty()) {
                        System.out.println("[MineTracer] Found " + nearbyLogs.size() + " container logs within 2 blocks");
                        containerLogs = nearbyLogs;
                    } else {
                        try {
                            List<MineTracerLookup.ContainerLogEntry> allLogs = MineTracerLookup.getContainerLogsInRangeAsync(pos, 100, null, worldName).get();
                            System.out.println("[MineTracer] Found " + allLogs.size() + " container logs in 100-block range");
                            this.sendMessage(player, "\u00a73MineTracer \u00a7f- \u00a77No container data found at exact position. Found " + allLogs.size() + " entries in 100-block range.");
                        }
                        catch (Exception e2) {
                            System.out.println("[MineTracer] Error checking broader range: " + e2.getMessage());
                            this.sendMessage(player, "\u00a73MineTracer \u00a7f- \u00a77No container data found.");
                        }
                        return;
                    }
                }
                if (containerLogs.isEmpty()) {
                    return;
                }
                ArrayList<MineTracerCommand.FlatLogEntry> flatList = new ArrayList<MineTracerCommand.FlatLogEntry>();
                nearbyLogs = containerLogs.iterator();
                while (nearbyLogs.hasNext()) {
                    MineTracerLookup.ContainerLogEntry entry = (MineTracerLookup.ContainerLogEntry)nearbyLogs.next();
                    flatList.add(new MineTracerCommand.FlatLogEntry(entry, "container"));
                }
                String inspectorQuery = "inspector:container:" + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260();
                MineTracerCommand.QueryContext queryContext = new MineTracerCommand.QueryContext(flatList, inspectorQuery, pos);
                MineTracerCommand.lastQueries.put(player.method_5667(), queryContext);
                MineTracerCommand.displayPage(player.method_5671(), flatList, 1, queryContext.entriesPerPage);
                if (flatList.size() > queryContext.entriesPerPage) {
                    this.sendMessage(player, "\u00a73MineTracer \u00a7f- \u00a77Use \u00a76/minetracer page <number> \u00a77to view more results.");
                }
            }
            catch (BaseInspector.InspectionException e) {
                this.sendMessage(player, e.getMessage());
            }
            catch (Exception e) {
                this.sendMessage(player, "\u00a73MineTracer \u00a7f- \u00a7cError performing container lookup.");
                e.printStackTrace();
            }
            finally {
                this.finishInspection(player);
            }
        });
    }

    private String getTimeAgo(Instant timestamp) {
        long seconds = Duration.between(timestamp, Instant.now()).getSeconds();
        if (seconds < 60L) {
            return seconds + "s";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "m";
        }
        if (seconds < 86400L) {
            return seconds / 3600L + "h";
        }
        return seconds / 86400L + "d";
    }
}

