/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.inspector;

import com.minetracer.features.minetracer.OptimizedLogStorage;
import com.minetracer.features.minetracer.inspector.BlockInspector;
import com.minetracer.features.minetracer.inspector.ContainerInspector;
import com.minetracer.features.minetracer.inspector.InteractionInspector;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_3222;
import net.minecraft.class_3719;
import net.minecraft.class_3866;
import net.minecraft.class_3965;

public class InspectorEventHandler {
    private static final BlockInspector blockInspector = new BlockInspector();
    private static final ContainerInspector containerInspector = new ContainerInspector();
    private static final InteractionInspector interactionInspector = new InteractionInspector();

    public static void init() {
        UseBlockCallback.EVENT.register(InspectorEventHandler::onBlockRightClick);
    }

    private static class_1269 onBlockRightClick(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (!InspectorEventHandler.isInspectorMode(serverPlayer)) {
            return class_1269.field_5811;
        }
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity != null && InspectorEventHandler.isContainer(blockEntity)) {
            containerInspector.performContainerLookup(serverPlayer, pos);
        } else {
            interactionInspector.performInteractionLookup(serverPlayer, pos);
        }
        return class_1269.field_21466;
    }

    public static void onBlockLeftClick(class_3222 player, class_2338 pos) {
        if (!InspectorEventHandler.isInspectorMode(player)) {
            return;
        }
        blockInspector.performBlockLookup(player, pos);
    }

    private static boolean isInspectorMode(class_3222 player) {
        return OptimizedLogStorage.isInspectorMode(player);
    }

    private static boolean isContainer(class_2586 blockEntity) {
        return blockEntity instanceof class_2595 || blockEntity instanceof class_3866 || blockEntity instanceof class_2614 || blockEntity instanceof class_2608 || blockEntity instanceof class_2601 || blockEntity instanceof class_2627 || blockEntity instanceof class_3719 || blockEntity instanceof class_1263;
    }
}

