/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.rollback;

import com.minetracer.features.minetracer.config.MineTracerConfig;
import com.minetracer.features.minetracer.database.MineTracerDatabase;
import com.minetracer.features.minetracer.database.MineTracerLookup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class RollbackManager {
    private static final Map<UUID, RollbackContext> lastRollbacks = new ConcurrentHashMap<UUID, RollbackContext>();

    public static RollbackContext rollback(class_3222 player, String username, class_2338 center, int radius, long timeSeconds, List<String> actions, String includeFilter) {
        RollbackContext context = new RollbackContext(player.method_5667(), "user:" + username + " time:" + timeSeconds + "s radius:" + radius);
        try {
            class_3218 world = player.method_51469();
            String worldName = world.method_27983().method_29177().toString();
            List<MineTracerLookup.BlockLogEntry> blockLogs = RollbackManager.getBlockLogsForRollback(username, worldName, center, radius, timeSeconds, actions, includeFilter);
            List<MineTracerLookup.ContainerLogEntry> containerLogs = RollbackManager.getContainerLogsForRollback(username, worldName, center, radius, timeSeconds, actions, includeFilter);
            for (MineTracerLookup.BlockLogEntry blockLogEntry : blockLogs) {
                if (!RollbackManager.rollbackBlockEntry(world, blockLogEntry)) continue;
                ++context.blocksChanged;
                ++context.totalChanges;
            }
            for (MineTracerLookup.ContainerLogEntry containerLogEntry : containerLogs) {
                if (!RollbackManager.rollbackContainerEntry(world, containerLogEntry)) continue;
                ++context.containersChanged;
                ++context.totalChanges;
            }
            RollbackManager.markAsRolledBack(blockLogs, containerLogs);
            lastRollbacks.put(player.method_5667(), context);
            player.method_43496((class_2561)class_2561.method_43470((String)String.format("\u00a73MineTracer \u00a7f- \u00a7aRollback complete! \u00a77%d blocks, %d containers", context.blocksChanged, context.containersChanged)));
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a73MineTracer \u00a7f- \u00a7cRollback failed: " + e.getMessage())));
            e.printStackTrace();
        }
        return context;
    }

    public static void previewRollback(class_3222 player, String username, class_2338 center, int radius, long timeSeconds, List<String> actions, String includeFilter) {
        if (!MineTracerConfig.ENABLE_PREVIEW) {
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a73MineTracer \u00a7f- \u00a7cPreview mode is disabled"));
            return;
        }
        try {
            String worldName = player.method_51469().method_27983().method_29177().toString();
            List<MineTracerLookup.BlockLogEntry> blockLogs = RollbackManager.getBlockLogsForRollback(username, worldName, center, radius, timeSeconds, actions, includeFilter);
            List<MineTracerLookup.ContainerLogEntry> containerLogs = RollbackManager.getContainerLogsForRollback(username, worldName, center, radius, timeSeconds, actions, includeFilter);
            int totalChanges = blockLogs.size() + containerLogs.size();
            player.method_43496((class_2561)class_2561.method_43470((String)String.format("\u00a73MineTracer \u00a7f- \u00a7ePreview: \u00a77Would rollback %d blocks and %d containers (%d total changes)", blockLogs.size(), containerLogs.size(), totalChanges)));
            player.method_43496((class_2561)class_2561.method_43470((String)"\u00a73MineTracer \u00a7f- \u00a77Run without \u00a76#preview \u00a77to apply changes"));
        }
        catch (Exception e) {
            player.method_43496((class_2561)class_2561.method_43470((String)("\u00a73MineTracer \u00a7f- \u00a7cPreview failed: " + e.getMessage())));
            e.printStackTrace();
        }
    }

    private static List<MineTracerLookup.BlockLogEntry> getBlockLogsForRollback(String username, String worldName, class_2338 center, int radius, long timeSeconds, List<String> actions, String includeFilter) throws Exception {
        ArrayList<MineTracerLookup.BlockLogEntry> result = new ArrayList<MineTracerLookup.BlockLogEntry>();
        try (Connection conn = MineTracerDatabase.getConnection();){
            if (conn == null) {
                ArrayList<MineTracerLookup.BlockLogEntry> arrayList = result;
                return arrayList;
            }
            StringBuilder query = new StringBuilder("SELECT * FROM minetracer_block WHERE rolled_back = 0 AND time >= ?");
            if (center != null && radius > 0) {
                query.append(" AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ?");
            }
            if (actions != null && !actions.isEmpty()) {
                query.append(" AND action IN (");
                for (int i = 0; i < actions.size(); ++i) {
                    query.append(i > 0 ? ",?" : "?");
                }
                query.append(")");
            }
            query.append(" ORDER BY time DESC");
            try (PreparedStatement stmt = conn.prepareStatement(query.toString());){
                int paramIndex = 1;
                long cutoffTime = Instant.now().getEpochSecond() - timeSeconds;
                stmt.setLong(paramIndex++, cutoffTime);
                if (center != null && radius > 0) {
                    stmt.setInt(paramIndex++, center.method_10263() - radius);
                    stmt.setInt(paramIndex++, center.method_10263() + radius);
                    stmt.setInt(paramIndex++, center.method_10264() - radius);
                    stmt.setInt(paramIndex++, center.method_10264() + radius);
                    stmt.setInt(paramIndex++, center.method_10260() - radius);
                    stmt.setInt(paramIndex++, center.method_10260() + radius);
                }
                if (actions != null && !actions.isEmpty()) {
                    for (String action : actions) {
                        stmt.setString(paramIndex++, action);
                    }
                }
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        String action;
                        action = rs.getString("action");
                        String playerName = username;
                        class_2338 pos = new class_2338(rs.getInt("x"), rs.getInt("y"), rs.getInt("z"));
                        String blockId = rs.getString("block_id");
                        String nbt = rs.getString("nbt");
                        Instant timestamp = Instant.ofEpochSecond(rs.getLong("time"));
                        result.add(new MineTracerLookup.BlockLogEntry(action, playerName, pos, blockId, nbt, timestamp, false));
                    }
                }
            }
        }
        return result;
    }

    private static List<MineTracerLookup.ContainerLogEntry> getContainerLogsForRollback(String username, String worldName, class_2338 center, int radius, long timeSeconds, List<String> actions, String includeFilter) throws Exception {
        return new ArrayList<MineTracerLookup.ContainerLogEntry>();
    }

    private static boolean rollbackBlockEntry(class_3218 world, MineTracerLookup.BlockLogEntry entry) {
        try {
            class_2248 block;
            class_2338 pos = entry.pos;
            if ("placed".equals(entry.action)) {
                world.method_8501(pos, class_2246.field_10124.method_9564());
                return true;
            }
            if ("broke".equals(entry.action) && (block = (class_2248)class_7923.field_41175.method_10223(new class_2960(entry.blockId))) != null) {
                class_2680 state = block.method_9564();
                if (entry.nbt == null || !entry.nbt.isEmpty()) {
                    // empty if block
                }
                world.method_8501(pos, state);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to rollback block at " + entry.pos + ": " + e.getMessage());
        }
        return false;
    }

    private static boolean rollbackContainerEntry(class_3218 world, MineTracerLookup.ContainerLogEntry entry) {
        if (!MineTracerConfig.ROLLBACK_ITEMS) {
            return false;
        }
        try {
            return false;
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to rollback container at " + entry.pos + ": " + e.getMessage());
            return false;
        }
    }

    private static void markAsRolledBack(List<MineTracerLookup.BlockLogEntry> blockLogs, List<MineTracerLookup.ContainerLogEntry> containerLogs) {
        try (Connection conn = MineTracerDatabase.getConnection();){
            int i;
            StringBuilder query;
            if (conn == null) {
                return;
            }
            if (!blockLogs.isEmpty()) {
                query = new StringBuilder("UPDATE minetracer_block SET rolled_back = 1 WHERE id IN (");
                for (i = 0; i < blockLogs.size(); ++i) {
                    query.append(i > 0 ? ",?" : "?");
                }
                query.append(")");
            }
            if (!containerLogs.isEmpty()) {
                query = new StringBuilder("UPDATE minetracer_container SET rolled_back = 1 WHERE id IN (");
                for (i = 0; i < containerLogs.size(); ++i) {
                    query.append(i > 0 ? ",?" : "?");
                }
                query.append(")");
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to mark entries as rolled back: " + e.getMessage());
        }
    }

    public static class RollbackContext {
        public final UUID playerId;
        public final String query;
        public final Instant startTime;
        public int blocksChanged = 0;
        public int containersChanged = 0;
        public int totalChanges = 0;

        public RollbackContext(UUID playerId, String query) {
            this.playerId = playerId;
            this.query = query;
            this.startTime = Instant.now();
        }
    }
}

