/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.util;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MaterialMatcher {
    public static boolean matchesIncludeFilter(String itemId, String includeFilter) {
        String[] filters;
        if (includeFilter == null || includeFilter.isEmpty()) {
            return true;
        }
        for (String filter : filters = includeFilter.split(",")) {
            if (!MaterialMatcher.matchesSingleFilter(itemId, filter.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesExcludeFilter(String itemId, String excludeFilter) {
        String[] filters;
        if (excludeFilter == null || excludeFilter.isEmpty()) {
            return false;
        }
        for (String filter : filters = excludeFilter.split(",")) {
            if (!MaterialMatcher.matchesSingleFilter(itemId, filter.trim())) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesSingleFilter(String itemId, String filter) {
        String itemNameOnly;
        if (filter == null || filter.isEmpty()) {
            return false;
        }
        String filterLower = filter.toLowerCase();
        String itemIdLower = itemId.toLowerCase();
        if (itemIdLower.equals(filterLower)) {
            return true;
        }
        if (itemIdLower.contains(":") && (itemNameOnly = itemIdLower.substring(itemIdLower.indexOf(58) + 1)).equals(filterLower)) {
            return true;
        }
        if (filterLower.contains(":")) {
            return itemIdLower.equals(filterLower);
        }
        String minecraftPrefixed = "minecraft:" + filterLower;
        return itemIdLower.equals(minecraftPrefixed);
    }

    public static List<String> getSuggestions(String partialName) {
        String partialLower = partialName.toLowerCase();
        return class_7923.field_41178.method_10235().stream().map(class_2960::toString).filter(id -> {
            String idLower = id.toLowerCase();
            if (idLower.contains(partialLower)) {
                return true;
            }
            if (idLower.contains(":")) {
                String nameOnly = idLower.substring(idLower.indexOf(58) + 1);
                return nameOnly.contains(partialLower);
            }
            return false;
        }).limit(10L).collect(Collectors.toList());
    }

    public static List<String> getBlockSuggestions(String partialName) {
        String partialLower = partialName.toLowerCase();
        return class_7923.field_41175.method_10235().stream().map(class_2960::toString).filter(id -> {
            String idLower = id.toLowerCase();
            if (idLower.contains(partialLower)) {
                return true;
            }
            if (idLower.contains(":")) {
                String nameOnly = idLower.substring(idLower.indexOf(58) + 1);
                return nameOnly.contains(partialLower);
            }
            return false;
        }).limit(10L).collect(Collectors.toList());
    }
}

