/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.database;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.minetracer.features.minetracer.database.MineTracerDatabase;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_7923;

public class MigrationUtility {
    private static final Path OLD_LOG_FILE = Path.of("config", "minetracer", "logs.json");
    private static final Gson GSON = new Gson();

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean migrateFromJSON() {
        boolean bl;
        block17: {
            Connection connection;
            Map allLogs;
            block15: {
                boolean bl2;
                block16: {
                    if (!Files.exists(OLD_LOG_FILE, new LinkOption[0])) {
                        System.out.println("[MineTracer] No existing JSON file found, skipping migration");
                        return true;
                    }
                    System.out.println("[MineTracer] Starting migration from JSON to database...");
                    String json = Files.readString(OLD_LOG_FILE, StandardCharsets.UTF_8);
                    allLogs = (Map)GSON.fromJson(json, new TypeToken<Map<String, Object>>(){}.getType());
                    if (allLogs == null) {
                        System.out.println("[MineTracer] JSON file is empty or invalid");
                        return true;
                    }
                    if (!MineTracerDatabase.isInitialized()) {
                        MineTracerDatabase.initializeDatabase();
                    }
                    connection = MineTracerDatabase.getConnection();
                    try {
                        if (connection != null) break block15;
                        System.err.println("[MineTracer] Failed to get database connection for migration");
                        bl2 = false;
                        if (connection == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (connection != null) {
                                try {
                                    connection.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            try {
                                System.err.println("[MineTracer] Migration failed: " + e.getMessage());
                                e.printStackTrace();
                                return false;
                            }
                            catch (Exception e2) {
                                System.err.println("[MineTracer] Failed to read JSON file: " + e2.getMessage());
                                e2.printStackTrace();
                                return false;
                            }
                        }
                    }
                    connection.close();
                }
                return bl2;
            }
            connection.setAutoCommit(false);
            int totalMigrated = 0;
            totalMigrated += MigrationUtility.migrateContainerLogs(connection, allLogs);
            totalMigrated += MigrationUtility.migrateBlockLogs(connection, allLogs);
            totalMigrated += MigrationUtility.migrateSignLogs(connection, allLogs);
            totalMigrated += MigrationUtility.migrateKillLogs(connection, allLogs);
            connection.commit();
            System.out.println("[MineTracer] Migration completed successfully! Migrated " + (totalMigrated += MigrationUtility.migrateItemLogs(connection, allLogs)) + " entries");
            Path backupFile = Path.of("config", "minetracer", "logs_backup_" + System.currentTimeMillis() + ".json");
            Files.move(OLD_LOG_FILE, backupFile, new CopyOption[0]);
            System.out.println("[MineTracer] Original file backed up to: " + backupFile.getFileName());
            bl = true;
            if (connection == null) break block17;
            connection.close();
        }
        return bl;
    }

    private static int migrateContainerLogs(Connection connection, Map<String, Object> allLogs) throws Exception {
        List containerList = allLogs.getOrDefault("container", List.of());
        if (containerList.isEmpty()) {
            return 0;
        }
        String query = "INSERT INTO minetracer_container (time, user, wid, x, y, z, type, data, amount, metadata, action, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = connection.prepareStatement(query);){
            int count = 0;
            for (Map obj : containerList) {
                try {
                    String[] posParts = ((String)obj.get("pos")).split(",");
                    class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                    class_2487 nbt = class_2522.method_10718((String)((String)obj.get("itemNbt")));
                    class_1799 stack = class_1799.method_7915((class_2487)nbt);
                    String playerName = (String)obj.get("playerName");
                    int userId = MigrationUtility.getOrCreateUserId(connection, playerName);
                    int worldId = MigrationUtility.getOrCreateWorldId(connection, "minecraft:overworld");
                    Instant timestamp = Instant.parse((String)obj.get("timestamp"));
                    String action = (String)obj.get("action");
                    stmt.setLong(1, timestamp.getEpochSecond());
                    stmt.setInt(2, userId);
                    stmt.setInt(3, worldId);
                    stmt.setInt(4, pos.method_10263());
                    stmt.setInt(5, pos.method_10264());
                    stmt.setInt(6, pos.method_10260());
                    stmt.setInt(7, class_7923.field_41178.method_10206((Object)stack.method_7909()));
                    stmt.setBytes(8, nbt.toString().getBytes(StandardCharsets.UTF_8));
                    stmt.setInt(9, stack.method_7947());
                    stmt.setBytes(10, null);
                    stmt.setInt(11, action.equals("deposited") ? 1 : 0);
                    stmt.setInt(12, 0);
                    stmt.addBatch();
                    if (++count % 100 != 0) continue;
                    stmt.executeBatch();
                }
                catch (Exception e) {
                    System.err.println("[MineTracer] Failed to migrate container entry: " + e.getMessage());
                }
            }
            stmt.executeBatch();
            System.out.println("[MineTracer] Migrated " + count + " container entries");
            int n = count;
            return n;
        }
    }

    private static int migrateBlockLogs(Connection connection, Map<String, Object> allLogs) throws Exception {
        List blockList = allLogs.getOrDefault("block", List.of());
        if (blockList.isEmpty()) {
            return 0;
        }
        String query = "INSERT INTO minetracer_block (time, user, wid, x, y, z, type, data, nbt, action, rolled_back) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = connection.prepareStatement(query);){
            int count = 0;
            for (Map obj : blockList) {
                try {
                    String[] posParts = ((String)obj.get("pos")).split(",");
                    class_2338 pos = new class_2338(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
                    String playerName = (String)obj.get("playerName");
                    int userId = MigrationUtility.getOrCreateUserId(connection, playerName);
                    int worldId = MigrationUtility.getOrCreateWorldId(connection, "minecraft:overworld");
                    Instant timestamp = Instant.parse((String)obj.get("timestamp"));
                    stmt.setLong(1, timestamp.getEpochSecond());
                    stmt.setInt(2, userId);
                    stmt.setInt(3, worldId);
                    stmt.setInt(4, pos.method_10263());
                    stmt.setInt(5, pos.method_10264());
                    stmt.setInt(6, pos.method_10260());
                    stmt.setString(7, (String)obj.get("blockId"));
                    stmt.setString(8, null);
                    stmt.setString(9, (String)obj.get("nbt"));
                    stmt.setString(10, (String)obj.get("action"));
                    stmt.setInt(11, 0);
                    stmt.addBatch();
                    if (++count % 100 != 0) continue;
                    stmt.executeBatch();
                }
                catch (Exception e) {
                    System.err.println("[MineTracer] Failed to migrate block entry: " + e.getMessage());
                }
            }
            stmt.executeBatch();
            System.out.println("[MineTracer] Migrated " + count + " block entries");
            int n = count;
            return n;
        }
    }

    private static int migrateSignLogs(Connection connection, Map<String, Object> allLogs) throws Exception {
        List signList = allLogs.getOrDefault("sign", List.of());
        return signList.size();
    }

    private static int migrateKillLogs(Connection connection, Map<String, Object> allLogs) throws Exception {
        List killList = allLogs.getOrDefault("kill", List.of());
        return killList.size();
    }

    private static int migrateItemLogs(Connection connection, Map<String, Object> allLogs) throws Exception {
        List itemList = allLogs.getOrDefault("itemPickupDrop", List.of());
        return itemList.size();
    }

    private static int getOrCreateUserId(Connection connection, String userName) throws Exception {
        ResultSet rs;
        try (PreparedStatement stmt = connection.prepareStatement("SELECT id FROM minetracer_user WHERE user = ?");){
            stmt.setString(1, userName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        stmt = connection.prepareStatement("INSERT INTO minetracer_user (time, user, uuid) VALUES (?, ?, ?)", 1);
        try {
            stmt.setLong(1, System.currentTimeMillis() / 1000L);
            stmt.setString(2, userName);
            stmt.setString(3, "unknown");
            stmt.executeUpdate();
            rs = stmt.getGeneratedKeys();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return -1;
    }

    private static int getOrCreateWorldId(Connection connection, String worldName) throws Exception {
        ResultSet rs;
        try (PreparedStatement stmt = connection.prepareStatement("SELECT id FROM minetracer_world WHERE world = ?");){
            stmt.setString(1, worldName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        stmt = connection.prepareStatement("INSERT INTO minetracer_world (world) VALUES (?)", 1);
        try {
            stmt.setString(1, worldName);
            stmt.executeUpdate();
            rs = stmt.getGeneratedKeys();
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return -1;
    }
}

