/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.database;

import com.minetracer.features.minetracer.database.MineTracerProcessor;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MineTracerConsumer
implements Runnable {
    private static Thread consumerThread = null;
    private static volatile boolean isRunning = false;
    private static volatile boolean isPaused = false;
    private static volatile boolean shutdownRequested = false;
    private static volatile int currentConsumer = 0;
    private static final ConcurrentLinkedQueue<QueueEntry>[] queues = new ConcurrentLinkedQueue[]{new ConcurrentLinkedQueue(), new ConcurrentLinkedQueue()};
    private static final ConcurrentHashMap<Integer, Object>[] consumerData = new ConcurrentHashMap[]{new ConcurrentHashMap(), new ConcurrentHashMap()};
    private static final AtomicInteger entryIdCounter = new AtomicInteger(0);
    public static final int PROCESS_CONTAINER = 0;
    public static final int PROCESS_BLOCK = 1;
    public static final int PROCESS_SIGN = 2;
    public static final int PROCESS_KILL = 3;
    public static final int PROCESS_ITEM = 4;
    public static final int PROCESS_USER = 5;
    public static final int PROCESS_WORLD = 6;

    public static void startConsumer() {
        if (!isRunning) {
            isRunning = true;
            shutdownRequested = false;
            consumerThread = new Thread((Runnable)new MineTracerConsumer(), "MineTracer-Consumer");
            consumerThread.setDaemon(true);
            consumerThread.start();
            System.out.println("[MineTracer] Consumer thread started");
        }
    }

    public static void stopConsumer() {
        if (isRunning) {
            shutdownRequested = true;
            if (consumerThread != null) {
                try {
                    consumerThread.join(5000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            isRunning = false;
            System.out.println("[MineTracer] Consumer thread stopped");
        }
    }

    public static void queueEntry(int processType, Object[] data, Object associatedData) {
        if (shutdownRequested) {
            return;
        }
        int entryId = entryIdCounter.incrementAndGet();
        QueueEntry entry = new QueueEntry(entryId, processType, data);
        int consumer = currentConsumer;
        queues[consumer].offer(entry);
        if (associatedData != null) {
            consumerData[consumer].put(entryId, associatedData);
        }
    }

    @Override
    public void run() {
        MineTracerProcessor processor = new MineTracerProcessor();
        while (isRunning || !this.allQueuesEmpty()) {
            try {
                QueueEntry entry;
                int processQueue = currentConsumer;
                currentConsumer = (currentConsumer + 1) % 2;
                if (queues[processQueue].isEmpty() && isRunning) {
                    Thread.sleep(500L);
                    continue;
                }
                ArrayList<QueueEntry> batch = new ArrayList<QueueEntry>();
                while ((entry = queues[processQueue].poll()) != null && batch.size() < 100) {
                    batch.add(entry);
                }
                if (batch.isEmpty()) continue;
                processor.processBatch(batch, consumerData[processQueue]);
                for (QueueEntry batchEntry : batch) {
                    consumerData[processQueue].remove(batchEntry.id);
                }
            }
            catch (Exception e) {
                System.err.println("[MineTracer] Consumer error: " + e.getMessage());
                e.printStackTrace();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        isRunning = false;
        System.out.println("[MineTracer] Consumer thread finished");
    }

    private boolean allQueuesEmpty() {
        return queues[0].isEmpty() && queues[1].isEmpty();
    }

    public static int getQueueSize() {
        return queues[0].size() + queues[1].size();
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public static void pause() {
        isPaused = true;
    }

    public static void resume() {
        isPaused = false;
    }

    public static boolean isPaused() {
        return isPaused;
    }

    public static class QueueEntry {
        public final int id;
        public final int processType;
        public final Object[] data;
        public final long timestamp;

        public QueueEntry(int id, int processType, Object[] data) {
            this.id = id;
            this.processType = processType;
            this.data = data;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

