/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.database;

import com.minetracer.features.minetracer.database.MineTracerDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_7923;

public class MineTracerLookup {
    private static final ExecutorService queryExecutor = Executors.newFixedThreadPool(4, r -> {
        Thread t = new Thread(r, "MineTracer-Lookup");
        t.setDaemon(true);
        return t;
    });

    public static CompletableFuture<List<ContainerLogEntry>> getContainerLogsInRangeAsync(class_2338 center, int range, String userFilter, String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ContainerLogEntry> results = new ArrayList<ContainerLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<ContainerLogEntry> arrayList = results;
                    return arrayList;
                }
                StringBuilder query = new StringBuilder("SELECT c.time, u.user, c.x, c.y, c.z, c.type, c.data, c.amount, c.action, c.rolled_back FROM minetracer_container c JOIN minetracer_user u ON c.user = u.id JOIN minetracer_world w ON c.wid = w.id WHERE w.world = ? ");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(worldName);
                if (userFilter != null && !userFilter.isEmpty()) {
                    query.append("AND u.user = ? ");
                    params.add(userFilter);
                }
                query.append("AND c.x BETWEEN ? AND ? AND c.z BETWEEN ? AND ? ");
                params.add(center.method_10263() - range);
                params.add(center.method_10263() + range);
                params.add(center.method_10260() - range);
                params.add(center.method_10260() + range);
                query.append("ORDER BY c.time DESC LIMIT 1000");
                try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
                    for (int i = 0; i < params.size(); ++i) {
                        stmt.setObject(i + 1, params.get(i));
                    }
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        ContainerLogEntry entry = MineTracerLookup.parseContainerEntry(rs, center, range);
                        if (entry == null) continue;
                        results.add(entry);
                    }
                    return results;
                }
            }
            catch (Exception e) {
                System.err.println("[MineTracer] Error in container lookup: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        }, queryExecutor);
    }

    public static CompletableFuture<List<BlockLogEntry>> getBlockLogsInRangeAsync(class_2338 center, int range, String userFilter, String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<BlockLogEntry> results = new ArrayList<BlockLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<BlockLogEntry> arrayList = results;
                    return arrayList;
                }
                StringBuilder query = new StringBuilder("SELECT b.time, u.user, b.x, b.y, b.z, b.type, b.nbt, b.action, b.rolled_back FROM minetracer_block b JOIN minetracer_user u ON b.user = u.id JOIN minetracer_world w ON b.wid = w.id WHERE w.world = ? ");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(worldName);
                if (userFilter != null && !userFilter.isEmpty()) {
                    query.append("AND u.user = ? ");
                    params.add(userFilter);
                }
                query.append("AND b.x BETWEEN ? AND ? AND b.z BETWEEN ? AND ? ");
                params.add(center.method_10263() - range);
                params.add(center.method_10263() + range);
                params.add(center.method_10260() - range);
                params.add(center.method_10260() + range);
                query.append("ORDER BY b.time DESC LIMIT 1000");
                try (PreparedStatement stmt = connection.prepareStatement(query.toString());){
                    for (int i = 0; i < params.size(); ++i) {
                        stmt.setObject(i + 1, params.get(i));
                    }
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        BlockLogEntry entry = MineTracerLookup.parseBlockEntry(rs, center, range);
                        if (entry == null) continue;
                        results.add(entry);
                    }
                    return results;
                }
            }
            catch (Exception e) {
                System.err.println("[MineTracer] Error in block lookup: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        }, queryExecutor);
    }

    public static CompletableFuture<List<ContainerLogEntry>> getContainerLogsForUserAsync(String userName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ContainerLogEntry> results = new ArrayList<ContainerLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<ContainerLogEntry> arrayList = results;
                    return arrayList;
                }
                String query = "SELECT c.time, u.user, c.x, c.y, c.z, c.type, c.data, c.amount, c.action, c.rolled_back FROM minetracer_container c JOIN minetracer_user u ON c.user = u.id WHERE u.user = ? ORDER BY c.time DESC LIMIT 1000";
                try (PreparedStatement stmt = connection.prepareStatement(query);){
                    stmt.setString(1, userName);
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        ContainerLogEntry entry = MineTracerLookup.parseContainerEntry(rs, null, Integer.MAX_VALUE);
                        if (entry == null) continue;
                        results.add(entry);
                    }
                    return results;
                }
            }
            catch (Exception e) {
                System.err.println("[MineTracer] Error in user container lookup: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        }, queryExecutor);
    }

    private static ContainerLogEntry parseContainerEntry(ResultSet rs, class_2338 center, int range) throws SQLException {
        long time = rs.getLong("time");
        String user = rs.getString("user");
        int x = rs.getInt("x");
        int y = rs.getInt("y");
        int z = rs.getInt("z");
        int type = rs.getInt("type");
        byte[] data = rs.getBytes("data");
        int amount = rs.getInt("amount");
        int action = rs.getInt("action");
        boolean rolledBack = rs.getInt("rolled_back") > 0;
        class_2338 pos = new class_2338(x, y, z);
        if (center != null && pos.method_10262((class_2382)center) > (double)(range * range)) {
            return null;
        }
        class_1799 stack = MineTracerLookup.deserializeItemStack(data, type, amount);
        String actionString = action == 1 ? "deposited" : "withdrew";
        return new ContainerLogEntry(actionString, user, pos, stack, Instant.ofEpochSecond(time), rolledBack);
    }

    private static BlockLogEntry parseBlockEntry(ResultSet rs, class_2338 center, int range) throws SQLException {
        long time = rs.getLong("time");
        String user = rs.getString("user");
        int x = rs.getInt("x");
        int y = rs.getInt("y");
        int z = rs.getInt("z");
        String type = rs.getString("type");
        String nbt = rs.getString("nbt");
        String action = rs.getString("action");
        boolean rolledBack = rs.getInt("rolled_back") > 0;
        class_2338 pos = new class_2338(x, y, z);
        if (center != null && pos.method_10262((class_2382)center) > (double)(range * range)) {
            return null;
        }
        return new BlockLogEntry(action, user, pos, type, nbt, Instant.ofEpochSecond(time), rolledBack);
    }

    private static class_1799 deserializeItemStack(byte[] data, int typeId, int amount) {
        try {
            if (data != null && data.length > 0) {
                String nbtString = new String(data, "UTF-8");
                class_2487 nbt = class_2522.method_10718((String)nbtString);
                return class_1799.method_7915((class_2487)nbt);
            }
            return new class_1799((class_1935)class_7923.field_41178.method_10200(typeId), amount);
        }
        catch (Exception e) {
            return class_1799.field_8037;
        }
    }

    public static void shutdown() {
        queryExecutor.shutdown();
    }

    public static List<ContainerLogEntry> getLogsInRange(class_2338 center, int range, String worldName) {
        try {
            return MineTracerLookup.getContainerLogsInRangeAsync(center, range, null, worldName).get();
        }
        catch (Exception e) {
            return new ArrayList<ContainerLogEntry>();
        }
    }

    public static List<BlockLogEntry> getBlockLogsInRange(class_2338 center, int range, String userFilter, String worldName) {
        try {
            return MineTracerLookup.getBlockLogsInRangeAsync(center, range, userFilter, worldName).get();
        }
        catch (Exception e) {
            return new ArrayList<BlockLogEntry>();
        }
    }

    public static Set<String> getAllPlayerNames() {
        HashSet<String> playerNames = new HashSet<String>();
        try (Connection conn = MineTracerDatabase.getConnection();){
            String sql = "SELECT DISTINCT username FROM minetracer_users";
            try (PreparedStatement stmt = conn.prepareStatement(sql);
                 ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    playerNames.add(rs.getString("username"));
                }
            }
        }
        catch (SQLException e) {
            System.err.println("[MineTracer] Error getting all player names: " + e.getMessage());
            e.printStackTrace();
        }
        return playerNames;
    }

    public static CompletableFuture<List<BlockLogEntry>> getBlockLogsForUserAsync(String userName, String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<BlockLogEntry> results = new ArrayList<BlockLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<BlockLogEntry> arrayList = results;
                    return arrayList;
                }
                String query = "SELECT b.time, u.user, b.x, b.y, b.z, b.type, b.data, b.action, b.rolled_back FROM minetracer_block b JOIN minetracer_user u ON b.user = u.id JOIN minetracer_world w ON b.wid = w.id WHERE u.user = ? AND w.world = ? ORDER BY b.time DESC LIMIT 1000";
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, userName);
                statement.setString(2, worldName);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    BlockLogEntry entry = MineTracerLookup.parseBlockEntry(rs, null, Integer.MAX_VALUE);
                    if (entry == null) continue;
                    results.add(entry);
                }
                return results;
            }
            catch (SQLException e) {
                System.err.println("[MineTracer] Error getting block logs for user: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        });
    }

    public static CompletableFuture<List<ContainerLogEntry>> getContainerLogsForUserAsync(String userName, String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ContainerLogEntry> results = new ArrayList<ContainerLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<ContainerLogEntry> arrayList = results;
                    return arrayList;
                }
                String query = "SELECT c.time, u.user, c.x, c.y, c.z, c.type, c.data, c.amount, c.action, c.rolled_back FROM minetracer_container c JOIN minetracer_user u ON c.user = u.id JOIN minetracer_world w ON c.wid = w.id WHERE u.user = ? AND w.world = ? ORDER BY c.time DESC LIMIT 1000";
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, userName);
                statement.setString(2, worldName);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ContainerLogEntry entry = MineTracerLookup.parseContainerEntry(rs, null, Integer.MAX_VALUE);
                    if (entry == null) continue;
                    results.add(entry);
                }
                return results;
            }
            catch (SQLException e) {
                System.err.println("[MineTracer] Error getting container logs for user: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        });
    }

    public static CompletableFuture<List<KillLogEntry>> getKillLogsForUserAsync(String userName, String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<KillLogEntry> results = new ArrayList<KillLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<KillLogEntry> arrayList = results;
                    return arrayList;
                }
                String query = "SELECT k.time, u.user, k.x, k.y, k.z, k.weapon, k.target, k.rolled_back FROM minetracer_kill k JOIN minetracer_user u ON k.user = u.id JOIN minetracer_world w ON k.wid = w.id WHERE u.user = ? AND w.world = ? ORDER BY k.time DESC LIMIT 1000";
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, userName);
                statement.setString(2, worldName);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    long time = rs.getLong("time");
                    String user = rs.getString("user");
                    int x = rs.getInt("x");
                    int y = rs.getInt("y");
                    int z = rs.getInt("z");
                    String weapon = rs.getString("weapon");
                    String target = rs.getString("target");
                    boolean rolledBack = rs.getInt("rolled_back") > 0;
                    class_2338 pos = new class_2338(x, y, z);
                    results.add(new KillLogEntry(user, target, pos, worldName, Instant.ofEpochSecond(time), rolledBack));
                }
                return results;
            }
            catch (SQLException e) {
                System.err.println("[MineTracer] Error getting kill logs for user: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        });
    }

    public static CompletableFuture<List<ItemPickupDropLogEntry>> getItemPickupDropLogsForUserAsync(String userName, String worldName) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ItemPickupDropLogEntry> results = new ArrayList<ItemPickupDropLogEntry>();
            try (Connection connection = MineTracerDatabase.getConnection();){
                if (connection == null) {
                    ArrayList<ItemPickupDropLogEntry> arrayList = results;
                    return arrayList;
                }
                String query = "SELECT i.time, u.user, i.x, i.y, i.z, i.type, i.data, i.amount, i.action, i.rolled_back FROM minetracer_item i JOIN minetracer_user u ON i.user = u.id JOIN minetracer_world w ON i.wid = w.id WHERE u.user = ? AND w.world = ? ORDER BY i.time DESC LIMIT 1000";
                PreparedStatement statement = connection.prepareStatement(query);
                statement.setString(1, userName);
                statement.setString(2, worldName);
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    long time = rs.getLong("time");
                    String user = rs.getString("user");
                    int x = rs.getInt("x");
                    int y = rs.getInt("y");
                    int z = rs.getInt("z");
                    int type = rs.getInt("type");
                    byte[] data = rs.getBytes("data");
                    int amount = rs.getInt("amount");
                    int action = rs.getInt("action");
                    boolean rolledBack = rs.getInt("rolled_back") > 0;
                    class_2338 pos = new class_2338(x, y, z);
                    class_1799 stack = MineTracerLookup.deserializeItemStack(data, type, amount);
                    String actionString = action == 1 ? "pickup" : "drop";
                    results.add(new ItemPickupDropLogEntry(actionString, user, pos, stack, worldName, Instant.ofEpochSecond(time), rolledBack));
                }
                return results;
            }
            catch (SQLException e) {
                System.err.println("[MineTracer] Error getting item logs for user: " + e.getMessage());
                e.printStackTrace();
            }
            return results;
        });
    }

    public static class ContainerLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final class_1799 stack;
        public final Instant timestamp;
        public final boolean rolledBack;

        public ContainerLogEntry(String action, String playerName, class_2338 pos, class_1799 stack, Instant timestamp, boolean rolledBack) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.stack = stack;
            this.timestamp = timestamp;
            this.rolledBack = rolledBack;
        }
    }

    public static class BlockLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final String blockId;
        public final String nbt;
        public final Instant timestamp;
        public final boolean rolledBack;

        public BlockLogEntry(String action, String playerName, class_2338 pos, String blockId, String nbt, Instant timestamp, boolean rolledBack) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.blockId = blockId;
            this.nbt = nbt;
            this.timestamp = timestamp;
            this.rolledBack = rolledBack;
        }
    }

    public static class ItemPickupDropLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final class_1799 stack;
        public final String world;
        public final Instant timestamp;
        public final boolean rolledBack;

        public ItemPickupDropLogEntry(String action, String playerName, class_2338 pos, class_1799 stack, String world, Instant timestamp, boolean rolledBack) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.stack = stack;
            this.world = world;
            this.timestamp = timestamp;
            this.rolledBack = rolledBack;
        }
    }

    public static class KillLogEntry {
        public final String action = "kill";
        public final String killerName;
        public final String playerName;
        public final String victimName;
        public final class_2338 pos;
        public final String world;
        public final Instant timestamp;
        public final boolean rolledBack;

        public KillLogEntry(String killerName, String victimName, class_2338 pos, String world, Instant timestamp, boolean rolledBack) {
            this.killerName = killerName;
            this.playerName = killerName;
            this.victimName = victimName;
            this.pos = pos;
            this.world = world;
            this.timestamp = timestamp;
            this.rolledBack = rolledBack;
        }
    }

    public static class SignLogEntry {
        public final String action;
        public final String playerName;
        public final class_2338 pos;
        public final String text;
        public final String nbt;
        public final Instant timestamp;
        public final boolean rolledBack;

        public SignLogEntry(String action, String playerName, class_2338 pos, String text, String nbt, Instant timestamp, boolean rolledBack) {
            this.action = action;
            this.playerName = playerName;
            this.pos = pos;
            this.text = text;
            this.nbt = nbt;
            this.timestamp = timestamp;
            this.rolledBack = rolledBack;
        }
    }
}

