/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.features.minetracer.database;

import com.minetracer.features.minetracer.database.MineTracerConsumer;
import com.minetracer.features.minetracer.database.MineTracerDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_7923;

public class MineTracerProcessor {
    private static final Map<String, Integer> userIdCache = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> worldIdCache = new ConcurrentHashMap<String, Integer>();

    public void processBatch(List<MineTracerConsumer.QueueEntry> batch, Map<Integer, Object> associatedData) {
        if (batch.isEmpty()) {
            return;
        }
        try (Connection connection = MineTracerDatabase.getConnection();){
            if (connection == null) {
                System.err.println("[MineTracer] Failed to get database connection for batch processing");
                return;
            }
            connection.setAutoCommit(false);
            try {
                this.processBatchEntries(connection, batch, associatedData);
                connection.commit();
                if (batch.size() > 50) {
                    System.out.println("[MineTracer] Processed batch of " + batch.size() + " entries");
                }
            }
            catch (Exception e) {
                connection.rollback();
                System.err.println("[MineTracer] Batch processing failed, rolled back: " + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Database error during batch processing: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void processBatchEntries(Connection connection, List<MineTracerConsumer.QueueEntry> batch, Map<Integer, Object> associatedData) throws SQLException {
        for (MineTracerConsumer.QueueEntry entry : batch) {
            Object data = associatedData.get(entry.id);
            switch (entry.processType) {
                case 0: {
                    this.processContainerEntry(connection, entry, data);
                    break;
                }
                case 1: {
                    this.processBlockEntry(connection, entry, data);
                    break;
                }
                case 2: {
                    this.processSignEntry(connection, entry, data);
                    break;
                }
                case 3: {
                    this.processKillEntry(connection, entry, data);
                    break;
                }
                case 4: {
                    this.processItemEntry(connection, entry, data);
                    break;
                }
                case 5: {
                    this.processUserEntry(connection, entry, data);
                    break;
                }
                case 6: {
                    this.processWorldEntry(connection, entry, data);
                }
            }
        }
    }

    private void processContainerEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        String action = (String)entryData[0];
        String playerName = (String)entryData[1];
        class_2338 pos = (class_2338)entryData[2];
        class_1799 stack = (class_1799)entryData[3];
        String worldName = (String)entryData[4];
        int userId = this.getUserId(connection, playerName);
        int worldId = this.getWorldId(connection, worldName);
        int materialId = this.getMaterialId(stack);
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 0, false);){
            stmt.setLong(1, entry.timestamp / 1000L);
            stmt.setInt(2, userId);
            stmt.setInt(3, worldId);
            stmt.setInt(4, pos.method_10263());
            stmt.setInt(5, pos.method_10264());
            stmt.setInt(6, pos.method_10260());
            stmt.setInt(7, materialId);
            stmt.setBytes(8, this.serializeItemStack(stack));
            stmt.setInt(9, stack.method_7947());
            stmt.setBytes(10, null);
            stmt.setInt(11, action.equals("deposited") ? 1 : 0);
            stmt.setInt(12, 0);
            stmt.executeUpdate();
        }
    }

    private void processBlockEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        String action = (String)entryData[0];
        String playerName = (String)entryData[1];
        class_2338 pos = (class_2338)entryData[2];
        String blockId = (String)entryData[3];
        String nbt = (String)entryData[4];
        String worldName = (String)entryData[5];
        int userId = this.getUserId(connection, playerName);
        int worldId = this.getWorldId(connection, worldName);
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 1, false);){
            stmt.setLong(1, entry.timestamp / 1000L);
            stmt.setInt(2, userId);
            stmt.setInt(3, worldId);
            stmt.setInt(4, pos.method_10263());
            stmt.setInt(5, pos.method_10264());
            stmt.setInt(6, pos.method_10260());
            stmt.setString(7, blockId);
            stmt.setString(8, null);
            stmt.setString(9, nbt);
            stmt.setString(10, action);
            stmt.setInt(11, 0);
            stmt.executeUpdate();
        }
    }

    private void processSignEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        String action = (String)entryData[0];
        String playerName = (String)entryData[1];
        class_2338 pos = (class_2338)entryData[2];
        String text = (String)entryData[3];
        String nbt = (String)entryData[4];
        String worldName = (String)entryData[5];
        int userId = this.getUserId(connection, playerName);
        int worldId = this.getWorldId(connection, worldName);
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 2, false);){
            stmt.setLong(1, entry.timestamp / 1000L);
            stmt.setInt(2, userId);
            stmt.setInt(3, worldId);
            stmt.setInt(4, pos.method_10263());
            stmt.setInt(5, pos.method_10264());
            stmt.setInt(6, pos.method_10260());
            stmt.setString(7, action);
            stmt.setString(8, text);
            stmt.setString(9, nbt);
            stmt.setInt(10, 0);
            stmt.executeUpdate();
        }
    }

    private void processKillEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        String killerName = (String)entryData[0];
        String victimName = (String)entryData[1];
        class_2338 pos = (class_2338)entryData[2];
        String worldName = (String)entryData[3];
        int killerUserId = this.getUserId(connection, killerName);
        int worldId = this.getWorldId(connection, worldName);
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 3, false);){
            stmt.setLong(1, entry.timestamp / 1000L);
            stmt.setInt(2, killerUserId);
            stmt.setString(3, victimName);
            stmt.setInt(4, worldId);
            stmt.setInt(5, pos.method_10263());
            stmt.setInt(6, pos.method_10264());
            stmt.setInt(7, pos.method_10260());
            stmt.setInt(8, 0);
            stmt.executeUpdate();
        }
    }

    private void processItemEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        String action = (String)entryData[0];
        String playerName = (String)entryData[1];
        class_2338 pos = (class_2338)entryData[2];
        class_1799 stack = (class_1799)entryData[3];
        String worldName = (String)entryData[4];
        int userId = this.getUserId(connection, playerName);
        int worldId = this.getWorldId(connection, worldName);
        int materialId = this.getMaterialId(stack);
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 4, false);){
            stmt.setLong(1, entry.timestamp / 1000L);
            stmt.setInt(2, userId);
            stmt.setInt(3, worldId);
            stmt.setInt(4, pos.method_10263());
            stmt.setInt(5, pos.method_10264());
            stmt.setInt(6, pos.method_10260());
            stmt.setInt(7, materialId);
            stmt.setBytes(8, this.serializeItemStack(stack));
            stmt.setInt(9, stack.method_7947());
            stmt.setInt(10, action.equals("pickup") ? 0 : 1);
            stmt.setInt(11, 0);
            stmt.executeUpdate();
        }
    }

    private void processUserEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        String userName = (String)entryData[0];
        String uuid = (String)entryData[1];
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 5, false);){
            stmt.setLong(1, entry.timestamp / 1000L);
            stmt.setString(2, userName);
            stmt.setString(3, uuid);
            stmt.executeUpdate();
        }
    }

    private void processWorldEntry(Connection connection, MineTracerConsumer.QueueEntry entry, Object data) throws SQLException {
        Object[] entryData = entry.data;
        int worldId = (Integer)entryData[0];
        String worldName = (String)entryData[1];
        try (PreparedStatement stmt = MineTracerDatabase.prepareStatement(connection, 6, false);){
            stmt.setInt(1, worldId);
            stmt.setString(2, worldName);
            stmt.executeUpdate();
        }
    }

    private int getUserId(Connection connection, String userName) throws SQLException {
        Integer cachedId = userIdCache.get(userName);
        if (cachedId != null) {
            return cachedId;
        }
        try (PreparedStatement stmt = connection.prepareStatement("SELECT id FROM minetracer_user WHERE user = ?");){
            stmt.setString(1, userName);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int id = rs.getInt(1);
                userIdCache.put(userName, id);
                int n = id;
                return n;
            }
        }
        stmt = connection.prepareStatement("INSERT INTO minetracer_user (time, user, uuid) VALUES (?, ?, ?)");
        try {
            stmt.setLong(1, System.currentTimeMillis() / 1000L);
            stmt.setString(2, userName);
            stmt.setString(3, "unknown");
            stmt.executeUpdate();
            try (PreparedStatement lastIdStmt = connection.prepareStatement("SELECT last_insert_rowid()");){
                ResultSet rs = lastIdStmt.executeQuery();
                if (rs.next()) {
                    int id = rs.getInt(1);
                    userIdCache.put(userName, id);
                    int n = id;
                    return n;
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return -1;
    }

    private int getWorldId(Connection connection, String worldName) throws SQLException {
        Integer cachedId = worldIdCache.get(worldName);
        if (cachedId != null) {
            return cachedId;
        }
        try (PreparedStatement stmt = connection.prepareStatement("SELECT id FROM minetracer_world WHERE world = ?");){
            stmt.setString(1, worldName);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int id = rs.getInt(1);
                worldIdCache.put(worldName, id);
                int n = id;
                return n;
            }
        }
        stmt = connection.prepareStatement("INSERT INTO minetracer_world (world) VALUES (?)");
        try {
            stmt.setString(1, worldName);
            stmt.executeUpdate();
            try (PreparedStatement lastIdStmt = connection.prepareStatement("SELECT last_insert_rowid()");){
                ResultSet rs = lastIdStmt.executeQuery();
                if (rs.next()) {
                    int id = rs.getInt(1);
                    worldIdCache.put(worldName, id);
                    int n = id;
                    return n;
                }
            }
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return -1;
    }

    private int getMaterialId(class_1799 stack) {
        return class_7923.field_41178.method_10206((Object)stack.method_7909());
    }

    private byte[] serializeItemStack(class_1799 stack) {
        try {
            class_2487 nbt = new class_2487();
            stack.method_7953(nbt);
            return nbt.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            System.err.println("[MineTracer] Failed to serialize ItemStack: " + e.getMessage());
            return new byte[0];
        }
    }
}

