/*
 * Decompiled with CFR 0.152.
 */
package com.minetracer.mixin;

import com.google.gson.Gson;
import com.minetracer.features.minetracer.OptimizedLogStorage;
import com.minetracer.mixin.ServerPlayerInteractionManagerAccessor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3225.class})
public class MixinServerPlayerInteractionManager {
    private static final Gson GSON = new Gson();
    @Unique
    private class_2680 minetracer$prevPlacedState = null;
    @Unique
    private class_2680 minetracer$prevBrokenState = null;
    @Unique
    private class_2586 minetracer$prevBrokenBlockEntity = null;

    @Inject(method={"interactBlock"}, at={@At(value="HEAD")})
    private void minetracer$cacheBlockPlaceState(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        class_2338 placedPos = hitResult.method_17777().method_10093(hitResult.method_17780());
        this.minetracer$prevPlacedState = world.method_8320(placedPos);
    }

    @Inject(method={"interactBlock"}, at={@At(value="RETURN")})
    private void minetracer$logBlockPlace(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        if (OptimizedLogStorage.isInspectorMode(player)) {
            this.minetracer$inspectorModeInteract(player, world, stack, hand, hitResult, cir);
            return;
        }
        class_2338 placedPos = hitResult.method_17777().method_10093(hitResult.method_17780());
        class_2680 placedState = world.method_8320(placedPos);
        class_2680 prevState = this.minetracer$prevPlacedState;
        this.minetracer$prevPlacedState = null;
        if (placedState.method_26215()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)placedState.method_26204());
                class_2586 blockEntity = world.method_8321(placedPos);
                String nbt = null;
                if (!placedState.method_28501().isEmpty() || blockEntity != null) {
                    class_2487 fullNbt = new class_2487();
                    if (!placedState.method_28501().isEmpty()) {
                        class_2487 propertiesNbt = new class_2487();
                        for (class_2769 property : placedState.method_28501()) {
                            String propertyName = property.method_11899();
                            String propertyValue = placedState.method_11654(property).toString();
                            propertiesNbt.method_10582(propertyName, propertyValue);
                        }
                        fullNbt.method_10566("Properties", (class_2520)propertiesNbt);
                    }
                    if (blockEntity != null) {
                        fullNbt.method_10566("BlockEntityTag", (class_2520)blockEntity.method_38244());
                    }
                    nbt = fullNbt.toString();
                }
                if (blockEntity instanceof class_2625) {
                    class_2625 sign = (class_2625)blockEntity;
                    String[] lines = new String[4];
                    for (int i = 0; i < 4; ++i) {
                        try {
                            lines[i] = sign.method_49853().method_49859(i, false).getString();
                            continue;
                        }
                        catch (Exception e) {
                            lines[i] = "";
                        }
                    }
                    String beforeText = GSON.toJson((Object)lines);
                    OptimizedLogStorage.logSignAction("placed", (class_1657)player, placedPos, beforeText, sign.method_38244().toString());
                } else {
                    OptimizedLogStorage.logBlockAction("placed", (class_1657)player, placedPos, blockId.toString(), nbt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, OptimizedLogStorage.getAsyncExecutor());
    }

    @Inject(method={"tryBreakBlock"}, at={@At(value="HEAD")})
    private void minetracer$cacheBlockBreakState(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = ((ServerPlayerInteractionManagerAccessor)((Object)this)).getPlayer();
        class_1937 world = player.method_37908();
        this.minetracer$prevBrokenState = world.method_8320(pos);
        this.minetracer$prevBrokenBlockEntity = world.method_8321(pos);
    }

    @Inject(method={"tryBreakBlock"}, at={@At(value="RETURN")})
    private void minetracer$logBlockBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = ((ServerPlayerInteractionManagerAccessor)((Object)this)).getPlayer();
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            this.minetracer$prevBrokenState = null;
            this.minetracer$prevBrokenBlockEntity = null;
            return;
        }
        class_2680 state = this.minetracer$prevBrokenState;
        class_2586 blockEntity = this.minetracer$prevBrokenBlockEntity;
        this.minetracer$prevBrokenState = null;
        this.minetracer$prevBrokenBlockEntity = null;
        if (OptimizedLogStorage.isInspectorMode(player)) {
            this.minetracer$inspectorModeBreak(pos, cir);
            return;
        }
        if (state == null || state.method_26215()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
                String nbt = null;
                if (!state.method_28501().isEmpty() || blockEntity != null) {
                    class_2487 fullNbt = new class_2487();
                    if (!state.method_28501().isEmpty()) {
                        class_2487 propertiesNbt = new class_2487();
                        for (class_2769 property : state.method_28501()) {
                            String propertyName = property.method_11899();
                            String propertyValue = state.method_11654(property).toString();
                            propertiesNbt.method_10582(propertyName, propertyValue);
                        }
                        fullNbt.method_10566("Properties", (class_2520)propertiesNbt);
                    }
                    if (blockEntity != null) {
                        fullNbt.method_10566("BlockEntityTag", (class_2520)blockEntity.method_38244());
                    }
                    nbt = fullNbt.toString();
                }
                if (blockEntity instanceof class_2625) {
                    class_2625 sign = (class_2625)blockEntity;
                    String[] lines = new String[4];
                    for (int i = 0; i < 4; ++i) {
                        try {
                            lines[i] = sign.method_49853().method_49859(i, false).getString();
                            continue;
                        }
                        catch (Exception e) {
                            lines[i] = "";
                        }
                    }
                    String beforeText = GSON.toJson((Object)lines);
                    OptimizedLogStorage.logSignAction("broke", (class_1657)player, pos, beforeText, sign.method_38244().toString());
                } else {
                    OptimizedLogStorage.logBlockAction("broke", (class_1657)player, pos, blockId.toString(), nbt);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, OptimizedLogStorage.getAsyncExecutor());
    }

    @Unique
    private void minetracer$inspectorModeInteract(class_3222 player, class_1937 world, class_1799 stack, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        class_2338 pos = hitResult.method_17777();
        CompletableFuture.supplyAsync(() -> {
            List<OptimizedLogStorage.BlockLogEntry> blockLogs = OptimizedLogStorage.getBlockLogsInRange(pos, 0, null);
            List<OptimizedLogStorage.SignLogEntry> signLogs = OptimizedLogStorage.getSignLogsInRange(pos, 0, null);
            List<OptimizedLogStorage.LogEntry> containerLogs = OptimizedLogStorage.getLogsInRange(pos, 0);
            List<OptimizedLogStorage.KillLogEntry> killLogs = OptimizedLogStorage.getKillLogsInRange(pos, 0, null);
            boolean found = false;
            StringBuilder message = new StringBuilder("\u00a76[Inspector] Block at " + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + ":");
            for (OptimizedLogStorage.BlockLogEntry blockLogEntry : blockLogs) {
                message.append("\n\u00a77").append(blockLogEntry.action).append(" by ").append(blockLogEntry.playerName).append(" - ").append(blockLogEntry.blockId);
                found = true;
            }
            for (OptimizedLogStorage.SignLogEntry signLogEntry : signLogs) {
                message.append("\n\u00a77Sign ").append(signLogEntry.action).append(" by ").append(signLogEntry.playerName);
                found = true;
            }
            for (OptimizedLogStorage.LogEntry logEntry : containerLogs) {
                message.append("\n\u00a77Container ").append(logEntry.action).append(" by ").append(logEntry.playerName);
                found = true;
            }
            for (OptimizedLogStorage.KillLogEntry killLogEntry : killLogs) {
                if (!killLogEntry.pos.equals((Object)pos)) continue;
                message.append("\n\u00a77Kill: ").append(killLogEntry.killerName).append(" -> ").append(killLogEntry.victimName);
                found = true;
            }
            if (!found) {
                message.append("\n\u00a78No logged activity found.");
            }
            return message.toString();
        }, OptimizedLogStorage.getAsyncExecutor()).thenAccept(message -> player.method_7353((class_2561)class_2561.method_43470((String)message), false));
    }

    @Unique
    private void minetracer$inspectorModeBreak(class_2338 pos, CallbackInfoReturnable<Boolean> cir) {
        class_3222 player = ((ServerPlayerInteractionManagerAccessor)((Object)this)).getPlayer();
        CompletableFuture.supplyAsync(() -> {
            List<OptimizedLogStorage.BlockLogEntry> blockLogs = OptimizedLogStorage.getBlockLogsInRange(pos, 0, null);
            List<OptimizedLogStorage.SignLogEntry> signLogs = OptimizedLogStorage.getSignLogsInRange(pos, 0, null);
            List<OptimizedLogStorage.LogEntry> containerLogs = OptimizedLogStorage.getLogsInRange(pos, 0);
            List<OptimizedLogStorage.KillLogEntry> killLogs = OptimizedLogStorage.getKillLogsInRange(pos, 0, null);
            boolean found = false;
            StringBuilder message = new StringBuilder("\u00a76[Inspector] Block at " + pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + ":");
            for (OptimizedLogStorage.BlockLogEntry blockLogEntry : blockLogs) {
                message.append("\n\u00a77").append(blockLogEntry.action).append(" by ").append(blockLogEntry.playerName).append(" - ").append(blockLogEntry.blockId);
                found = true;
            }
            for (OptimizedLogStorage.SignLogEntry signLogEntry : signLogs) {
                message.append("\n\u00a77Sign ").append(signLogEntry.action).append(" by ").append(signLogEntry.playerName);
                found = true;
            }
            for (OptimizedLogStorage.LogEntry logEntry : containerLogs) {
                message.append("\n\u00a77Container ").append(logEntry.action).append(" by ").append(logEntry.playerName);
                found = true;
            }
            for (OptimizedLogStorage.KillLogEntry killLogEntry : killLogs) {
                if (!killLogEntry.pos.equals((Object)pos)) continue;
                message.append("\n\u00a77Kill: ").append(killLogEntry.killerName).append(" -> ").append(killLogEntry.victimName);
                found = true;
            }
            if (!found) {
                message.append("\n\u00a78No logged activity found.");
            }
            return message.toString();
        }, OptimizedLogStorage.getAsyncExecutor()).thenAccept(message -> player.method_7353((class_2561)class_2561.method_43470((String)message), false));
    }
}

