package dev.dfonline.flint.data.value;

import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

/**
 * Represents a value of a key that can be of a specific type,
 * where recognized types can return the value as their respective data type.
 */
public class DataValue {

    private final Object value;

    /**
     * Creates a new DataValue with the given value.
     *
     * @param value The value of the DataValue.
     */
    protected DataValue(Object value) {
        this.value = value;
    }

    /**
     * Creates a new DataValue with the given value, where if a recognized type is given,
     * a DataType of that type will be created.
     *
     * @param nbt The NbtElement to create the DataValue from.
     * @return The new DataValue.
     */
    public static DataValue fromNbt(class_2520 nbt) {
        if (nbt instanceof class_2519(String value)) {
            return new StringDataValue(value);
        }
        if (nbt instanceof class_2514 abstractNbtNumber) {
            return new NumberDataValue(abstractNbtNumber.method_10697());
        }
        return new UnknownDataValue(nbt);
    }

    /**
     * Gets the value of the DataValue.
     *
     * @return The value of the DataValue as an Object.
     * @implNote Make sure you really want to use this instead of the classes for specific types.
     */
    @Nullable
    public Object getValue() {
        return this.value;
    }

}
