package dev.dfonline.flint.feature.impl;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.FlintAPI;
import dev.dfonline.flint.feature.trait.ConnectionListeningFeature;
import dev.dfonline.flint.feature.trait.PacketListeningFeature;
import dev.dfonline.flint.feature.trait.TickedFeature;
import dev.dfonline.flint.hypercube.Mode;
import dev.dfonline.flint.hypercube.Plot;
import dev.dfonline.flint.hypercube.PlotSize;
import dev.dfonline.flint.util.FlintUpdate;
import dev.dfonline.flint.util.Logger;
import dev.dfonline.flint.util.result.EventResult;
import java.util.regex.Pattern;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2759;
import net.minecraft.class_5888;
import net.minecraft.class_5894;
import net.minecraft.class_638;
import net.minecraft.class_7439;

/**
 * Handles tracking the player's mode and updating it accordingly.
 */
public class ModeTrackerFeature implements PacketListeningFeature, TickedFeature, ConnectionListeningFeature {

    private static final Logger LOGGER = Logger.of(ModeTrackerFeature.class);
    private static final Pattern SPAWN_ACTION_BAR_PATTERN =
            Pattern.compile("(⏵+ - )?⧈ -?\\d+ Tokens {2}ᛥ -?\\d+ Tickets {2}⚡ -?\\d+ Sparks");
    private static final String DEV_MODE_MESSAGE = "» You are now in dev mode.";
    private static final String BUILD_MODE_MESSAGE = "» You are now in build mode.";
    private static final String JOINED_GAME_PREFIX = "» Joined game: ";
    private static final double DEV_SPAWN_OFFSET = 10.5;
    private static final int GROUND_LEVEL = 49;

    private PendingModeSwitchAction pendingAction = PendingModeSwitchAction.CLEAR_TITLE;
    private static boolean hasQueuedLocate = false;
    private static Mode queuedMode = null;
    private static boolean sentUpdateMessageThisSession = false;

    @Override
    public boolean alwaysOn() {
        return true;
    }

    private static void setMode(Mode mode) {
        if (FlintAPI.isDebugging()) {
            LOGGER.info("Setting to mode " + mode);
        }

        if (FlintAPI.shouldConfirmLocationWithLocate() && mode != Mode.NONE) {
            hasQueuedLocate = true;
        } else {
            Flint.getUser().setNode(null);
            Flint.getUser().setPlot(null);
            Flint.getUser().setMode(mode);
        }
    }

    @Override
    public EventResult onReceivePacket(class_2596<?> packet) {
        if (!hasQueuedLocate) {
            if (packet instanceof class_5888 clear && clear.method_34116()) {
                this.pendingAction = PendingModeSwitchAction.POSITION_CHANGE;
            } else if (packet instanceof class_2759 &&
                    this.pendingAction == PendingModeSwitchAction.POSITION_CHANGE) {
                this.pendingAction = PendingModeSwitchAction.MESSAGE;
            }
        }

        boolean overlayMatches = packet instanceof class_5894(Text text) &&
                this.pendingAction == PendingModeSwitchAction.MESSAGE &&
                SPAWN_ACTION_BAR_PATTERN.matcher(text.getString()).matches();

        if (overlayMatches) {
            queuedMode = Mode.SPAWN;
            this.pendingAction = PendingModeSwitchAction.CLEAR_TITLE;
        }

        if (!hasQueuedLocate &&
                packet instanceof class_7439 gameMsg &&
                this.pendingAction == PendingModeSwitchAction.MESSAGE) {
            String content = gameMsg.comp_763().getString();

            if (content.equals(DEV_MODE_MESSAGE)) {
                setMode(Mode.DEV);
            } else if (content.equals(BUILD_MODE_MESSAGE)) {
                setMode(Mode.BUILD);
            } else if (content.startsWith(JOINED_GAME_PREFIX)) {
                setMode(Mode.PLAY);
            }
        }

        return EventResult.PASS;
    }

    @Override
    public void tick() {
        if (Flint.getClient().field_1724 != null) {
            if (hasQueuedLocate) {
                hasQueuedLocate = false;
                String name = Flint.getUser().getPlayer().method_5820();
                LocateFeature.requestLocate(name).thenAccept(locate -> {
                    Flint.getUser().setNode(locate.node());
                    Flint.getUser().setNodeId(locate.nodeId());

                    class_2382 newOrigin;
                    if (locate.mode() == Mode.DEV) {
                        class_2338 blockpos = Flint.getUser().getPlayer().method_24515();
                        newOrigin = new class_2382((int) (blockpos.method_10263() + DEV_SPAWN_OFFSET), GROUND_LEVEL, (int) (blockpos.method_10260() - DEV_SPAWN_OFFSET));
                    } else {
                        newOrigin = null;
                    }

                    Plot currentPlot = Flint.getUser().getPlot();

                    if (locate.plot() != null) {
                        if (currentPlot == null || !currentPlot.equals(locate.plot())) {
                            Flint.getUser().setPlot(locate.plot());
                        }
                        if (Flint.getUser().getPlot().getDevOrigin() == null && newOrigin != null) {
                            Flint.getUser().getPlot().setDevOrigin(newOrigin);
                        }
                    } else {
                        Flint.getUser().setPlot(null);
                    }
                    Flint.getUser().setMode(locate.mode());
                });
            }
            if (queuedMode != null) {
                if (!sentUpdateMessageThisSession) {

                    FlintUpdate.sendUpdateMessage();

                    sentUpdateMessageThisSession = true;
                }
                setMode(queuedMode);
                queuedMode = null;
            }

            if (Flint.getUser().getMode() == Mode.DEV && Flint.getUser().getPlot() != null && Flint.getUser().getPlot().getDevOrigin() != null) {
                Plot plot = Flint.getUser().getPlot();
                class_2382 devOrigin = plot.getDevOrigin();

                class_2338 pos = new class_2338(devOrigin.method_10263() - 1, 49, devOrigin.method_10260());
                class_638 world = Flint.getClient().field_1687;
                if (world == null) {
                    return;
                }
                if (plot.getSize() == null) {
                    class_2680 BASIC = world.method_8320(pos.method_10077(50));
                    class_2680 BASIC_PLUS = world.method_8320(pos.method_10077(51));
                    class_2680 LARGE = world.method_8320(pos.method_10077(100));
                    class_2680 LARGE_PLUS = world.method_8320(pos.method_10077(101));
                    class_2680 MASSIVE = world.method_8320(pos.method_10077(300));
                    class_2680 MASSIVE_PLUS = world.method_8320(pos.method_10077(301));
                    class_2680 MEGA = world.method_8320(pos.method_10069(-19, 0, 10));
                    class_2680 MEGA_PLUS = world.method_8320(pos.method_10069(-20, 0, 10));
                    if (MEGA_PLUS.method_27852(class_2246.field_10219) && MEGA.method_27852(class_2246.field_10219)) {
                        plot.setSize(PlotSize.MEGA);
                    } else if (!MEGA.method_27852(class_2246.field_10243) && !MEGA_PLUS.method_27852(class_2246.field_10243) && !MEGA.method_27852(class_2246.field_10219) && !MEGA.method_27852(class_2246.field_10340) && !MEGA_PLUS.method_27852(class_2246.field_10219)) {
                        plot.setSize(PlotSize.MEGA);
                    } else if (!(BASIC.method_27852(class_2246.field_10243) || BASIC_PLUS.method_27852(class_2246.field_10243)) && !BASIC.method_27852(BASIC_PLUS.method_26204())) {
                        plot.setSize(PlotSize.BASIC);
                    } else if (!(LARGE.method_27852(class_2246.field_10243) || LARGE_PLUS.method_27852(class_2246.field_10243)) && !LARGE.method_27852(LARGE_PLUS.method_26204())) {
                        plot.setSize(PlotSize.LARGE);
                    } else if (!(MASSIVE.method_27852(class_2246.field_10243) || MASSIVE_PLUS.method_27852(class_2246.field_10243)) && !MASSIVE.method_27852(MASSIVE_PLUS.method_26204())) {
                        plot.setSize(PlotSize.MASSIVE);
                    }
                }
                PlotSize size = plot.getSize();
                class_2680 groundCheck = Flint.getClient().field_1687.method_8320(new class_2338(
                        Math.max(Math.min((int) Flint.getUser().getPlayer().method_23317(), plot.getDevOrigin().method_10263() - 1), plot.getDevOrigin().method_10263() - (size.getCodeWidth())),
                        49,
                        Math.max(Math.min((int) Flint.getUser().getPlayer().method_23321(), plot.getDevOrigin().method_10260() + size.getCodeLength()), plot.getDevOrigin().method_10260())
                ));
                if (!groundCheck.method_27852(class_2246.field_10243)) {
                    plot.setHasUnderground(!groundCheck.method_27852(class_2246.field_10219) && !groundCheck.method_27852(class_2246.field_10340));
                }
            }
        }
    }

    @Override
    public void onDisconnect() {
        setMode(Mode.NONE);
        sentUpdateMessageThisSession = false;
    }

    private enum PendingModeSwitchAction {
        CLEAR_TITLE,
        POSITION_CHANGE,
        MESSAGE
    }

}
