package dev.dfonline.flint.feature.trait;

import dev.dfonline.flint.feature.core.FeatureTrait;
import dev.dfonline.flint.util.result.ReplacementEventResult;
import net.minecraft.class_2561;

/**
 * A feature that listens for chat messages, allowing to cancel or replace them.
 */
public interface ChatListeningFeature extends FeatureTrait {

    /**
     * Called when a chat message is received.
     *
     * @param text      The text message that was received
     * @param actionbar Whether the message was displayed in the action bar
     * @return The result of the event
     */
    ReplacementEventResult<class_2561> onChatMessage(class_2561 text, boolean actionbar);

}
