package dev.dfonline.flint.feature.trait;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.dfonline.flint.feature.core.FeatureTrait;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_7157;
import java.util.Set;

import static com.mojang.brigadier.builder.LiteralArgumentBuilder.literal;

/**
 * A feature that registers client-side commands.
 */
public interface CommandFeature extends FeatureTrait {

    @Override
    default boolean alwaysOn() {
        return true;
    }

    /**
     * Returns a set of command aliases.
     *
     * @return A set of command aliases
     */
    default Set<String> aliases() {
        return Set.of();
    }

    /**
     * Returns the name of the command.
     *
     * @return The command name
     */
    String commandName();

    /**
     * Creates the command.
     *
     * @param cmd            The literal argument builder for the command
     * @param registryAccess Registry access
     * @return The command with its functionality added
     */
    LiteralArgumentBuilder<FabricClientCommandSource> createCommand(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess);

    /**
     * Registers the command and its aliases.
     *
     * @param dispatcher The command dispatcher
     * @param registryAccess Registry access
     */
    default void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register(this.createCommand(literal(this.commandName()), registryAccess));

        for (String alias : this.aliases()) {
            dispatcher.register(this.createCommand(literal(alias), registryAccess));
        }
    }

}
