package dev.dfonline.flint.feature.trait;

import dev.dfonline.flint.feature.core.FeatureTrait;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;

/**
 * A feature that can modify item tooltips.
 */
public interface TooltipRenderFeature extends FeatureTrait {

    /**
     * Called when an item tooltip is being rendered.
     *
     * @param item    The item stack being hovered over
     * @param context The tooltip context
     * @param type    The tooltip type
     * @param lore    The list of tooltip text lines that can be modified
     */
    void tooltipRender(class_1799 item, class_1792.class_9635 context, class_1836 type, List<class_2561> lore);

}
