package dev.dfonline.flint.hypercube;

import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;

public class Plot {

    private final int id;
    private final class_2561 name;
    private final String handle;
    private final boolean whitelisted;
    private class_2382 devOrigin;
    private PlotSize size;
    private boolean hasUnderground = false;
    private final String owner;

    public Plot(int id, class_2561 name, String handle, boolean whitelisted, String owner) {
        this.id = id;
        this.name = name;
        this.handle = handle;
        this.whitelisted = whitelisted;
        this.owner = owner;
    }

    public int getId() {
        return this.id;
    }

    public class_2561 getName() {
        return this.name;
    }

    public String getHandle() {
        return this.handle;
    }

    public boolean isWhitelisted() {
        return this.whitelisted;
    }

    public class_2382 getDevOrigin() {
        return this.devOrigin;
    }

    public void setDevOrigin(class_2382 origin) {
        this.devOrigin = origin;
    }

    public PlotSize getSize() {
        return Objects.requireNonNullElse(this.size, PlotSize.MASSIVE);
    }

    public void setSize(PlotSize size) {
        this.size = size;
    }

    public boolean hasUnderground() {
        return this.hasUnderground;
    }

    public void setHasUnderground(boolean hasUnderground) {
        this.hasUnderground = hasUnderground;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isPosInCodeSpace(class_2338 pos) {
        int x = pos.method_10263();
        int z = pos.method_10260();

        return x < this.devOrigin.method_10263()
                && x >= this.devOrigin.method_10263() - this.size.getCodeWidth()
                && z >= this.devOrigin.method_10260()
                && z <= this.devOrigin.method_10260() + this.size.getCodeLength();
    }

    public String toReadableString() {
        return "ID " + this.id + ", name " + this.name.getString() + ", handle " + this.handle + ", whitelisted " + this.whitelisted + ", origin " + this.devOrigin + ", owner " + this.owner;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Plot plot) {
            if (this.handle == null && plot.getHandle() != null || plot.getHandle() == null && this.handle != null) {
                return false;
            }

            return this.id == plot.getId() &&
                    this.name.equals(plot.getName()) &&
                    (this.handle == null && plot.getHandle() == null || this.handle != null && this.handle.equals(plot.getHandle())) &&
                    this.whitelisted == plot.isWhitelisted() &&
                    this.owner.equals(plot.getOwner());
        }
        return false;
    }

    @Override
    public int hashCode() {
        // Origin might be null, but it's still the same plot, so we don't include it in the hash code.
        return Objects.hash(this.id, this.name, this.handle, this.whitelisted, this.owner);
    }

}
