package dev.dfonline.flint.mixin;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.feature.core.FeatureTrait;
import dev.dfonline.flint.feature.core.FeatureTraitType;
import dev.dfonline.flint.feature.trait.ChatListeningFeature;
import dev.dfonline.flint.feature.trait.PacketListeningFeature;
import dev.dfonline.flint.util.result.EventResult;
import dev.dfonline.flint.util.result.ReplacementEventResult;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_7439;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2535.class)
public class MClientConnection {

    @Inject(method = "handlePacket", at = @At("HEAD"), cancellable = true)
    private static <T extends class_2547> void handlePacket(class_2596<T> packet, class_2547 listener, CallbackInfo ci) {
        if (packet instanceof class_7439(Text content, boolean overlay)) {
            class_2561 newMessage = null;

            for (FeatureTrait feature : Flint.FEATURE_MANAGER.getByTrait(FeatureTraitType.CHAT_LISTENING)) {
                ReplacementEventResult<class_2561> result = ((ChatListeningFeature) feature).onChatMessage(content, overlay);

                if (result.getType() == ReplacementEventResult.Type.CANCEL) {
                    ci.cancel();
                }

                if (result.getType() == ReplacementEventResult.Type.REPLACE) {
                    newMessage = result.getValue();
                }
            }

            if (newMessage != null) {
                ci.cancel();
                Flint.getUser().getPlayer().method_7353(newMessage, false);
                return;
            }
        }

        Flint.FEATURE_MANAGER.getByTrait(FeatureTraitType.PACKET_LISTENING).forEach(feature -> {
            EventResult result = ((PacketListeningFeature) feature).onReceivePacket(packet);

            if (result == EventResult.CANCEL) {
                ci.cancel();
            }
        });
    }

}
