package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import dev.dfonline.flint.Flint;
import dev.dfonline.flint.FlintAPI;
import dev.dfonline.flint.templates.argument.abstracts.Argument;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2522;

public class ItemArgument extends Argument {
    private class_1799 item;

    public ItemArgument(JsonObject json, JsonObject data) {
        super(json);
        var nbt = data.get("item").getAsString();
        try {
            assert Flint.getClient().field_1687 != null;
            setNBT(nbt);
        } catch (Exception e) {
            item = null;
        }
    }

    public String getNBT() {
        return class_1799.field_24671.encodeStart(
                Flint.getClient().field_1724.method_56673().method_57093(class_2509.field_11560), item)
            .getOrThrow(str -> new RuntimeException("Failed to parse item into NBT for templates: %s".formatted(str)))
            .toString();
    }

    public void setNBT(String nbt) {
        try {
            class_2487 nbtCompound = class_2522.method_67315(nbt);
            item = class_1799.field_24671.decode(
                    Flint.getClient().field_1724.method_56673().method_57093(class_2509.field_11560), nbtCompound)
                .getOrThrow(str -> new RuntimeException("Failed to parse NBT into item for templates: %s".formatted(str)))
                .getFirst()
            ;
        } catch (Exception e) {
            throw new RuntimeException("Failed to parse item into NBT for templates: %s".formatted(nbt), e);
        }
    }

    public ItemArgument(int slot, class_1799 item) {
        super(slot);
        this.item = item;
    }

    @Override
    public String toString() {
        return "Item [item=" + item + " " + super.toString() + "]";
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        assert Flint.getClient().field_1687 != null;
        data.addProperty("item", getNBT());
        return data;
    }

    @Override
    public String getID() {
        return "item";
    }

    public class_1799 getItem() {
        return item;
    }

    public void setItem(class_1799 item) {
        this.item = item;
    }
}
