/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.feature.core;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.feature.core.FeatureTrait;
import dev.dfonline.flint.feature.core.FeatureTraitType;
import dev.dfonline.flint.hypercube.Mode;
import java.util.ArrayList;
import java.util.List;

public class FeatureManager {
    private final List<FeatureTrait>[] featureLists = new List[FeatureTraitType.values().length];

    public FeatureManager() {
        for (int i = 0; i < this.featureLists.length; ++i) {
            this.featureLists[i] = new ArrayList<FeatureTrait>();
        }
    }

    public void register(FeatureTrait feature) {
        for (FeatureTraitType trait : FeatureTraitType.values()) {
            if (!trait.getFeatureClass().isInstance(feature)) continue;
            this.featureLists[trait.getIndex()].add(feature);
        }
    }

    public void registerAll(FeatureTrait ... features) {
        for (FeatureTrait feature : features) {
            this.register(feature);
        }
    }

    public List<FeatureTrait> getByTrait(FeatureTraitType trait, boolean onlyEnabledFeatures) {
        List<FeatureTrait> traits = this.featureLists[trait.getIndex()];
        if (Flint.getUser().getMode() == Mode.NONE) {
            traits = traits.stream().filter(FeatureTrait::alwaysOn).toList();
        }
        if (onlyEnabledFeatures) {
            return traits.stream().filter(FeatureTrait::isEnabled).toList();
        }
        return traits;
    }

    public List<FeatureTrait> getByTrait(FeatureTraitType trait) {
        return this.getByTrait(trait, true);
    }
}

