/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.feature.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.dfonline.flint.Flint;
import dev.dfonline.flint.feature.impl.CommandSenderFeature;
import dev.dfonline.flint.feature.impl.GetActionDumpFeature;
import dev.dfonline.flint.feature.impl.LocateFeature;
import dev.dfonline.flint.feature.trait.CommandFeature;
import dev.dfonline.flint.hypercube.Plot;
import dev.dfonline.flint.util.ComponentUtil;
import dev.dfonline.flint.util.FlintSound;
import dev.dfonline.flint.util.message.impl.CompoundMessage;
import dev.dfonline.flint.util.message.impl.SoundMessage;
import dev.dfonline.flint.util.message.impl.prefix.ErrorMessage;
import dev.dfonline.flint.util.message.impl.prefix.InfoMessage;
import dev.dfonline.flint.util.message.impl.prefix.SuccessMessage;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_3417;
import net.minecraft.class_7157;

public class FlintCommandFeature
implements CommandFeature {
    @Override
    public String commandName() {
        return "flint";
    }

    @Override
    public LiteralArgumentBuilder<FabricClientCommandSource> createCommand(LiteralArgumentBuilder<FabricClientCommandSource> cmd, class_7157 registryAccess) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)cmd.executes(context -> {
            Flint.getUser().sendMessage(new CompoundMessage(new SuccessMessage("flint.command.flint", new ComponentLike[0]), new SoundMessage(FlintSound.builder().setSound(class_3417.field_14815).setPitch(2.0f).build())));
            return 1;
        })).then(ClientCommandManager.literal((String)"mode").executes(context -> {
            Plot plot = Flint.getUser().getPlot();
            String plotString = "null";
            if (plot != null) {
                plotString = plot.toReadableString();
            }
            String nodeString = "null";
            if (Flint.getUser().getNode() != null) {
                nodeString = Flint.getUser().getNode().getName();
            }
            Flint.getUser().sendMessage(new CompoundMessage(new InfoMessage("flint.command.flint.mode", new ComponentLike[]{Component.text((String)Flint.getUser().getMode().getName()), Component.text((String)plotString), Component.text((String)nodeString)})));
            return 1;
        }))).then(ClientCommandManager.literal((String)"clear_queue").executes(context -> {
            if (CommandSenderFeature.queueSize() > 0) {
                CommandSenderFeature.clearQueue();
                Flint.getUser().sendMessage(new SuccessMessage("flint.command.flint.clear_queue.success", new ComponentLike[0]));
            } else {
                Flint.getUser().sendMessage(new ErrorMessage("flint.command.flint.clear_queue.empty", new ComponentLike[0]));
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"locate_test").executes(context -> {
            FlintCommandFeature.debugLocate(Flint.getUser().getPlayer().method_5820());
            return 1;
        })).then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            FlintCommandFeature.debugLocate(StringArgumentType.getString((CommandContext)context, (String)"player"));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"action_dump").executes(context -> {
            GetActionDumpFeature.getActionDump(ComponentUtil.ColorMode.MINI_MESSAGE, false);
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"color_mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ComponentUtil.ColorMode colorMode : ComponentUtil.ColorMode.values()) {
                builder.suggest(colorMode.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ComponentUtil.ColorMode colorMode = ComponentUtil.ColorMode.valueOf(StringArgumentType.getString((CommandContext)context, (String)"color_mode").toUpperCase());
            GetActionDumpFeature.getActionDump(colorMode, false);
            return 1;
        })).then(ClientCommandManager.literal((String)"force").executes(context -> {
            ComponentUtil.ColorMode colorMode = ComponentUtil.ColorMode.valueOf(StringArgumentType.getString((CommandContext)context, (String)"color_mode").toUpperCase());
            GetActionDumpFeature.getActionDump(colorMode, true);
            return 1;
        })))).then(ClientCommandManager.literal((String)"force").executes(context -> {
            GetActionDumpFeature.getActionDump(ComponentUtil.ColorMode.MINI_MESSAGE, true);
            return 1;
        })));
    }

    private static void debugLocate(String player) {
        ((CompletableFuture)LocateFeature.requestLocate(player).thenAccept(locate -> {
            Plot plot = locate.plot();
            String plotString = "null";
            if (plot != null) {
                plotString = plot.toReadableString();
            }
            Flint.getUser().sendMessage(new SuccessMessage("flint.command.flint.locate_test.success", new ComponentLike[]{Component.text((String)locate.player()), Component.text((String)locate.mode().getName()), Component.text((String)plotString), Component.text((String)locate.node().getName())}));
        })).exceptionally(throwable -> {
            Flint.getUser().sendMessage(new ErrorMessage("flint.command.flint.locate_test.fail", new ComponentLike[]{Component.text((String)throwable.getMessage())}));
            return null;
        });
    }
}

