/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.JSONable;
import dev.dfonline.flint.templates.Template;
import dev.dfonline.flint.templates.codeblock.Bracket;
import dev.dfonline.flint.templates.codeblock.CallFunction;
import dev.dfonline.flint.templates.codeblock.Control;
import dev.dfonline.flint.templates.codeblock.Else;
import dev.dfonline.flint.templates.codeblock.EntityAction;
import dev.dfonline.flint.templates.codeblock.EntityEvent;
import dev.dfonline.flint.templates.codeblock.Function;
import dev.dfonline.flint.templates.codeblock.GameAction;
import dev.dfonline.flint.templates.codeblock.IfEntity;
import dev.dfonline.flint.templates.codeblock.IfGame;
import dev.dfonline.flint.templates.codeblock.IfPlayer;
import dev.dfonline.flint.templates.codeblock.IfVariable;
import dev.dfonline.flint.templates.codeblock.PlayerAction;
import dev.dfonline.flint.templates.codeblock.PlayerEvent;
import dev.dfonline.flint.templates.codeblock.Process;
import dev.dfonline.flint.templates.codeblock.Repeat;
import dev.dfonline.flint.templates.codeblock.SelectObject;
import dev.dfonline.flint.templates.codeblock.SetVariable;
import dev.dfonline.flint.templates.codeblock.StartProcess;
import dev.dfonline.flint.templates.codeblock.abstracts.CodeBlockWithArguments;
import org.jetbrains.annotations.Nullable;

public abstract class CodeBlock
implements JSONable {
    @Nullable
    public static CodeBlock fromJson(JsonObject json) {
        String id = json.get("id").getAsString();
        if (id.equals("block")) {
            return switch (json.get("block").getAsString()) {
                case "player_action" -> new PlayerAction(json);
                case "if_var" -> new IfVariable(json);
                case "entity_action" -> new EntityAction(json);
                case "if_entity" -> new IfEntity(json);
                case "if_player" -> new IfPlayer(json);
                case "game_action" -> new GameAction(json);
                case "if_game" -> new IfGame(json);
                case "set_var" -> new SetVariable(json);
                case "control" -> new Control(json);
                case "else" -> new Else();
                case "repeat" -> new Repeat(json);
                case "call_func" -> new CallFunction(json);
                case "start_process" -> new StartProcess(json);
                case "func" -> new Function(json);
                case "process" -> new Process(json);
                case "event" -> new PlayerEvent(json);
                case "entity_event" -> new EntityEvent(json);
                case "select_obj" -> new SelectObject(json);
                default -> null;
            };
        }
        if (id.equals("bracket")) {
            return new Bracket(json);
        }
        return null;
    }

    public void printToChat() {
        Template.print(this.toString());
        CodeBlock codeBlock = this;
        if (codeBlock instanceof CodeBlockWithArguments) {
            CodeBlockWithArguments codeBlockWithArguments = (CodeBlockWithArguments)codeBlock;
            codeBlockWithArguments.getArguments().printToChat();
        }
    }

    public JsonObject toJSON(JsonObject current) {
        current.addProperty("id", this.getID());
        if (this.getID().equals("block")) {
            current.addProperty("block", this.getBlock());
        }
        if (!(current.has("args") || this instanceof Bracket || this instanceof Else)) {
            JsonObject args = new JsonObject();
            args.add("items", (JsonElement)new JsonArray());
            current.add("args", (JsonElement)args);
        }
        return current;
    }

    public String getID() {
        return "block";
    }

    public abstract String getBlock();
}

