/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.templates.argument;

import com.google.gson.JsonObject;
import dev.dfonline.flint.templates.argument.abstracts.Argument;
import org.apache.commons.lang3.StringUtils;

public class PotionArgument
extends Argument {
    private PotionType type;
    private int ticks;
    private int amplifier;

    public PotionType getType() {
        return this.type;
    }

    public void setType(PotionType type) {
        this.type = type;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public PotionArgument(JsonObject json, JsonObject data) {
        super(json);
        this.type = PotionType.getFromString(data.get("pot").getAsString());
        this.ticks = data.get("dur").getAsInt();
        this.amplifier = data.get("amp").getAsInt() + 1;
    }

    public PotionArgument(int slot, PotionType type, int amplifier, int ticks) {
        super(slot);
        this.type = type;
        this.amplifier = amplifier;
        this.ticks = ticks;
    }

    @Override
    protected JsonObject getData() {
        JsonObject data = new JsonObject();
        data.addProperty("pot", this.type.getName());
        data.addProperty("dur", (Number)this.ticks);
        data.addProperty("amp", (Number)(this.amplifier - 1));
        return data;
    }

    @Override
    public String getID() {
        return "pot";
    }

    @Override
    public String toString() {
        return "Potion [type=" + String.valueOf((Object)this.type) + ", ticks=" + this.ticks + ", amplifier=" + this.amplifier + " " + super.toString() + "]";
    }

    public static enum PotionType {
        ABSORPTION,
        CONDUIT_POWER,
        DOLPHINS_GRACE("Dolphin's Grace"),
        FIRE_RESISTANCE,
        HEALTH_BOOST,
        HASTE,
        HERO_OF_THE_VILLAGE("Hero of the Village"),
        INSTANT_HEALTH,
        JUMP_BOOST,
        INVISIBILITY,
        LUCK,
        NIGHT_VISION,
        REGENERATION,
        RESISTANCE,
        SATURATION,
        SLOW_FALLING,
        STRENGTH,
        SPEED,
        WATER_BREATHING,
        BAD_OMEN,
        BLINDNESS,
        DARKNESS,
        GLOWING,
        HUNGER,
        INFESTED,
        INSTANT_DAMAGE,
        LEVITATION,
        MINING_FATIGUE,
        NAUSEA,
        OOZING,
        POISON,
        RAID_OMEN,
        SLOWNESS,
        TRIAL_OMEN,
        BAD_LUCK,
        WEAKNESS,
        WEAVING,
        WIND_CHARGED,
        WITHER;

        public final String name;

        private PotionType(String name) {
            this.name = name;
        }

        private PotionType() {
            this.name = StringUtils.capitalize((String)this.name().replaceAll("_", " ").toLowerCase());
        }

        public String getName() {
            return this.name;
        }

        public static PotionType getFromString(String string) {
            for (PotionType potionType : PotionType.values()) {
                if (!string.equals(potionType.name)) continue;
                return potionType;
            }
            return null;
        }
    }
}

