/*
 * Decompiled with CFR 0.152.
 */
package dev.dfonline.flint.feature.impl;

import dev.dfonline.flint.Flint;
import dev.dfonline.flint.FlintAPI;
import dev.dfonline.flint.User;
import dev.dfonline.flint.feature.trait.ModeSwitchListeningFeature;
import dev.dfonline.flint.feature.trait.RenderedFeature;
import dev.dfonline.flint.hypercube.Mode;
import dev.dfonline.flint.hypercube.Node;
import dev.dfonline.flint.hypercube.Plot;
import dev.dfonline.flint.util.Logger;
import dev.dfonline.flint.util.ObjectUtil;
import dev.dfonline.flint.util.PaletteColor;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_9779;

public class StateDebugDisplayFeature
implements RenderedFeature,
ModeSwitchListeningFeature {
    private static final Logger LOGGER = Logger.of(StateDebugDisplayFeature.class);
    private static final int STARTING_Y = 5;
    private static final int STARTING_X = 5;

    @Override
    public void render(class_332 draw, class_9779 renderTickCounter) {
        User user = Flint.getUser();
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        texts.add((class_2561)class_2561.method_43470((String)"General State:").method_54663(PaletteColor.PURPLE.value()));
        texts.add(StateDebugDisplayFeature.formatValue("Node", ObjectUtil.toString(user.getNode(), Node::getName)));
        texts.add(StateDebugDisplayFeature.formatValue("Plot", ObjectUtil.toString(user.getPlot(), plot -> "" + plot.getId())));
        texts.add(StateDebugDisplayFeature.formatValue("Mode", ObjectUtil.toString(user.getMode(), Mode::getName)));
        texts.add(StateDebugDisplayFeature.formatValue("Dev Origin Location", ObjectUtil.toString(user.getPlot(), plot -> ObjectUtil.toString(plot.getDevOrigin(), Object::toString))));
        this.renderTexts(texts, draw);
    }

    private void renderTexts(ArrayList<class_2561> texts, class_332 draw) {
        int y = 5;
        for (int i = 0; i < texts.size(); ++i) {
            class_2561 text = texts.get(i);
            if (i == 0) {
                draw.method_27535(Flint.getClient().field_1772, text, 5, y, -1);
                y += 2;
            } else {
                draw.method_27535(Flint.getClient().field_1772, text, 10, y, -1);
            }
            Objects.requireNonNull(Flint.getClient().field_1772);
            y += 9 + 2;
        }
    }

    private static class_2561 formatValue(String key, String value) {
        return class_2561.method_43470((String)key).method_54663(PaletteColor.PURPLE.value()).method_10852((class_2561)class_2561.method_43470((String)" = ").method_54663(PaletteColor.GRAY_DARK.value())).method_10852((class_2561)class_2561.method_43470((String)value).method_54663(PaletteColor.PURPLE_LIGHT.value()));
    }

    @Override
    public boolean isEnabled() {
        return FlintAPI.isDebugging();
    }

    @Override
    public void onSwitchMode(Mode oldMode, Mode newMode) {
        if (Flint.getClient().field_1724 == null) {
            LOGGER.info("Null player :scream:", new Object[0]);
            return;
        }
        Flint.getUser().getPlayer().method_7353((class_2561)class_2561.method_43470((String)("Old: " + ObjectUtil.toString(oldMode, Mode::getName) + " -> New: " + ObjectUtil.toString(newMode, Mode::getName))), false);
        Flint.getUser().getPlayer().method_7353((class_2561)class_2561.method_43470((String)ObjectUtil.toString(Flint.getUser().getPlot(), Plot::toReadableString, "No Plot")), false);
    }
}

